/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.atlassian.fecru.gwt.admin.shared.repositories.EngineError;
import com.atlassian.fecru.gwt.admin.shared.repositories.EngineErrorState;
import com.atlassian.fugue.Option;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSetIndexingState;
import com.cenqua.fisheye.rep.EngineErrorFactory;
import com.cenqua.fisheye.rep.StopRequestedException;
import com.cenqua.fisheye.util.RecentHistory;
import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Queues;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class RepositoryStatus {
    private volatile String message;
    private final Queue<EngineError> engineErrors = Queues.synchronizedQueue((Queue)EvictingQueue.create((int)5));
    private volatile boolean engineHasError = false;
    private volatile boolean stopRequested;
    private volatile Date lastSlurpTime;
    private final String repositoryName;
    private final String messagePrefix;
    private volatile boolean locSlurpInProgress;
    private final RecentHistory recentActivities = new RecentHistory(10);
    private final ConcurrentMap<ChangeSetIndexingState, AtomicInteger> indexingStateCounts = new ConcurrentHashMap<ChangeSetIndexingState, AtomicInteger>();
    private volatile int totalChangesets = -1;
    private volatile boolean refreshing;
    private volatile boolean initialScanningComplete;
    private volatile boolean initialIndexingComplete;
    private volatile boolean initialCrucibleIndexingComplete;
    private volatile boolean upgrading;
    private volatile boolean active;
    private volatile boolean pollingDisabled;
    private volatile boolean indexingUpToDate;
    private volatile boolean paused;
    private volatile long pauseEndTime;

    public RepositoryStatus(String repositoryName) {
        this.repositoryName = repositoryName;
        this.messagePrefix = "Status change [" + repositoryName + "]: ";
        this.reset();
    }

    public void reset() {
        this.message = "";
        this.engineErrors.clear();
        this.engineHasError = false;
        this.refreshing = false;
        this.initialCrucibleIndexingComplete = true;
        this.stopRequested = false;
        this.lastSlurpTime = null;
        for (ChangeSetIndexingState state : ChangeSetIndexingState.values()) {
            this.indexingStateCounts.put(state, new AtomicInteger(0));
        }
        this.paused = false;
        this.pauseEndTime = Long.MIN_VALUE;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public String getMessage() {
        return this.message;
    }

    @Deprecated
    public String getEngineError() {
        return this.description(this.getEngineErrors().getCurrentError());
    }

    private String description(@Nullable EngineError error) {
        if (error != null) {
            return error.getTime().toString() + ": " + error.getMessage();
        }
        return "";
    }

    public EngineErrorState getEngineErrors() {
        return new EngineErrorState(new ArrayList<EngineError>(this.engineErrors), this.engineHasError);
    }

    public boolean getEngineHasError() {
        return this.engineHasError;
    }

    public boolean isRefreshing() {
        return this.refreshing;
    }

    public boolean isInitialCrucibleIndexingComplete() {
        return this.initialCrucibleIndexingComplete;
    }

    public void setInitialCrucibleIndexingComplete(boolean initialCrucibleIndexingComplete) {
        this.initialCrucibleIndexingComplete = initialCrucibleIndexingComplete;
    }

    public boolean isInitialIndexingComplete() {
        return this.initialIndexingComplete;
    }

    public void setInitialIndexingComplete(boolean initialIndexingComplete) {
        this.initialIndexingComplete = initialIndexingComplete;
    }

    public boolean isInitialScanningComplete() {
        return this.initialScanningComplete;
    }

    public void setInitialScanningComplete(boolean initialScanningComplete) {
        this.initialScanningComplete = initialScanningComplete;
    }

    public void setMessage(String message) {
        this.message = message;
        if (StringUtils.isNotBlank((String)message) && Logs.APP_LOG.isDebugEnabled()) {
            Logs.APP_LOG.debug((Object)(this.messagePrefix + message));
        }
    }

    public void setMessageForIndexingContent(Path path, int pathIndex, int count) {
        String msg = String.format("Indexing content: %s (%d of %d) %.0f%% complete.", path, pathIndex, count, Float.valueOf(this.asPercentage(pathIndex, count)));
        this.setMessage(msg);
    }

    private float asPercentage(float pathIndex, int count) {
        return count > 0 ? 100.0f * pathIndex / (float)count : 0.0f;
    }

    public boolean isMessageAvailable() {
        return this.message != null && this.message.length() > 0;
    }

    public void setEngineError(String message, URL helpLink) {
        if (StringUtils.isNotBlank((String)message)) {
            this.setEngineError(new EngineError(message, helpLink == null ? null : helpLink.toString()));
            if (Logs.APP_LOG.isDebugEnabled()) {
                Logs.APP_LOG.debug((Object)("Engine Error Set [" + this.repositoryName + "]: " + message));
            }
        } else {
            this.clearEngineError();
        }
    }

    public void setEngineError(String message) {
        this.setEngineError(message, null);
    }

    public void setEngineError(EngineError e2) {
        this.engineErrors.offer(e2);
        this.engineHasError = true;
    }

    public void clearEngineError() {
        this.engineHasError = false;
    }

    public void setEngineError(String prefix, Throwable ex, RepositoryConfig repositoryConfig) {
        if (SpringContext.isSetup()) {
            Collection<EngineErrorFactory> factories = SpringContext.getComponentsByClass(EngineErrorFactory.class);
            for (EngineErrorFactory f2 : factories) {
                try {
                    Option<EngineError> error = f2.create(ex, repositoryConfig);
                    if (!error.isDefined()) continue;
                    this.setEngineError((EngineError)error.get());
                    return;
                }
                catch (MalformedURLException e2) {
                    Logs.APP_LOG.error((Object)("Bad URL created by " + f2.getClass()), (Throwable)e2);
                }
            }
        }
        StringBuilder sb = new StringBuilder(prefix);
        for (Throwable t2 = ex; t2 != null; t2 = t2.getCause()) {
            sb.append("\n");
            sb.append(t2.getClass().getName());
            sb.append(": ");
            sb.append(t2.getMessage());
        }
        this.setEngineError(sb.toString());
    }

    public void setRefreshing(boolean refreshing) {
        this.refreshing = refreshing;
    }

    public boolean isStopRequested() {
        return this.stopRequested;
    }

    public void throwOnStopRequested() {
        if (this.stopRequested) {
            this.clearEngineError();
            this.setMessage("");
            throw new StopRequestedException();
        }
    }

    void setStopRequested(boolean stopRequested) {
        this.stopRequested = stopRequested;
    }

    public Date getLastSlurpTime() {
        return this.lastSlurpTime;
    }

    public void updateLastSlurpTime() {
        this.lastSlurpTime = new Date();
    }

    public boolean isLocSlurpInProgress() {
        return this.locSlurpInProgress;
    }

    public void setLocSlurpInProgress(boolean locSlurpInProgress) {
        this.locSlurpInProgress = locSlurpInProgress;
    }

    public RecentHistory getRecentActivities() {
        return this.recentActivities;
    }

    public ConcurrentMap<ChangeSetIndexingState, AtomicInteger> getIndexingStateCounts() {
        return this.indexingStateCounts;
    }

    public int getTotalChangesets() {
        return this.totalChangesets;
    }

    public void setTotalChangesets(int totalChangesets) {
        this.totalChangesets = totalChangesets;
    }

    public String toString() {
        return "RepositoryStatus{message='" + this.message + '\'' + ", engineError='" + this.engineErrors + '\'' + ", refreshing=" + this.refreshing + ", initialIndexingComplete=" + this.initialIndexingComplete + ", initialCrucibleIndexingComplete=" + this.initialCrucibleIndexingComplete + ", stopRequested=" + this.stopRequested + ", lastSlurpTime=" + this.lastSlurpTime + ", repositoryName='" + this.repositoryName + '\'' + ", messagePrefix='" + this.messagePrefix + '\'' + ", locSlurpInProgress=" + this.locSlurpInProgress + ", recentActivities=" + this.recentActivities + '}';
    }

    public boolean isDoingInitialSlurp() {
        return this.isScanInProgress() && this.getLastSlurpTime() == null;
    }

    public boolean isScanInProgress() {
        return !this.isInitialCrucibleIndexingComplete() || this.isRefreshing();
    }

    public boolean isScanning() {
        return !this.isInitialScanningComplete();
    }

    public boolean isIndexing() {
        return !this.isInitialIndexingComplete();
    }

    public int getTotalIndexingWork() {
        return this.getTotalChangesets() * 4;
    }

    public int getCompletedIndexingWork() {
        int total = 0;
        for (int stateOrdinal = ChangeSetIndexingState.INFILLED.ordinal(); stateOrdinal <= ChangeSetIndexingState.COMPLETE.ordinal(); ++stateOrdinal) {
            int factor = stateOrdinal - ChangeSetIndexingState.INFILLED.ordinal() + 1;
            ChangeSetIndexingState state = ChangeSetIndexingState.getState(stateOrdinal);
            total += ((AtomicInteger)this.indexingStateCounts.get((Object)state)).intValue() * factor;
        }
        return total;
    }

    public int getCompletedScanningWork() {
        int total = 0;
        for (int stateOrdinal = ChangeSetIndexingState.SCANNED.ordinal(); stateOrdinal <= ChangeSetIndexingState.COMPLETE.ordinal(); ++stateOrdinal) {
            ChangeSetIndexingState state = ChangeSetIndexingState.getState(stateOrdinal);
            total += ((AtomicInteger)this.indexingStateCounts.get((Object)state)).intValue();
        }
        return total;
    }

    private double calculatePercentage(int part, int total) {
        if (part > total) {
            total = part;
        }
        return total <= 0 ? 0.0 : 100.0 * (double)part / (double)total;
    }

    public double getScanningPercentage() {
        return this.calculatePercentage(this.getCompletedScanningWork(), this.getTotalChangesets());
    }

    public double getIndexingPercentage() {
        return this.calculatePercentage(this.getCompletedIndexingWork(), this.getTotalIndexingWork());
    }

    public void setNumEmptyChangesets(int numEmptyChangesets) {
        ((AtomicInteger)this.indexingStateCounts.get((Object)ChangeSetIndexingState.COMPLETE)).addAndGet(numEmptyChangesets);
    }

    public void incrementNumEmptyChangesets() {
        ((AtomicInteger)this.indexingStateCounts.get((Object)ChangeSetIndexingState.COMPLETE)).incrementAndGet();
    }

    public void setUpgrading(boolean upgrading) {
        this.upgrading = upgrading;
    }

    public boolean isUpgrading() {
        return this.upgrading;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isPollingDisabled() {
        return this.pollingDisabled;
    }

    public void setPollingDisabled(boolean pollingDisabled) {
        this.pollingDisabled = pollingDisabled;
    }

    public void setIndexingUpToDate(boolean indexingUpToDate) {
        this.indexingUpToDate = indexingUpToDate;
    }

    public boolean isIndexingUpToDate() {
        return this.indexingUpToDate;
    }

    public void startPause(long pauseEndTime) {
        this.paused = true;
        this.pauseEndTime = pauseEndTime;
    }

    public boolean isPaused() {
        return this.paused;
    }

    public long getPauseEndTime() {
        return this.pauseEndTime;
    }

    public void finishPause() {
        this.paused = false;
        this.pauseEndTime = Long.MIN_VALUE;
    }

    public long getPauseEndSeconds() {
        return (this.pauseEndTime - System.currentTimeMillis()) / 1000L;
    }
}

