/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.atlassian.fisheye.activity.ActivityItemList;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.search.SearchSortOrder;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.cache.RecentChangesParams2;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.web.ChangeSetHolder;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class RepositorySearcher {
    protected static final Comparator<ChangeSetHolder> CS_HOLDER_DATE_COMPARATOR = new Comparator<ChangeSetHolder>(){

        @Override
        public int compare(ChangeSetHolder o1, ChangeSetHolder o2) {
            if (o1 == null || o1.getChangeset() == null) {
                return -1;
            }
            if (o2 == null || o2.getChangeset() == null) {
                return 1;
            }
            int dateComp = o1.getDate().compareTo(o2.getDate());
            if (dateComp != 0) {
                return dateComp;
            }
            return o1.getOpaqueId().compareTo(o2.getOpaqueId());
        }
    };
    protected static final Comparator<ChangeSetHolder> REVERSE_CS_HOLDER_DATE_COMPARATOR = new Comparator<ChangeSetHolder>(){

        @Override
        public int compare(ChangeSetHolder o1, ChangeSetHolder o2) {
            return -CS_HOLDER_DATE_COMPARATOR.compare(o1, o2);
        }
    };

    public abstract ActivityItemList findActivityItems(ActivityItemSearchParams var1, Principal var2, ActivitySearchMonitor var3);

    protected RecentChangesParams2 buildParams(ActivityItemSearchParams itemParams) throws DbException {
        RecentChangesParams2 changesParams = new RecentChangesParams2();
        if (itemParams.getMaxDate() != null) {
            changesParams.setMaxDate(itemParams.getMaxDate().getTime());
        }
        if (itemParams.getMinDate() != null) {
            changesParams.setMinDate(itemParams.getMinDate().getTime());
        }
        if (itemParams.getSearchDirection() != null) {
            switch (itemParams.getSearchDirection()) {
                case TOWARDS_PAST: {
                    changesParams.setSearchDirection(0);
                    break;
                }
                case TOWARDS_FUTURE: {
                    changesParams.setSearchDirection(1);
                }
            }
        }
        return changesParams;
    }

    protected void optimiseResults(SearchSortOrder searchSortOrder, int maxReturn, List<ChangeSetHolder> results) {
        if (results.size() > 0 && searchSortOrder != SearchSortOrder.BY_SCORE) {
            Collections.sort(results, searchSortOrder == SearchSortOrder.TOWARDS_FUTURE ? CS_HOLDER_DATE_COMPARATOR : REVERSE_CS_HOLDER_DATE_COMPARATOR);
            if (results.size() > maxReturn) {
                results.subList(maxReturn, results.size()).clear();
            }
        }
    }
}

