/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.atlassian.fisheye.spi.admin.data.ImportMode;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.AllowRules;
import com.cenqua.fisheye.config.IncludeTree;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public abstract class RepositoryInfo {
    public static final long DEFAULT_TIMEOUT = -1L;
    private long startRev;
    private ImportMode importMode = ImportMode.NO_IMPORT;
    private long commandTimeout = -1L;
    private File repoTempDir;
    private RepositoryConfig config;

    protected RepositoryInfo(RepositoryConfig config) {
        this.config = config;
        this.repoTempDir = config.getTempDir();
        this.repoTempDir.mkdirs();
    }

    protected void setStartRev(long startRev) {
        this.startRev = startRev;
    }

    public long getStartRev() {
        return this.startRev;
    }

    protected void setImportMode(ImportMode importMode) {
        this.importMode = importMode;
    }

    public ImportMode getImportMode() {
        return this.importMode;
    }

    public RepositoryConfig getConfig() {
        return this.config;
    }

    public boolean isContentIndexingEnabled() {
        return this.config.isContentIndexingEnabled();
    }

    public boolean isHitHighlightingEnabled() {
        return this.config.isHitHighlightingEnabled();
    }

    public boolean isOfIndexableSize(Path path, long size, String revision) {
        return this.config.isOfIndexableSize(path, size, revision);
    }

    public long getMaxIndexableSize() {
        return this.config.getMaxIndexableSize();
    }

    public String getName() {
        return this.config.getName();
    }

    public String getRepositoryName() {
        return this.getName();
    }

    public File getRepoTempDir() {
        return this.repoTempDir;
    }

    public boolean isPathInRepo(Path localPath, long revision) {
        return (revision == -1L || revision >= this.startRev - 1L) && this.isPathInRepo(localPath);
    }

    public boolean isPathInRepo(String serverPath, long revision) {
        return this.isPathInRepo(this.getLocalPath(serverPath, revision), revision);
    }

    public boolean isPathInRepo(Path localPath) {
        if (localPath.isAbove()) {
            return false;
        }
        AllowRules allowRules = this.config.getAllowRules();
        if (allowRules != null) {
            Path path = localPath;
            while (!path.isRoot()) {
                if (allowRules.isIgnored(path)) {
                    return false;
                }
                path = path.getParent();
            }
        }
        return true;
    }

    protected void setCommandTimeout(long commandTimeout) {
        this.commandTimeout = commandTimeout;
    }

    public long getCommandTimeout() {
        return this.commandTimeout;
    }

    public abstract String getServerPath(Path var1, long var2);

    public abstract Path getLocalPath(String var1, long var2);

    public abstract String getRepositoryDescriptor();

    public List<Path> getIncludedPaths() {
        ArrayList<Path> paths = new ArrayList<Path>();
        for (IncludeTree includeTree : this.config.getAllowRules().getIncludes()) {
            paths.add(includeTree.getTree());
        }
        return paths;
    }
}

