/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DiffTextCache;
import com.cenqua.fisheye.rep.IndexableFileRevision;
import com.cenqua.fisheye.rep.impl.CommonFileRevisionInput;
import com.cenqua.fisheye.rep.impl.CommonIndexer;
import com.cenqua.fisheye.rep.impl.CommonRevInfoDAO;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Collection;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;

public class RepositoryIndexer {
    private final CommonIndexer indexer;
    private final LuceneConnection<LuceneIndexes> connection;
    private final RepositoryConfig repositoryConfig;

    public RepositoryIndexer(CommonIndexer indexer, LuceneConnection<LuceneIndexes> connection, RepositoryConfig repositoryConfig) {
        this.indexer = indexer;
        this.connection = connection;
        this.repositoryConfig = repositoryConfig;
    }

    public void indexContent(final IndexableFileRevision revision, final Reader content) throws IOException, DbException {
        this.connection.withWriter(LuceneIndexes.CONTENT, new LuceneConnection.WriterAction<Void>(){

            @Override
            public Void perform(IndexWriter idx) {
                try {
                    RepositoryIndexer.this.indexer.indexContents(idx, revision.getRevID(), revision, content, null);
                }
                catch (Exception e2) {
                    try {
                        Logs.APP_LOG.warn((Object)("could not index contents of " + revision.getPath() + " " + revision.getRevision() + ". Revision contents not indexed"), (Throwable)e2);
                    }
                    catch (Throwable throwable) {
                        IOHelper.close(content);
                        throw throwable;
                    }
                    IOHelper.close(content);
                }
                IOHelper.close(content);
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexContent(IndexableFileRevision revision, File contentFile, Charset encoding) throws IOException, DbException {
        FileInputStream contents;
        block3: {
            contents = null;
            try {
                if (contentFile.exists() && contentFile.isFile()) {
                    contents = new FileInputStream(contentFile);
                    BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)contents, encoding));
                    this.indexContent(revision, in);
                    break block3;
                }
                Logs.APP_LOG.warn((Object)("Not indexing " + revision.getRevInfoKey() + " as the exported content is not a file. Path:" + contentFile.getAbsolutePath() + " isFile:" + contentFile.isFile() + " isDirectory:" + contentFile.isDirectory()));
            }
            catch (Throwable throwable) {
                IOHelper.close(contents);
                throw throwable;
            }
        }
        IOHelper.close(contents);
    }

    public void deleteContent(Collection<Path> outdatedPaths) throws DbException {
        this.deleteDocuments(LuceneIndexes.CONTENT, outdatedPaths);
    }

    public boolean hasContentDocuments() {
        return this.connection.withIndexReader(LuceneIndexes.CONTENT, new LuceneConnection.IndexReaderAction<Boolean>(){

            @Override
            public Boolean perform(IndexReader indexReader) throws IOException, DbException {
                return indexReader.numDocs() > 0;
            }
        });
    }

    private void deleteDocuments(LuceneIndexes index, final Collection<Path> paths) throws DbException {
        this.connection.withWriter(index, new LuceneConnection.WriterAction<Void>(){

            @Override
            public Void perform(IndexWriter writer) throws IOException, DbException {
                RepositoryIndexer.this.indexer.deleteDocumentsForPaths(writer, paths);
                return null;
            }
        });
    }

    public void indexDiffText(final CommonFileRevisionInput revInfo, final int revid, final DiffTextCache diffTextCache, final CommonRevInfoDAO dao) throws DbException {
        this.connection.withWriter(LuceneIndexes.DIFFTEXT, new LuceneConnection.WriterAction<Void>(){

            @Override
            public Void perform(IndexWriter writer) throws IOException, DbException {
                RepositoryIndexer.this.indexer.insertNewFileRevision(writer, revInfo, revid, diffTextCache, dao, false, RepositoryIndexer.this.repositoryConfig.getMaxIndexableSize());
                return null;
            }
        });
    }
}

