/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.atlassian.fecru.upgrade.UpgradeManager;
import com.atlassian.fisheye.event.RepositoryCacheDeletedEventImpl;
import com.atlassian.fisheye.event.RepositoryStartedEventImpl;
import com.atlassian.fisheye.event.RepositoryStartingEventImpl;
import com.atlassian.fisheye.event.RepositoryStoppedEventImpl;
import com.atlassian.fisheye.event.RepositoryStoppingEventImpl;
import com.atlassian.fisheye.spi.admin.services.RepositoryStateException;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.infinitydb.DbStateChangeCallback;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.PassivateManager;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.ping.ChangesetCommentReindexRequest;
import com.cenqua.fisheye.rep.ping.CrossRepositoryRescanRequest;
import com.cenqua.fisheye.rep.ping.CrucibleIncrementalRequest;
import com.cenqua.fisheye.rep.ping.CrucibleReindexRequest;
import com.cenqua.fisheye.rep.ping.IncrementalPingRequest;
import com.cenqua.fisheye.rep.ping.LinecountReindexRequest;
import com.cenqua.fisheye.rep.ping.OneOffPingRequest;
import com.cenqua.fisheye.rep.ping.PingManager;
import com.cenqua.fisheye.rep.ping.PingRequest;
import com.cenqua.fisheye.rep.ping.RescanRequest;
import com.cenqua.fisheye.rep.ping.SynchronousCallback;
import com.cenqua.fisheye.util.Disposable;
import com.cenqua.fisheye.util.Disposer;
import com.google.common.base.Function;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;

public class RepositoryHandle {
    private static final Logger log = Logs.loggerFor(RepositoryHandle.class);
    private TimerTask incrementalTimerTask;
    private long desiredInfDbCacheSize;
    private long currentDbCacheSize;
    private static final long INITIAL_PING_DELAY = 2000L;
    private final PassivateManager passivateManager;
    private final String name;
    private RepositoryConfig cfg;
    private RepositoryEngine engine;
    private volatile State mState = State.STATE_STOPPED;
    private final Object mLock = new Object();
    private int mAcquireCount = 0;
    private boolean needsPassivation = false;
    private boolean mDisableBackgroundUpdaterOnInit = false;
    private IndexingContext indexingContext;
    private boolean neverStarted = true;
    private final List<PingRequest> queuedRequests = new ArrayList<PingRequest>();
    private volatile boolean processingRequests = false;
    private long lastModified = AppConfig.START_TIME;
    private static final long LAST_MODIFIED_CACHE_PERIOD_MS = 5000L;
    private long lastModifiedExpiryTime = 0L;
    private final ReentrantLock repositoryWriteAccess = new ReentrantLock();
    private static final Timer REPOSITORY_SCAN_TIMER = new Timer("PingerTimer", true);
    private final IncrementalPingRequest incrementalRequest = new IncrementalPingRequest(this, new Runnable(){

        @Override
        public void run() {
            long pollPeriod = RepositoryHandle.this.getEffectivePollPeriod();
            if (pollPeriod > 0L) {
                RepositoryHandle.this.getStatus().setPollingDisabled(false);
                long lastStartTime = RepositoryHandle.this.incrementalRequest.getLastStartTime();
                if (lastStartTime <= 0L) {
                    RepositoryHandle.this.scheduleIncrementalIndexing(pollPeriod);
                } else {
                    long nextStartTime = lastStartTime + pollPeriod;
                    long delay = nextStartTime - System.currentTimeMillis();
                    if (delay < 0L) {
                        delay = 0L;
                    }
                    RepositoryHandle.this.scheduleIncrementalIndexing(delay);
                }
            } else {
                RepositoryHandle.this.getStatus().setPollingDisabled(true);
            }
        }
    });
    public static final Function<RepositoryHandle, String> TO_REPO_NAME = new Function<RepositoryHandle, String>(){

        public String apply(RepositoryHandle handle) {
            return handle.getName();
        }
    };

    public RepositoryHandle(String name, RepositoryConfig config, IndexingContext indexingContext, PassivateManager passivateManager) {
        this.name = name;
        this.cfg = config;
        this.indexingContext = indexingContext;
        this.passivateManager = passivateManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queuePingRequest(PingRequest request) throws StateException {
        if (!this.isRunning()) {
            log.debug((Object)("Ignoring ping request " + request.getDescription() + " as repository " + this.getName() + " is not running"));
            return;
        }
        List<PingRequest> list = this.queuedRequests;
        synchronized (list) {
            for (PingRequest queued : this.queuedRequests) {
                if (!queued.canCombine(request)) continue;
                queued.combine(request);
                return;
            }
            this.queuedRequests.add(request);
            if (!this.processingRequests) {
                this.processingRequests = true;
                Disposer.pushThreadInstance();
                try {
                    RepositoryEngine engine = this.acquireEngine();
                    boolean useInitialPool = engine.wantInitialSlurp();
                    PingManager.getExecutor(useInitialPool).execute(new Runnable(){

                        @Override
                        public void run() {
                            RepositoryHandle.this.processPingRequests();
                        }
                    });
                }
                catch (StateException e2) {
                    this.processingRequests = false;
                }
                catch (RejectedExecutionException e3) {
                    log.error((Object)"Ping Request Queue processing was rejected");
                    this.processingRequests = false;
                }
                finally {
                    Disposer.popThreadInstance();
                }
            }
        }
    }

    public void scheduleIncrementalIndexing(long delay) {
        if (this.incrementalTimerTask != null) {
            this.incrementalTimerTask.cancel();
        }
        this.incrementalRequest.resetLastStartTime();
        this.incrementalTimerTask = new TimerTask(){

            @Override
            public void run() {
                try {
                    RepositoryHandle.this.queuePingRequest(RepositoryHandle.this.incrementalRequest);
                }
                catch (StateException e2) {
                    log.debug((Object)("Unable to run scheduled ping request as repository " + RepositoryHandle.this.getName() + " is no longer running"), (Throwable)((Object)e2));
                }
            }
        };
        REPOSITORY_SCAN_TIMER.schedule(this.incrementalTimerTask, delay);
    }

    private void processPingRequests() {
        PingRequest request;
        while ((request = this.getNextPingRequest()) != null) {
            if (!this.processingRequests) {
                throw new IllegalStateException("Indexing cannot be performed without locking repository handle");
            }
            request.process();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PingRequest getNextPingRequest() {
        List<PingRequest> list = this.queuedRequests;
        synchronized (list) {
            if (this.queuedRequests.isEmpty()) {
                this.processingRequests = false;
                if (CrossRepositoryRescanRequest.isRepositoryBeingReindexed(this.name)) {
                    try {
                        this.requestCrossRepositoryRescan(false);
                    }
                    catch (StateException stateException) {
                        // empty catch block
                    }
                }
                return null;
            }
            return this.queuedRequests.remove(0);
        }
    }

    public String getName() {
        return this.name;
    }

    public boolean isDisableBackgroundUpdaterOnInit() {
        return this.mDisableBackgroundUpdaterOnInit;
    }

    public void setDisableBackgroundUpdaterOnInit(boolean disableBackgroundUpdaterOnInit) {
        this.mDisableBackgroundUpdaterOnInit = disableBackgroundUpdaterOnInit;
    }

    public boolean isRunning() {
        return this.mState == State.STATE_RUNNING;
    }

    public boolean isStopped() {
        return this.mState == State.STATE_STOPPED;
    }

    public boolean isStopping() {
        return this.mState == State.STATE_STOPPING;
    }

    public boolean isStarting() {
        return this.mState == State.STATE_STARTING;
    }

    public String getStateDescription() {
        String description;
        switch (this.mState) {
            case STATE_RUNNING: {
                description = "Running";
                break;
            }
            case STATE_STOPPING: {
                description = "Stopping";
                break;
            }
            case STATE_STOPPED: {
                description = "Stopped";
                break;
            }
            case STATE_STARTING: {
                description = "Starting";
                break;
            }
            default: {
                description = "UNKNOWN";
            }
        }
        return description;
    }

    public String getDetailedStateDescription() {
        switch (this.mState) {
            case STATE_RUNNING: {
                if (this.getStatus().getEngineHasError()) {
                    return "Error";
                }
                if (!this.getStatus().isInitialCrucibleIndexingComplete() || this.getStatus().isLocSlurpInProgress()) {
                    return "Scanning";
                }
                return null;
            }
            case STATE_STOPPING: {
                return "Stopping";
            }
            case STATE_STOPPED: {
                return "Stopped";
            }
            case STATE_STARTING: {
                return "Starting";
            }
        }
        return "UNKNOWN";
    }

    public boolean tryStop(long timeout) {
        this.stop();
        long end = System.currentTimeMillis() + timeout;
        do {
            if (this.isStopped()) {
                return true;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e2) {
                break;
            }
        } while (System.currentTimeMillis() <= end);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isStopped() || this.isStopping()) {
                return;
            }
            this.mState = State.STATE_STOPPING;
            this.indexingContext.getEventPublisher().publish((Object)new RepositoryStoppingEventImpl(this.getName()));
            this.getStatus().setStopRequested(true);
            this.engine.requestStop();
            log.info((Object)("STOP requested on " + this.name));
            this.completeStopping();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean run(RepositoryConfig config) throws StateException, ConfigException, DbException, IOException {
        UpgradeManager upgradeManager = (UpgradeManager)SpringContext.getComponent("upgradeManager");
        Object object = this.mLock;
        synchronized (object) {
            this.cfg = config;
            if (!this.cfg.isEnabled()) {
                throw new ConfigException("Repository [" + this.getName() + "] is not enabled");
            }
            if (this.mState != State.STATE_STOPPED) {
                throw new StateException("Repository [" + this.getName() + "] is not stopped");
            }
            RepositoryEngine newEngine = null;
            try {
                this.mState = State.STATE_STARTING;
                this.indexingContext.getEventPublisher().publish((Object)new RepositoryStartingEventImpl(this.getName(), this.neverStarted));
                this.processingRequests = false;
                this.getStatus().reset();
                newEngine = this.cfg.createRepositoryEngine(upgradeManager, this.indexingContext);
                this.desiredInfDbCacheSize = this.passivateManager.repositoryBecameRunnable(this);
                newEngine.setDesiredInfDbCacheSize(this.desiredInfDbCacheSize);
                newEngine.start(new DbStateChangeCallback(){

                    @Override
                    public void onOpen(long cacheSize) {
                        RepositoryHandle.this.currentDbCacheSize = cacheSize;
                        log.debug((Object)("DB open on " + RepositoryHandle.this.name));
                        RepositoryHandle.this.passivateManager.updateOnDbOpen(RepositoryHandle.this, cacheSize);
                    }

                    @Override
                    public void onClose(long cacheSize) {
                        RepositoryHandle.this.currentDbCacheSize = 0L;
                        log.debug((Object)("DB close on " + RepositoryHandle.this.name));
                        RepositoryHandle.this.passivateManager.updateOnDbClose(RepositoryHandle.this, cacheSize);
                    }
                });
                this.needsPassivation = false;
                this.engine = newEngine;
                this.mState = State.STATE_RUNNING;
                this.indexingContext.getEventPublisher().publish((Object)new RepositoryStartedEventImpl(this.getName(), this.neverStarted));
                this.neverStarted = false;
            }
            finally {
                if (this.mState != State.STATE_RUNNING) {
                    this.mState = State.STATE_STOPPED;
                    this.indexingContext.getEventPublisher().publish((Object)new RepositoryStoppedEventImpl(this.getName()));
                    if (newEngine != null) {
                        log.debug((Object)"Force-closing engine after failed startup");
                        newEngine.forceClose();
                    }
                }
            }
            this.schedulePingsAfterStartup();
            return this.mState == State.STATE_RUNNING;
        }
    }

    private void schedulePingsAfterStartup() throws StateException {
        this.requestCrossRepositoryRescan(false);
        if (this.getEffectivePollPeriod() > 0L) {
            this.scheduleIncrementalIndexing(2000L);
            this.getStatus().setPollingDisabled(false);
        } else {
            this.getStatus().setPollingDisabled(true);
        }
    }

    public long getCurrentDbCacheSize() {
        return this.currentDbCacheSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getEffectivePollPeriod() {
        long pollPeriod = 0L;
        RepositoryEngine eng = null;
        try {
            eng = this.acquire();
            if (!this.isDisableBackgroundUpdaterOnInit()) {
                pollPeriod = eng.getEffectivePollPeriod();
            }
        }
        catch (StateException stateException) {
        }
        finally {
            if (eng != null) {
                this.release();
            }
        }
        return pollPeriod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RepositoryEngine acquireEngine() throws StateException {
        this.validateRepositoryRunning();
        Object object = this.mLock;
        synchronized (object) {
            Disposer disposer = Disposer.threadInstance();
            RepositoryEngine eng = this.acquire();
            disposer.add(new Disposable(){

                @Override
                public void dispose() {
                    RepositoryHandle.this.release();
                }
            });
            return eng;
        }
    }

    public <T> T withEngine(Function<RepositoryEngine, T> function) throws StateException {
        Disposer.pushThreadInstance();
        try {
            Object object = function.apply((Object)this.acquireEngine());
            return (T)object;
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RepositoryEngine acquire() throws StateException {
        this.validateRepositoryRunning();
        long ts1 = System.currentTimeMillis();
        Object object = this.mLock;
        synchronized (object) {
            this.validateRepositoryRunning();
            ++this.mAcquireCount;
            if (log.isDebugEnabled()) {
                log.debug((Object)("acquire engine on " + this.getName() + ", count=" + this.mAcquireCount + ", waited " + (System.currentTimeMillis() - ts1) + " ms to acquire."));
            }
            this.passivateManager.updateOnAcquire(this, this.engine.getInternalRevisionCache().getInfDb().isOpen());
            return this.engine;
        }
    }

    private void validateRepositoryRunning() throws StateException {
        if (this.mState != State.STATE_RUNNING) {
            throw new StateException("Repository " + this.getName() + " is not running");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteIndex() throws StateException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mState != State.STATE_STOPPED) {
                throw new StateException("Repository is not stopped");
            }
            this.cfg.deleteCache();
            this.indexingContext.getEventPublisher().publish((Object)new RepositoryCacheDeletedEventImpl(this.getName()));
        }
    }

    public RepositoryConfig getCfg() {
        return this.cfg;
    }

    public RepositoryStatus getStatus() {
        return this.cfg.getStatus();
    }

    public boolean isIndexBehindSchedule() throws StateException {
        if (!this.isRunning()) {
            return false;
        }
        return this.withEngine(new Function<RepositoryEngine, Boolean>(){

            public Boolean apply(RepositoryEngine repositoryEngine) {
                return repositoryEngine.isIndexBehindSchedule();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkForPassivation() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.isRunning()) {
                if (!this.needsPassivation) {
                    if (this.passivateManager.needsPassivation(this)) {
                        log.debug((Object)("request passivate (from passivate manager) on " + this.getName()));
                        this.needsPassivation = true;
                    } else {
                        long desiredSize = this.passivateManager.getCacheSize();
                        if (desiredSize != this.engine.getDesiredInfDbCacheSize()) {
                            log.debug((Object)("request passivate (cache resize) on " + this.getName()));
                            this.engine.setDesiredInfDbCacheSize(desiredSize);
                            this.desiredInfDbCacheSize = desiredSize;
                            this.needsPassivation = true;
                        }
                    }
                }
                if (this.needsPassivation && this.mAcquireCount == 0) {
                    log.debug((Object)("soft passivate (immediate) on " + this.getName()));
                    this.engine.passivate();
                    this.needsPassivation = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release() {
        long ts1 = System.currentTimeMillis();
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAcquireCount > 0) {
                --this.mAcquireCount;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("release engine on " + this.getName() + ", count=" + this.mAcquireCount + " waited " + (System.currentTimeMillis() - ts1) + " ms to release"));
            }
            if (this.mAcquireCount == 0) {
                InfinityDbHandle infDb;
                if (this.needsPassivation) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("soft passivate (on release) on " + this.getName()));
                    }
                    this.engine.passivate();
                    this.needsPassivation = false;
                }
                this.passivateManager.updateOnRelease(this, !(infDb = this.engine.getInternalRevisionCache().getInfDb()).isOpen());
            }
            this.completeStopping();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void completeStopping() {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAcquireCount == 0 && this.mState == State.STATE_STOPPING) {
                try {
                    if (this.engine != null) {
                        log.debug((Object)("STOPPING " + this.name));
                        this.engine.forceClose();
                    }
                }
                catch (Throwable e2) {
                    log.warn((Object)("problem stopping repository " + this.name), e2);
                }
                finally {
                    this.mState = State.STATE_STOPPED;
                    this.passivateManager.repositoryNoLongerRunnable(this);
                    this.indexingContext.getEventPublisher().publish((Object)new RepositoryStoppedEventImpl(this.getName()));
                    this.engine = null;
                }
            }
        }
    }

    public void requestCrucibleIncrementalScan() throws StateException {
        this.queuePingRequest(new CrucibleIncrementalRequest(this));
    }

    public void requestCrucibleReindex() throws StateException {
        this.requestCrucibleReindex(false);
    }

    public void requestCrucibleReindex(boolean synchronous) throws StateException {
        if (synchronous) {
            SynchronousCallback sync = new SynchronousCallback();
            this.queuePingRequest(new CrucibleReindexRequest(this, sync));
            sync.await();
        } else {
            this.queuePingRequest(new CrucibleReindexRequest(this, null));
        }
    }

    public void requestLinecountReindex() throws StateException {
        this.queuePingRequest(new LinecountReindexRequest(this));
    }

    public void requestCrossRepositoryRescan(boolean forceReindex) throws StateException {
        this.queuePingRequest(new CrossRepositoryRescanRequest(this, forceReindex));
    }

    public void requestChangesetCommentReindex() throws StateException {
        this.queuePingRequest(new ChangesetCommentReindexRequest(this));
    }

    public void rescan(String start, String end) throws StateException {
        this.queuePingRequest(new RescanRequest(this, start, end));
    }

    public void oneOffScan(boolean synchronous) throws StateException {
        if (synchronous) {
            SynchronousCallback sync = new SynchronousCallback();
            this.queuePingRequest(new OneOffPingRequest(this, sync));
            sync.await();
        } else {
            this.queuePingRequest(new OneOffPingRequest(this, null));
        }
    }

    public long getLastModified() {
        if (this.mState == State.STATE_RUNNING && this.lastModifiedExpiryTime < System.currentTimeMillis()) {
            try {
                RepositoryEngine eng = this.acquire();
                try {
                    this.lastModifiedExpiryTime = System.currentTimeMillis() + 5000L;
                    this.lastModified = Math.max(this.lastModified, eng.getRevisionCache().getLastModifiedDate());
                }
                finally {
                    this.release();
                }
            }
            catch (StateException eng) {
            }
            catch (DbException e2) {
                log.error((Object)("Error calculating last modified date from revision cache for repository " + this.name), (Throwable)e2);
            }
        }
        return this.lastModified;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isPipelined() {
        return this.getCfg().getRepositoryType().equals((Object)ScmType.SVN);
    }

    public boolean isChangesetIdNumeric() {
        ScmType type = this.getCfg().getRepositoryType();
        return type.isChangesetIdNumeric();
    }

    public boolean accessRepository(long waitTime) throws DbException {
        try {
            return this.repositoryWriteAccess.tryLock(waitTime, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e2) {
            log.warn((Object)"Unable to acquire repository access ", (Throwable)e2);
            return false;
        }
    }

    public void releaseRepository() {
        if (this.repositoryWriteAccess.isLocked()) {
            this.repositoryWriteAccess.unlock();
        }
    }

    public static class StateException
    extends RepositoryStateException {
        public StateException(String message) {
            super(message);
        }
    }

    public static enum State {
        STATE_STOPPED,
        STATE_STARTING,
        STATE_RUNNING,
        STATE_STOPPING;

    }
}

