/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.atlassian.fecru.upgrade.UpgradeManager;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.bucket.BucketGraph;
import com.atlassian.fisheye.event.RepositoryScanningPausedEventImpl;
import com.atlassian.fisheye.event.RepositoryScanningResumedEventImpl;
import com.atlassian.fisheye.event.RepositoryUpdatedEventImpl;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.crucible.model.managers.impl.DefaultReviewManager;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.cache.InternalRevisionCache;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.cache.RevisionCacheProperties;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.csindex.ChangesetStatsCalculator;
import com.cenqua.fisheye.infinitydb.DbStateChangeCallback;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.rep.BlameAndLinecountCalculator;
import com.cenqua.fisheye.rep.CacheWarmer;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.CommonRepositoryScanner;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.IndexingState;
import com.cenqua.fisheye.rep.LogicalPathMatcher;
import com.cenqua.fisheye.rep.NullLogicalPathMatcher;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.blame.BaseBlameAndLinecountCalculator;
import com.cenqua.fisheye.rep.impl.CommonIndexer;
import com.cenqua.fisheye.rep.impl.ReviewInfoDAO;
import com.cenqua.fisheye.search.QueryBuilder;
import com.cenqua.fisheye.search.SearchManager;
import com.cenqua.fisheye.search.query.BaseQueryEvaluator;
import com.cenqua.fisheye.search.query.QueryEvaluator;
import com.cenqua.fisheye.web.dirtree.DirTreeCache;
import java.io.File;
import java.io.IOException;

public abstract class RepositoryEngine {
    protected static final long DEFAULT_PAUSE_PERIOD = 120000L;
    public static final int NO_PAUSE = 0;
    private static final int HOUR_IN_MILLIS = 3600000;
    private static final CacheWarmer WARMER = new CacheWarmer();
    private final RepositoryConfig cfg;
    private final IndexingContext indexingContext;
    private final File cacheDir;
    private final File revCacheDir;
    private final File propFile;
    private SearchManager searchManager;
    private LuceneConnection<LuceneIndexes> indexConnection;
    private DirTreeCache dtcache = null;
    private long desiredInfDbCacheSize = 0x500000L;
    private BucketGraph bucketGraph = null;
    private InfinityDbHandle dbh;
    private final CommonIndexer indexer;
    private BlameAndLinecountCalculator blameAndLinecountCalculator;
    private LicenseEnforcer licenseEnforcer;
    private UpgradeManager upgradeManager;
    private RevisionCacheProperties props;

    protected RepositoryEngine(RepositoryConfig cfg, UpgradeManager upgradeManager, IndexingContext indexingContext) {
        this.cfg = cfg;
        this.upgradeManager = upgradeManager;
        this.cacheDir = cfg.getCacheDir();
        this.revCacheDir = cfg.getRevCacheDir();
        this.propFile = cfg.getCachePropertiesFile();
        this.indexer = new CommonIndexer();
        this.indexingContext = indexingContext;
    }

    public BlameAndLinecountCalculator getLinecountCalculator() {
        if (this.blameAndLinecountCalculator == null) {
            this.blameAndLinecountCalculator = this.initLinecountCalculator();
        }
        return this.blameAndLinecountCalculator;
    }

    protected BlameAndLinecountCalculator initLinecountCalculator() {
        return new BaseBlameAndLinecountCalculator(this);
    }

    public LicenseEnforcer getLicenseEnforcer() {
        return this.licenseEnforcer;
    }

    public void setLicenseEnforcer(LicenseEnforcer licenseEnforcer) {
        this.licenseEnforcer = licenseEnforcer;
    }

    public RepositoryConfig getCfg() {
        return this.cfg;
    }

    public IndexingContext getIndexingContext() {
        return this.indexingContext;
    }

    public SearchManager getSearchManager() {
        return this.searchManager;
    }

    public String getName() {
        return this.cfg.getName();
    }

    public File getCacheDir() {
        return this.cacheDir;
    }

    public LuceneConnection<LuceneIndexes> getIndexConnection() {
        return this.indexConnection;
    }

    public InfinityDbHandle getDatabaseHandle() {
        return this.dbh;
    }

    public RepositoryStatus getStatus() {
        return this.cfg.getStatus();
    }

    public int getPipelineBatchSize() {
        return FishEyeSysProps.PIPELINE_BATCH_CSLIMIT;
    }

    public final void start() throws IOException, DbException, ConfigException {
        this.start(null);
    }

    public final void start(DbStateChangeCallback dbStateChangeCallback) throws IOException, DbException, ConfigException {
        boolean reslurp = false;
        if (!this.cfg.isCacheValid()) {
            reslurp = true;
            this.props = this.cfg.createNewCache();
        } else {
            this.props = RevisionCacheProperties.readExisting(this.propFile);
            this.checkCacheVersion();
            if (this.isCacheUpgradeRequired() && !this.upgradeManager.isRepositoryUpgradable(this.getCfg().getRepositoryType(), this.getDiskCacheVersion(), this.cfg.getSoftwareCacheVersion())) {
                reslurp = true;
                this.props = this.cfg.createNewCache();
            }
        }
        this.indexConnection = new LuceneConnection(this.cacheDir, this.cfg.getMasterAnalyzer(), (LuceneConnection.IndexConfig[])LuceneIndexes.activeValues());
        if (reslurp) {
            this.indexConnection.createIndexes();
        } else {
            this.indexConnection.killLuceneLocks();
        }
        File dbfile = new File(this.revCacheDir, "data.bin");
        this.dbh = new InfinityDbHandle(dbfile, this.desiredInfDbCacheSize, dbStateChangeCallback);
        long cacheSerial = this.props.getSerial();
        this.doStart(cacheSerial);
        if (this.isCacheUpgradeRequired()) {
            this.upgradeManager.upgradeRepository(this, this.props, this.cfg.getSoftwareCacheVersion());
            if (this.isCacheUpgradeRequired()) {
                throw new ConfigException("Upgrade failed for the repository: " + this.getName());
            }
        }
        this.getRevisionCache().setQuicksearchReslurped(reslurp);
        if (reslurp) {
            this.getRevisionCache().setMetadataVersion(29L);
            this.getCrossRepLuceneIndex().deleteRepFromIndex(this.getName());
        }
        this.getRevisionCache().syncChangeSetCountsPerState();
        this.initialiseRepositoryStatus();
        if (this.isMetadataIndexObsolete()) {
            this.resetRepositoryMetadataIndex();
            this.getInternalRevisionCache().setIndexingPhase(IndexingState.INDEXING_METADATA);
        }
        this.searchManager = this.createSearchManager();
        this.dtcache = new DirTreeCache(this);
        this.getRevisionCache().addListener(new RevisionCache.CacheListener(){

            @Override
            public void cacheUpdated() {
                RepositoryEngine.this.onCacheUpdated();
            }
        });
        WARMER.sendMessage(this.getName());
        Logs.APP_LOG.debug((Object)("Started engine " + this.getName()));
    }

    protected void initialiseRepositoryStatus() {
        boolean initialIndexingComplete = this.getRevisionCache().isInitialIndexingComplete();
        this.getStatus().setInitialIndexingComplete(initialIndexingComplete);
        this.getStatus().setInitialScanningComplete(initialIndexingComplete);
        this.getStatus().setInitialCrucibleIndexingComplete(this.getRevisionCache().isInitialCrucibleIndexingComplete());
        this.getStatus().setIndexingUpToDate(initialIndexingComplete);
    }

    private void resetRepositoryMetadataIndex() {
        Logs.APP_LOG.info((Object)("[" + this.getName() + "] " + " Upgrading diff and content indexes"));
        InternalRevisionCache<? extends ChangeSet> cache = this.getInternalRevisionCache();
        cache.getLuceneConnection().close();
        cache.getLuceneConnection().recreateIndex(LuceneIndexes.CONTENT);
        cache.setMetadataVersion(29L);
        CrossRepLuceneIndex crossRepLuceneIndex = this.getCrossRepLuceneIndex();
        crossRepLuceneIndex.deleteRepFromIndex(this.getName());
        this.resetScmMetaData();
    }

    private boolean isMetadataIndexObsolete() {
        long metadataVersion = this.getInternalRevisionCache().getMetadataVersion();
        return metadataVersion != 0L && 29L != metadataVersion;
    }

    public void passivate() {
        try {
            this.indexConnection.close();
            this.dbh.close();
            this.dtcache.invalidate();
            this.getInternalRevisionCache().getStringTables().clearCaches();
        }
        catch (Throwable e2) {
            Logs.APP_LOG.warn((Object)"problem passivating repository", e2);
        }
    }

    void setDesiredInfDbCacheSize(long size) {
        this.desiredInfDbCacheSize = size;
        if (this.dbh != null) {
            this.dbh.setDesiredCacheSize(size);
        }
    }

    protected long getDesiredInfDbCacheSize() {
        return this.desiredInfDbCacheSize;
    }

    public DirTreeCache getDirTreeCache() {
        return this.dtcache;
    }

    private void onCacheUpdated() {
        if (this.getStatus().isStopRequested()) {
            return;
        }
        this.dtcache.invalidate();
        WARMER.sendMessage(this.getName());
        this.indexingContext.getEventPublisher().publish((Object)new RepositoryUpdatedEventImpl(this.getName()));
    }

    public BucketGraph getBucketGraph() {
        if (this.bucketGraph == null) {
            this.bucketGraph = new BucketGraph(this.getInternalRevisionCache().getInfDb(), this.getName(), this.getRevisionCache().isCaseSensitive(), this.getInternalRevisionCache().getStringTables(), this.getRevisionCache());
        }
        return this.bucketGraph;
    }

    public LuceneConnection<CrossRepLuceneIndexes> getCrossRepLuceneConnection() {
        return this.getCrossRepLuceneIndex().getConnection();
    }

    public void forceClose() {
        this.getStatus().finishPause();
        if (this.indexConnection != null) {
            this.indexConnection.close();
        }
        try {
            if (this.dbh != null) {
                this.dbh.close();
            }
        }
        catch (IOException e2) {
            Logs.APP_LOG.error((Object)"Unable to close database", (Throwable)e2);
        }
        Logs.APP_LOG.debug((Object)("Closed engine " + this.getName()));
    }

    public abstract void requestStop();

    public void doReviewSlurp(boolean reindex) throws DbException {
        ReviewInfoDAO dao = new ReviewInfoDAO(DefaultReviewManager.get(), this.getInternalRevisionCache(), this.getName(), this.getStatus());
        boolean updated = dao.slurp(reindex);
        if (updated) {
            this.getRevisionCache().touchLastModifiedDate();
        }
    }

    public void doLinecountReindex() throws DbException {
        this.getBucketGraph().reindex(this.getLinecountCalculator(), this.getStatus());
    }

    public LogicalPathMatcher getPathMatcher() {
        return new NullLogicalPathMatcher();
    }

    public abstract String getLink(RevInfoKey var1);

    public int getDiskCacheVersion() {
        return this.props.getVersion();
    }

    public boolean isCacheUpgradeRequired() {
        return this.cfg.getSoftwareCacheVersion() > this.getDiskCacheVersion();
    }

    public void checkCacheVersion() throws ConfigException {
        int diskCacheVersion = this.getDiskCacheVersion();
        int softwareCacheVersion = this.cfg.getSoftwareCacheVersion();
        if (softwareCacheVersion < diskCacheVersion) {
            String message = "The repository version, " + diskCacheVersion + ", of repository " + this.getName() + " is newer than that currently supported, " + softwareCacheVersion;
            this.getStatus().setEngineError(message);
            throw new ConfigException(message);
        }
    }

    protected abstract void doStart(long var1) throws IOException, DbException, ConfigException;

    public abstract RevisionCache<? extends ChangeSet> getRevisionCache();

    public abstract InternalRevisionCache<? extends ChangeSet> getInternalRevisionCache();

    public abstract void requestFullscan();

    public final void slurp() throws DbException, ConfigException {
        RepositoryStatus status = this.getStatus();
        status.setRefreshing(true);
        status.setActive(true);
        try {
            boolean doCruIncremental = !status.isInitialCrucibleIndexingComplete();
            this.doSlurp();
            if (this.isLicenseLimitReached()) {
                status.setEngineError("License limit reached, indexing stopped");
            }
            if (AppConfig.isCrucible() && doCruIncremental && status.isIndexingUpToDate() && HibernateUtil.isRunning() && !status.isStopRequested()) {
                this.doReviewSlurp(false);
            }
            if (status.isInitialIndexingComplete() && !status.isInitialCrucibleIndexingComplete()) {
                this.getRevisionCache().markInitialCrucibleIndexingComplete();
            }
        }
        finally {
            status.setRefreshing(false);
            status.updateLastSlurpTime();
        }
    }

    protected abstract void doSlurp() throws DbException, ConfigException;

    protected abstract long getPollPeriod();

    public boolean isIndexBehindSchedule() {
        long maxTimeOnSchedule;
        if (this.wantInitialSlurp() || this.getStatus().getLastSlurpTime() == null) {
            return false;
        }
        long pollPeriod = this.getPollPeriod();
        if (pollPeriod == 0L) {
            return false;
        }
        long sinceLastIndex = System.currentTimeMillis() - this.getStatus().getLastSlurpTime().getTime();
        return sinceLastIndex > (maxTimeOnSchedule = 3600000L + pollPeriod);
    }

    public boolean wantInitialSlurp() {
        try {
            return !this.getRevisionCache().isInitialIndexingComplete();
        }
        catch (DbException e2) {
            Logs.APP_LOG.error((Object)"Error checking initial slurp done flag, assuming true", (Throwable)e2);
            return true;
        }
    }

    public abstract String rescan(String var1, String var2) throws UnsupportedOperationException, IllegalStateException, RepositoryClientException, DbException, LicensePolicyException;

    protected SearchManager createSearchManager() {
        return new SearchManager(this.createQueryEvaluator());
    }

    protected QueryEvaluator createQueryEvaluator() {
        return new BaseQueryEvaluator(this, this.createQueryBuilder());
    }

    protected QueryBuilder createQueryBuilder() {
        return new QueryBuilder(this);
    }

    public ChangesetStatsCalculator makeChangesetHistoryCalculator(ActivityItemSearchParams params) {
        return new ChangesetStatsCalculator(params);
    }

    public CommonIndexer getIndexer() {
        return this.indexer;
    }

    public String getDisplayRevision(String revision) {
        return revision;
    }

    public CrossRepLuceneIndex getCrossRepLuceneIndex() {
        return this.indexingContext.getCrossRepLuceneIndex();
    }

    public void startPause(Exception cause) {
        long pausePeriod = this.getPausePeriodMillis();
        if (pausePeriod > 0L) {
            Logs.APP_LOG.info((Object)("Repository scanner paused. Error: " + cause.getMessage()));
            this.indexingContext.getEventPublisher().publish((Object)new RepositoryScanningPausedEventImpl(this.getName()));
            this.getStatus().setEngineError("Repository paused due to error", cause, this.cfg);
            long pauseEndTime = System.currentTimeMillis() + pausePeriod;
            this.getStatus().startPause(pauseEndTime);
        } else {
            this.getStatus().setEngineError("Repository index failed due to error", cause, this.cfg);
        }
    }

    public void finishPause() {
        Logs.APP_LOG.info((Object)("Repository " + this.getName() + " resuming from pause"));
        this.getStatus().clearEngineError();
        if (this.getStatus().isPaused()) {
            this.getStatus().finishPause();
            this.indexingContext.getEventPublisher().publish((Object)new RepositoryScanningResumedEventImpl(this.getName()));
        }
    }

    protected long getPausePeriodMillis() {
        return 0L;
    }

    public long getEffectivePollPeriod() {
        return this.getPollPeriod();
    }

    public abstract boolean isLicenseLimitReached();

    public abstract void init() throws DbException, ConfigException;

    protected abstract void resetScmMetaData();

    public abstract CommonRepositoryScanner getScanner();

    static {
        Thread t2 = new Thread((Runnable)WARMER, "FE-CacheWarmer");
        t2.setDaemon(true);
        t2.start();
    }
}

