/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.obfuscate.idb.y;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;

public class Position
implements Comparable<Position> {
    protected static final long STEP = 10000000000L;
    private static final long INITIAL_VALUE = 0x3FFFFFFFFFFFFFFFL;
    private static final long MAX_VALUE = 0x7FFFFFFFFFFFFFFEL;
    private static final long MIN_VALUE = 1L;
    private long[] value;

    public static Position initial() {
        return new Position(0x3FFFFFFFFFFFFFFFL);
    }

    private static boolean arrayPrefixEquals(long[] arr1, long[] arr2) {
        int max = Math.min(arr1.length, arr2.length);
        for (int i2 = 0; i2 < max; ++i2) {
            if (arr1[i2] == arr2[i2]) continue;
            return false;
        }
        return true;
    }

    private static long getNextValue(long value, long step, double fraction) {
        if (step > 0L) {
            if (0x7FFFFFFFFFFFFFFEL - step > value) {
                return value + step;
            }
            long nextVal = value + (long)Math.floor((double)(0x7FFFFFFFFFFFFFFEL - value) * fraction);
            if (nextVal == value && nextVal != 0x7FFFFFFFFFFFFFFEL) {
                nextVal += (0x7FFFFFFFFFFFFFFEL - value) / 2L;
            }
            if (nextVal == value && nextVal != 0x7FFFFFFFFFFFFFFEL) {
                ++nextVal;
            }
            return nextVal;
        }
        if (value + step > 0L) {
            return value + step;
        }
        long nextVal = (long)Math.floor((double)value * fraction);
        if (nextVal == value && nextVal != 0L) {
            nextVal = value / 2L;
        }
        if (nextVal == value && nextVal != 0L) {
            --nextVal;
        }
        return nextVal;
    }

    private static long[] addLongToArray(long[] arr, long value) {
        long[] result = new long[arr.length + 1];
        System.arraycopy(arr, 0, result, 0, result.length - 1);
        result[result.length - 1] = value;
        return result;
    }

    public static Position createBetween(Position pos1, Position pos2, double fraction) {
        if (fraction <= 0.0 || fraction >= 1.0) {
            fraction = 0.5;
        }
        if (pos1 != null && pos2 != null) {
            int compare = pos1.compareTo(pos2);
            if (compare != 0) {
                long[] first = (compare == -1 ? pos1 : pos2).value;
                long[] last = (first == pos1.value ? pos2 : pos1).value;
                long[] result = new long[Math.min(first.length, last.length)];
                long carryOver = 0L;
                for (int index = 0; index < result.length; ++index) {
                    long firstValue = first[index];
                    long lastValue = last[index];
                    double step = fraction * (double)(lastValue - firstValue);
                    long value = firstValue + Math.round(Math.floor(step));
                    if (carryOver > 0L) {
                        if (Long.MAX_VALUE - value - carryOver < 0L) {
                            value = Long.MAX_VALUE;
                            carryOver -= value;
                        } else {
                            value += carryOver;
                            carryOver = 0L;
                        }
                    }
                    if (value == firstValue && value != lastValue && lastValue - firstValue > 1L) {
                        value = firstValue + (lastValue - firstValue) / 2L;
                    }
                    result[index] = value;
                    if (value != firstValue && index < result.length - 1) {
                        long[] significantResult = new long[index + 1];
                        System.arraycopy(result, 0, significantResult, 0, significantResult.length);
                        result = significantResult;
                        break;
                    }
                    carryOver += Math.round(9.223372036854776E18 * (step - Math.floor(step)));
                }
                if (Position.arrayPrefixEquals(first, result) || Position.arrayPrefixEquals(last, result)) {
                    result = first.length > result.length ? Position.addLongToArray(result, Position.getNextValue(first[result.length], 10000000000L, fraction)) : (last.length > result.length ? Position.addLongToArray(result, Position.getNextValue(last[result.length], -10000000000L, fraction)) : Position.addLongToArray(first, 0x3FFFFFFFFFFFFFFFL));
                }
                if (result[result.length - 1] == 1L || result[result.length - 1] == 0x7FFFFFFFFFFFFFFEL) {
                    result = Position.addLongToArray(result, 0x3FFFFFFFFFFFFFFFL);
                }
                return new Position(result);
            }
            throw new IllegalArgumentException("Cannot create a position that is between two identical positions");
        }
        if (pos1 != null) {
            return Position.createAfter(pos1);
        }
        if (pos2 != null) {
            return Position.createBefore(pos2);
        }
        return Position.initial();
    }

    public static Position createAfter(Position pos) {
        if (pos.value[pos.value.length - 1] < 0x7FFFFFFFFFFFFFFEL) {
            long[] nextValue = new long[pos.value.length];
            System.arraycopy(pos.value, 0, nextValue, 0, pos.value.length);
            nextValue[nextValue.length - 1] = Math.min(0x7FFFFFFFFFFFFFFEL, nextValue[nextValue.length - 1] + 10000000000L);
            return new Position(nextValue);
        }
        long[] nextValue = new long[pos.value.length + 1];
        System.arraycopy(pos.value, 0, nextValue, 0, pos.value.length);
        nextValue[nextValue.length - 2] = Long.MAX_VALUE;
        nextValue[nextValue.length - 1] = 0x3FFFFFFFFFFFFFFFL;
        return new Position(nextValue);
    }

    public static Position createBefore(Position pos) {
        if (pos.value[pos.value.length - 1] > 1L) {
            long[] nextValue = new long[pos.value.length];
            System.arraycopy(pos.value, 0, nextValue, 0, pos.value.length);
            nextValue[nextValue.length - 1] = Math.max(1L, nextValue[nextValue.length - 1] - 10000000000L);
            return new Position(nextValue);
        }
        long[] nextValue = new long[pos.value.length + 1];
        System.arraycopy(pos.value, 0, nextValue, 0, pos.value.length);
        nextValue[nextValue.length - 2] = Long.MIN_VALUE;
        nextValue[nextValue.length - 1] = 0x3FFFFFFFFFFFFFFFL;
        return new Position(nextValue);
    }

    public Position(long ... value) {
        if (value.length == 0) {
            throw new IllegalArgumentException("cannot create a Position for an empty array");
        }
        this.value = value;
    }

    public Position(y cu, int offset) {
        this(cu, offset, cu.e());
    }

    public Position(y cu, int offset, int limit) {
        long[] value = null;
        int nextValueOffset = offset;
        while (nextValueOffset < limit) {
            if (value != null) {
                long[] newVal = new long[value.length + 1];
                System.arraycopy(value, 0, newVal, 0, value.length);
                value = newVal;
            } else {
                value = new long[1];
            }
            value[value.length - 1] = cu.v(nextValueOffset);
            nextValueOffset = cu.w(nextValueOffset);
        }
        if (value == null) {
            throw new IllegalArgumentException("cannot create a Position for an empty Cu");
        }
        this.value = value;
    }

    public long[] getValue() {
        return this.value;
    }

    @Override
    public int compareTo(Position other) {
        for (int index = 0; index < this.value.length; ++index) {
            if (other.value.length <= index) {
                return 1;
            }
            if (this.value[index] == other.value[index]) continue;
            if (this.value[index] > other.value[index]) {
                return 1;
            }
            return -1;
        }
        return this.value.length == other.value.length ? 0 : -1;
    }

    public void appendToCu(y cu) {
        if (this.value != null) {
            for (int i2 = 0; i2 < this.value.length; ++i2) {
                cu.b(this.value[i2]);
            }
        }
    }

    public String toString() {
        int maxLength = String.valueOf(Long.MAX_VALUE).length();
        StringBuilder builder = new StringBuilder();
        String sep = "";
        for (long v2 : this.value) {
            builder.append(sep).append(StringUtils.leftPad((String)String.valueOf(v2), (int)maxLength, (char)'0'));
            sep = ".";
        }
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.value);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Position other = (Position)obj;
        return Arrays.equals(this.value, other.value);
    }

    protected int size() {
        return this.value.length;
    }
}

