/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

public class PassivationStats {
    private final int runnableCount;
    private final int activeCount;
    private final int needingPassivationCount;
    private final long activeCacheSize;
    private final long needingPassivationCacheSize;
    private final long perRepoCacheSize;
    private final long maxCacheSize;
    private final int maxActiveRepos;
    private final long gcPassivations;
    private final long maxActivePassivations;

    public PassivationStats(int runnableCount, int activeCount, int needingPassivationCount, long activeCacheSize, long needingPassivationCacheSize, long perRepoCacheSize, long maxCacheSize, int maxActiveRepos, long gcPassivations, long maxActivePassivations) {
        this.runnableCount = runnableCount;
        this.activeCount = activeCount;
        this.activeCacheSize = activeCacheSize;
        this.needingPassivationCount = needingPassivationCount;
        this.needingPassivationCacheSize = needingPassivationCacheSize;
        this.perRepoCacheSize = perRepoCacheSize;
        this.maxCacheSize = maxCacheSize;
        this.maxActiveRepos = maxActiveRepos;
        this.gcPassivations = gcPassivations;
        this.maxActivePassivations = maxActivePassivations;
    }

    public int getRunnableCount() {
        return this.runnableCount;
    }

    public int getActiveCount() {
        return this.activeCount;
    }

    public int getNeedingPassivationCount() {
        return this.needingPassivationCount;
    }

    public long getActiveCacheSize() {
        return this.activeCacheSize;
    }

    public long getNeedingPassivationCacheSize() {
        return this.needingPassivationCacheSize;
    }

    public long getPerRepoCacheSize() {
        return this.perRepoCacheSize;
    }

    public long getMaxCacheSize() {
        return this.maxCacheSize;
    }

    public double getCacheUsage() {
        return (double)this.getActiveCacheSize() / (double)this.getMaxCacheSize();
    }

    public int getMaxActiveRepos() {
        return this.maxActiveRepos;
    }

    public long getGcPassivations() {
        return this.gcPassivations;
    }

    public long getMaxActivePassivations() {
        return this.maxActivePassivations;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        PassivationStats that = (PassivationStats)o2;
        if (this.activeCount != that.activeCount) {
            return false;
        }
        if (this.activeCacheSize != that.activeCacheSize) {
            return false;
        }
        if (this.needingPassivationCacheSize != that.needingPassivationCacheSize) {
            return false;
        }
        if (this.maxActiveRepos != that.maxActiveRepos) {
            return false;
        }
        if (this.maxCacheSize != that.maxCacheSize) {
            return false;
        }
        if (this.needingPassivationCount != that.needingPassivationCount) {
            return false;
        }
        if (this.perRepoCacheSize != that.perRepoCacheSize) {
            return false;
        }
        return this.runnableCount == that.runnableCount;
    }

    public int hashCode() {
        int result = this.runnableCount;
        result = 31 * result + this.activeCount;
        result = 31 * result + this.needingPassivationCount;
        result = 31 * result + (int)(this.activeCacheSize ^ this.activeCacheSize >>> 32);
        result = 31 * result + (int)(this.needingPassivationCacheSize ^ this.needingPassivationCacheSize >>> 32);
        result = 31 * result + (int)(this.perRepoCacheSize ^ this.perRepoCacheSize >>> 32);
        result = 31 * result + (int)(this.maxCacheSize ^ this.maxCacheSize >>> 32);
        result = 31 * result + this.maxActiveRepos;
        return result;
    }
}

