/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.atlassian.fecru.properties.RepositoryPropertyManager;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.PassivationMXBeanImpl;
import com.cenqua.fisheye.rep.PassivationStats;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.util.ComputingUnitExpander;
import com.google.common.util.concurrent.AtomicDouble;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.commons.lang.StringUtils;

public class PassivateManager {
    public static final long DEFAULT_MAX_TOTAL_CACHE_SIZE;
    public static final long MIN_CACHE_SIZE = 0x500000L;
    public static final long MAX_CACHE_SIZE = 0x1400000L;
    public static final int MAX_GC_PASSIVATION = 5;
    private final AtomicLong minGCInterval = new AtomicLong(FishEyeSysProps.PASSIVATION_GC_INTERVAL_MS);
    private final AtomicDouble gcThreshold = new AtomicDouble(FishEyeSysProps.PASSIVATION_GC_THRESHOLD);
    private final AtomicLong activeCacheSize = new AtomicLong();
    private final AtomicLong closeWaitCacheSize = new AtomicLong();
    private final AtomicLong gcPassivations = new AtomicLong();
    private final AtomicLong maxActivePassivations = new AtomicLong();
    private long lastGCTimeTotal;
    private long lastTime;
    private long maxTotalCacheSize = DEFAULT_MAX_TOTAL_CACHE_SIZE;
    private int maxActive = (int)(DEFAULT_MAX_TOTAL_CACHE_SIZE / 0x500000L);
    private final Object lock = new Object();
    private final Set<RepositoryHandle> runnable = new HashSet<RepositoryHandle>();
    private final LinkedHashMap<RepositoryHandle, Object> active = new LinkedHashMap(16, 0.75f, true);
    private final Object PRESENT = new Object();
    private final LinkedHashSet<RepositoryHandle> awaitingPassivation = new LinkedHashSet();
    private final BackgroundThread backgroundThread = new BackgroundThread();
    private volatile long cacheSize = 0x500000L;
    private final RepositoryPropertyManager repositoryPropertyManager;

    public PassivateManager(RepositoryPropertyManager repositoryPropertyManager) {
        this.repositoryPropertyManager = repositoryPropertyManager;
        Logs.APP_LOG.debug((Object)("Cache-sizing: maxTotalCacheSize=" + this.maxTotalCacheSize));
        this.registerMxBean();
        this.backgroundThread.start();
    }

    private void registerMxBean() {
        Logs.APP_LOG.debug((Object)"Registering Passivation MXBean");
        try {
            MBeanServer server = ManagementFactory.getPlatformMBeanServer();
            ObjectName name = new ObjectName("com.atlassian.fisheye.rep:type=PassivateMXBean");
            if (server.isRegistered(name)) {
                server.unregisterMBean(name);
            }
            server.registerMBean(new PassivationMXBeanImpl(this), name);
        }
        catch (Exception e2) {
            Logs.APP_LOG.info((Object)"Unable to register the passivation MX bean.", (Throwable)e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        Object object = this.lock;
        synchronized (object) {
            String memCacheTotalSizePropertyName = "repcache.memcache.total_size";
            String softMaxPropertyName = "repcache.passivate.soft_max_active";
            String value = this.repositoryPropertyManager.loadGlobalProperty(memCacheTotalSizePropertyName);
            this.maxTotalCacheSize = DEFAULT_MAX_TOTAL_CACHE_SIZE;
            if (StringUtils.isNotEmpty((String)value)) {
                try {
                    this.maxTotalCacheSize = ComputingUnitExpander.fromString(value);
                }
                catch (NumberFormatException e2) {
                    Logs.APP_LOG.warn((Object)("could not parse property " + memCacheTotalSizePropertyName), (Throwable)e2);
                }
            }
            value = this.repositoryPropertyManager.loadGlobalProperty(softMaxPropertyName);
            this.maxActive = (int)(this.maxTotalCacheSize / 0x500000L);
            if (StringUtils.isNotEmpty((String)value)) {
                try {
                    this.maxActive = Integer.parseInt(value);
                }
                catch (NumberFormatException e3) {
                    Logs.APP_LOG.warn((Object)("could not parse int property " + softMaxPropertyName), (Throwable)e3);
                }
            }
            Logs.APP_LOG.debug((Object)("Cache-sizing: " + memCacheTotalSizePropertyName + "=" + this.maxTotalCacheSize));
            Logs.APP_LOG.debug((Object)("Cache-sizing: " + softMaxPropertyName + "=" + this.maxActive));
        }
    }

    public long getMinGCInterval() {
        return this.minGCInterval.get();
    }

    public void setMinGCInterval(long minGCInterval) {
        this.minGCInterval.set(Math.max(minGCInterval, 1000L));
        Logs.APP_LOG.debug((Object)("GC check interval set to " + this.getMinGCInterval()));
    }

    public double getGCThreshold() {
        return this.gcThreshold.get();
    }

    public void setGCThreshold(double gcThreshold) {
        this.gcThreshold.set(Math.max(gcThreshold, (double)0.05f));
        Logs.APP_LOG.debug((Object)("GC threshold set to " + this.getGCThreshold()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForPassivation(boolean checkAll) {
        ArrayList<RepositoryHandle> handles;
        this.checkForMemoryPressure();
        Iterator iterator = this.lock;
        synchronized (iterator) {
            handles = new ArrayList<RepositoryHandle>(checkAll ? this.runnable : this.awaitingPassivation);
        }
        for (RepositoryHandle handle : handles) {
            handle.checkForPassivation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForMemoryPressure() {
        List<GarbageCollectorMXBean> gcBeans = ManagementFactory.getGarbageCollectorMXBeans();
        long now = System.currentTimeMillis();
        long totalGCTime = 0L;
        for (GarbageCollectorMXBean gcBean : gcBeans) {
            totalGCTime += gcBean.getCollectionTime();
        }
        long deltaTime = now - this.lastTime;
        if (deltaTime > this.minGCInterval.get()) {
            if (this.lastGCTimeTotal != 0L) {
                long deltaGCTime = totalGCTime - this.lastGCTimeTotal;
                if (deltaTime > 0L && (double)deltaGCTime > this.gcThreshold.get() * (double)deltaTime) {
                    Object object = this.lock;
                    synchronized (object) {
                        int numRepos = (int)(deltaGCTime * 5L / deltaTime) + 1;
                        Logs.APP_LOG.debug((Object)("Passivating " + numRepos + " repos due to GC load"));
                        this.gcPassivations.addAndGet(this.selectAndPassivateRepos(numRepos));
                    }
                }
            }
            this.lastGCTimeTotal = totalGCTime;
            this.lastTime = now;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean needsPassivation(RepositoryHandle handle) {
        Object object = this.lock;
        synchronized (object) {
            return this.awaitingPassivation.contains(handle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long repositoryBecameRunnable(RepositoryHandle handle) {
        Object object = this.lock;
        synchronized (object) {
            Logs.APP_LOG.debug((Object)("Repo became runnable: " + handle.getName()));
            this.runnable.add(handle);
            this.recalc();
            return this.cacheSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repositoryNoLongerRunnable(RepositoryHandle handle) {
        Object object = this.lock;
        synchronized (object) {
            Logs.APP_LOG.debug((Object)("Repo no longer runnable: " + handle.getName()));
            this.runnable.remove(handle);
            this.recalc();
        }
    }

    private void recalc() {
        int numRunnable = this.runnable.size();
        if (numRunnable == 0) {
            this.cacheSize = 0x1400000L;
            return;
        }
        long v2 = this.maxTotalCacheSize / (long)Math.min(this.maxActive, numRunnable);
        v2 = Math.max(v2, 0x500000L);
        this.cacheSize = Math.min(v2, 0x1400000L);
    }

    public void updateOnRelease(RepositoryHandle handle, boolean passive) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOnAcquire(RepositoryHandle handle, boolean dbOpen) {
        if (dbOpen) {
            Object object = this.lock;
            synchronized (object) {
                this.addToActive(handle, handle.getCurrentDbCacheSize());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOnDbOpen(RepositoryHandle handle, long cacheSize) {
        Object object = this.lock;
        synchronized (object) {
            this.addToActive(handle, cacheSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOnDbClose(RepositoryHandle handle, long cacheSize) {
        Object object = this.lock;
        synchronized (object) {
            this.removeFromActive(handle, cacheSize);
            this.removeFromAwaitingPassivation(handle, cacheSize);
        }
    }

    private void addToActive(RepositoryHandle handle, long cacheSize) {
        long numPassivated;
        if (!this.active.containsKey(handle)) {
            this.activeCacheSize.addAndGet(cacheSize);
        }
        this.active.put(handle, this.PRESENT);
        if (this.active.size() > this.maxActive && (numPassivated = (long)this.selectAndPassivateRepos(1)) != 0L) {
            this.maxActivePassivations.addAndGet(numPassivated);
            this.backgroundThread.wakeNow();
        }
    }

    private void removeFromActive(RepositoryHandle handle, long cacheSize) {
        if (this.active.remove(handle) != null) {
            this.activeCacheSize.addAndGet(-cacheSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int selectAndPassivateRepos(int numToPassivate) {
        int end;
        ArrayList<RepositoryHandle> candidates = new ArrayList<RepositoryHandle>();
        Object object = this.lock;
        synchronized (object) {
            for (RepositoryHandle handle : this.active.keySet()) {
                if (this.awaitingPassivation.contains(handle)) continue;
                candidates.add(handle);
            }
        }
        if (candidates.isEmpty()) {
            return 0;
        }
        int start = (candidates.size() - numToPassivate) / 2;
        if (start < 0) {
            start = 0;
        }
        if ((end = start + numToPassivate) > candidates.size()) {
            end = candidates.size();
        }
        List toPassivate = candidates.subList(start, end);
        for (RepositoryHandle handle : toPassivate) {
            this.addToAwaitingPassivation(handle);
        }
        return toPassivate.size();
    }

    private void addToAwaitingPassivation(RepositoryHandle handle) {
        if (this.awaitingPassivation.add(handle)) {
            this.closeWaitCacheSize.addAndGet(handle.getCurrentDbCacheSize());
        }
    }

    private boolean removeFromAwaitingPassivation(RepositoryHandle handle, long cacheSize) {
        if (this.awaitingPassivation.remove(handle)) {
            this.closeWaitCacheSize.addAndGet(-cacheSize);
            return true;
        }
        return false;
    }

    public long getCacheSize() {
        return this.cacheSize;
    }

    public void stopBackgroundThread() {
        this.backgroundThread.stopThread();
        try {
            this.backgroundThread.join(20000L);
            if (this.backgroundThread.isAlive()) {
                Logs.APP_LOG.warn((Object)"passivation background thread didn't stop");
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PassivationStats getPassivationStats() {
        Object object = this.lock;
        synchronized (object) {
            return new PassivationStats(this.runnable.size(), this.active.size(), this.awaitingPassivation.size(), this.activeCacheSize.get(), this.closeWaitCacheSize.get(), this.cacheSize, this.maxTotalCacheSize, this.maxActive, this.gcPassivations.get(), this.maxActivePassivations.get());
        }
    }

    static {
        long mx = Runtime.getRuntime().maxMemory();
        if (mx == Long.MAX_VALUE) {
            Logs.APP_LOG.info((Object)"Max memory unbounded, assuming 512MiB for cache-sizing");
            mx = 0x20000000L;
        } else if (mx <= 0L) {
            Logs.APP_LOG.info((Object)"Max memory <= 0, assuming 512MiB for cache-sizing");
            mx = 0x20000000L;
        }
        DEFAULT_MAX_TOTAL_CACHE_SIZE = mx / 3L;
    }

    private class BackgroundThread
    extends Thread {
        private static final long PERIOD = 60000L;
        private final Object backgroundLock = new Object();
        private volatile boolean stop = false;

        private BackgroundThread() {
            this.setDaemon(true);
            this.setName("Passivation Thread");
        }

        @Override
        public void run() {
            long nextCheckAllTime = System.currentTimeMillis() + 60000L;
            this.waitUntil(nextCheckAllTime);
            while (!this.stop) {
                try {
                    boolean checkAll = false;
                    long now = System.currentTimeMillis();
                    if (now >= nextCheckAllTime) {
                        checkAll = true;
                        nextCheckAllTime = now + 60000L;
                    }
                    PassivateManager.this.checkForPassivation(checkAll);
                }
                catch (Throwable e2) {
                    Logs.APP_LOG.warn((Object)"Problem during passivation check", e2);
                }
                this.waitUntil(nextCheckAllTime);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void waitUntil(long nextCheckAllTime) {
            Object object = this.backgroundLock;
            synchronized (object) {
                try {
                    long delay = Math.max(1L, nextCheckAllTime - System.currentTimeMillis());
                    this.backgroundLock.wait(delay);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void wakeNow() {
            Object object = this.backgroundLock;
            synchronized (object) {
                this.backgroundLock.notify();
            }
        }

        public void stopThread() {
            this.stop = true;
            this.wakeNow();
        }
    }
}

