/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.config1.UserPassAuthType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.util.IntervalUtils;

public class NetworkRepositorySettings {
    private final String username;
    private final String password;
    private final float cps;
    private long pollPeriod;
    private static final String NEVER = "Never";

    public NetworkRepositorySettings(UserPassAuthType auth, String pollPeriodString, float cps) {
        if (auth != null) {
            this.username = auth.getUsername();
            this.password = auth.getPassword();
        } else {
            this.username = null;
            this.password = null;
        }
        this.setPollPeriod(pollPeriodString);
        if (cps < 0.0f) {
            Logs.APP_LOG.warn((Object)"The Connections Per Second setting may not be negative");
            this.cps = -cps;
        } else {
            this.cps = cps;
        }
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public long getPollPeriod() {
        return this.pollPeriod;
    }

    public void setPollPeriod(String pollPeriodString) {
        this.pollPeriod = IntervalUtils.convertStringToLongOrNever(pollPeriodString, 60000L);
    }

    public float getCps() {
        return this.cps;
    }
}

