/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.atlassian.fisheye.event.ChangesetsIndexedEvent;
import com.cenqua.fisheye.cache.BaseDirInfoCache;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneIndexes;
import com.cenqua.fisheye.rep.BaseRepositoryEngine;
import com.cenqua.fisheye.rep.BaseRepositoryScanner;
import com.cenqua.fisheye.rep.BlameAndLinecountCalculator;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.IndexingState;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.util.Timer;
import java.io.IOException;

public abstract class LifecycleRepositoryScanner<C extends BaseDirInfoCache>
extends BaseRepositoryScanner<C> {
    private boolean started;
    private final BlameAndLinecountCalculator blameAndLinecountCalculator;

    protected LifecycleRepositoryScanner(BaseRepositoryEngine<? extends BaseRepositoryScanner<C>, C> engine) {
        super(engine);
        this.blameAndLinecountCalculator = engine.getLinecountCalculator();
        this.started = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doSlurpTransaction(boolean updateOccurred) throws DbException, ConfigException {
        boolean rollbackRequired = true;
        try {
            this.getStatus().throwOnStopRequested();
            if (!this.started) {
                this.startRepository();
            }
            if (this.started) {
                this.updatePauseStatus();
                if (!this.getStatus().isPaused()) {
                    Logs.APP_LOG.info((Object)("Starting slurp of " + this.getRepoName()));
                    this.slurpRepository(updateOccurred);
                    this.getStatus().setMessage(" ");
                    if (!this.isStopRequested()) {
                        Logs.APP_LOG.debug((Object)"Committing cache changes");
                        ((BaseDirInfoCache)this.getCache()).commit();
                        rollbackRequired = false;
                    }
                }
            }
        }
        catch (Exception e2) {
            if (!this.isUserInitiatedException(e2)) {
                this.handleSlurpException(e2);
            }
        }
        finally {
            if (rollbackRequired) {
                Logs.APP_LOG.debug((Object)"Rolling back cache changes");
                ((BaseDirInfoCache)this.getCache()).rollback();
            }
        }
    }

    protected void slurpRepository(boolean priorUpdateOccurred) throws DbException, ConfigException, IOException, RepositoryClientException {
        boolean updateOccurred;
        IndexingState indexingState = ((BaseDirInfoCache)this.getCache()).getIndexingPhase();
        RepositoryStatus status = this.getStatus();
        status.setMessage("Indexing has commenced for repository " + this.getRepoName());
        Timer timer = new Timer("slurp of " + this.getRepoName());
        boolean bl = updateOccurred = priorUpdateOccurred || indexingState != IndexingState.PROCESSING_REVISIONS || !((BaseDirInfoCache)this.getCache()).isInitialIndexingComplete();
        if (!this.isStopRequested() && updateOccurred && indexingState == IndexingState.PROCESSING_REVISIONS) {
            if (this.processRevisions()) {
                timer.mark("processRevisions complete");
            }
            indexingState = ((BaseDirInfoCache)this.getCache()).getIndexingPhase();
        }
        if (!this.isStopRequested() && 29L != ((BaseDirInfoCache)this.getCache()).getMetadataVersion()) {
            indexingState = IndexingState.INDEXING_METADATA;
            ((BaseDirInfoCache)this.getCache()).setIndexingPhase(indexingState);
            updateOccurred = true;
            Logs.APP_LOG.info((Object)("Upgrading metadata index for " + this.getRepoName() + " from " + ((BaseDirInfoCache)this.getCache()).getMetadataVersion() + " to " + 29L));
            this.upgradeMetadataAndContentIndexes();
        }
        if (!this.isStopRequested() && updateOccurred && indexingState == IndexingState.INDEXING_METADATA) {
            if (this.processMetadata()) {
                timer.mark("processMetadata complete");
            }
            this.indexingContext.getEventPublisher().publish((Object)new ChangesetsIndexedEvent(this.getRepoName()));
            indexingState = ((BaseDirInfoCache)this.getCache()).getIndexingPhase();
        }
        if (!this.isStopRequested() && updateOccurred && indexingState == IndexingState.INDEXING_CONTENT) {
            long start = System.currentTimeMillis();
            Logs.APP_LOG.debug((Object)("[" + this.getRepoName() + "]   updating content index"));
            if (this.processContent()) {
                updateOccurred = true;
                Logs.APP_LOG.debug((Object)("[" + this.getRepoName() + "]   content index took: " + (System.currentTimeMillis() - start) / 1000L + "s."));
                timer.mark("processContent complete");
            } else {
                Logs.APP_LOG.debug((Object)("[" + this.getRepoName() + "]   content index up to date"));
            }
            if (!this.isStopRequested()) {
                ((BaseDirInfoCache)this.getCache()).setInitialIndexingComplete(true);
            }
            indexingState = ((BaseDirInfoCache)this.getCache()).getIndexingPhase();
        }
        status.clearEngineError();
        if (!this.isStopRequested() && updateOccurred) {
            timer.mark("starting blame calculation");
            this.blameAndLinecountCalculator.calcBlame(false);
            this.notifyUpdate();
            timer.mark("completed blame calculation");
        }
        timer.end();
    }

    private void startRepository() {
        try {
            this.validateRepository();
            this.started = true;
            this.getStatus().clearEngineError();
        }
        catch (ConfigException e2) {
            String message = "Unable to initialise repository " + this.getRepoName() + " due to " + e2.getClass().getName() + ":" + e2.getMessage();
            Logs.APP_LOG.error((Object)message, (Throwable)e2);
            this.getStatus().setEngineError(message);
        }
    }

    private void upgradeMetadataAndContentIndexes() throws DbException {
        Logs.APP_LOG.info((Object)("[" + this.getRepoName() + "] " + " Upgrading quicksearch data"));
        LuceneConnection<LuceneIndexes> luceneConnection = ((BaseDirInfoCache)this.getCache()).getLuceneConnection();
        luceneConnection.recreateIndex(LuceneIndexes.CONTENT);
        ((BaseDirInfoCache)this.getCache()).setMetadataVersion(29L);
        this.resetScmMetaData();
    }

    protected abstract boolean processRevisions() throws DbException, RepositoryClientException, ConfigException;

    protected abstract boolean processMetadata() throws DbException;

    protected abstract boolean processContent() throws DbException, IOException, RepositoryClientException;
}

