/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.cache.InternalRevisionCache;
import com.cenqua.fisheye.rep.Blame;
import com.cenqua.fisheye.rep.BlameChunk;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.util.SumMap;
import java.util.List;

public class History {
    private final Blame lines;
    private final SumMap<String> authorLinecount;
    private final InternalRevisionCache<? extends ChangeSet> cache;
    private boolean infoInitialised;

    public History(SumMap<String> authorLinecount, Blame lines, InternalRevisionCache<? extends ChangeSet> cache) {
        this.lines = lines;
        this.authorLinecount = authorLinecount;
        this.cache = cache;
    }

    public SumMap<String> getAuthorLinecount() {
        return this.authorLinecount;
    }

    public List<BlameChunk> getBlame() {
        return this.lines.getChunks();
    }

    public String toString() {
        return "line count: " + this.authorLinecount.toString() + ", mLines " + (this.lines == null ? "null" : "length " + this.lines.getTotalLines());
    }

    public void initialiseInfo() throws DbException {
        if (!this.infoInitialised) {
            for (BlameChunk chunk : this.lines.getChunks()) {
                if (chunk.getInfo() != null || chunk.getRevId() < 0) continue;
                int revId = chunk.getRevId();
                FileRevision fr = this.cache.getFileRevision(revId, true);
                chunk.setBlameInfo(fr);
            }
            this.infoInitialised = true;
        }
    }
}

