/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.crucible.hibernate.CurrentSessionProvider;
import com.cenqua.fisheye.rep.CommitNotification;
import com.cenqua.fisheye.rep.CommitNotificationDAO;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class HibernateCommitNotificationDAO
implements CommitNotificationDAO {
    private final CurrentSessionProvider currentSessionProvider;

    @Autowired
    public HibernateCommitNotificationDAO(CurrentSessionProvider currentSessionProvider) {
        this.currentSessionProvider = currentSessionProvider;
    }

    private Session session() {
        return this.currentSessionProvider.currentSession();
    }

    @Override
    public void saveOrUpdateCommitNotification(CommitNotification commitNotification) {
        this.session().saveOrUpdate((Object)commitNotification);
    }

    @Override
    public CommitNotification getCommitNotification(String rep) {
        return (CommitNotification)this.session().createCriteria(CommitNotification.class).add((Criterion)Restrictions.eq((String)"rep", (Object)rep)).uniqueResult();
    }

    public List<CommitNotification> listCommitNotifications() {
        return this.session().createCriteria(CommitNotification.class).list();
    }
}

