/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonFileRevisionInput;
import com.cenqua.fisheye.rep.impl.LineCountState;
import java.util.Comparator;
import java.util.List;
import java.util.Set;

public interface FileRevision
extends CommonFileRevisionInput,
Comparable<FileRevision> {
    public static final Comparator<FileRevision> OLDEST_FIRST_COMPARATOR = new OldestFirstComparator();
    public static final Comparator<FileRevision> NEWEST_FIRST_COMPARATOR = new NewestFirstComparator();
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_FILE = 1;
    public static final int TYPE_DIR = 2;
    public static final Integer TYPE_SVNVIRTUAL_DELETE = 3;

    public String getDisplayRevision();

    public String getDisplayCSID();

    public boolean isRevisionChangesetId();

    public List<RevInfoKey> getAncestors();

    public List<RevInfoKey> getParents();

    public RevInfoKey getAncestorOnBranch();

    public RevInfoKey getDiffRevision();

    @Override
    public AncestorLink getAncestorLink();

    public List<String> getBranchPoints();

    public List<String> getTags();

    public List<Integer> getReviewIds();

    public RevInfoKey getCopySource();

    public List<RevInfoKey> getCopyDestinations() throws DbException;

    public RevInfoKey getMoveSource();

    public RevInfoKey getMoveDestination() throws DbException;

    @Override
    public int getFileType();

    public boolean isFile();

    public boolean isDir();

    public boolean isAnnotatable();

    @Override
    public int getLinesAdded();

    @Override
    public int getLinesRemoved();

    @Override
    public LineCountState getLineCountState();

    public boolean isMetadataOnlyChange();

    public Set<String> getHeadOnBranches();

    public Set<String> getBranches();

    @Override
    public boolean isOversize();

    @Override
    public boolean isBinaryOrOversize();

    public Path getLogicalPath();

    public static class NewestFirstComparator
    extends OldestFirstComparator {
        @Override
        public int compare(FileRevision a2, FileRevision b2) {
            return super.compare(b2, a2);
        }
    }

    public static class OldestFirstComparator
    implements Comparator<FileRevision> {
        @Override
        public int compare(FileRevision a2, FileRevision b2) {
            long bDate;
            long aDate = a2.getDate();
            if (aDate < (bDate = b2.getDate())) {
                return -1;
            }
            if (aDate > bDate) {
                return 1;
            }
            return a2.getRevision().compareTo(b2.getRevision());
        }
    }
}

