/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.impl.CommonChangeInfo;
import com.cenqua.fisheye.rep.impl.CommonFileRevision;
import com.cenqua.fisheye.util.DuplicatingOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;

public class DiffTextCache
implements DuplicatingOutputStream.Client {
    public static final String DIFFTEXT_CACHENAME = "DiffTextCache";
    private FileWriter addedLineWriter;
    private FileWriter removedLineWriter;
    private OutputStream addedByteWriter;
    private final File dir;
    private File addFile;
    private File removeFile;
    private boolean writeError = false;
    private final boolean enabled;
    private static final int MAX_DIFF_FILES = 20000;
    private int fileCount;

    public void deleteFile(File addedFile) {
        if (this.enabled && addedFile != null && addedFile.getParentFile().equals(this.dir)) {
            addedFile.delete();
            --this.fileCount;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void clear() {
        IOHelper.clearDir(this.dir);
        this.fileCount = 0;
    }

    public void delete() {
        if (this.dir != null && this.dir.exists()) {
            IOHelper.recursiveDelete(this.dir, 2, true);
        }
        this.fileCount = 0;
    }

    public DiffTextCache(String repname, boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            File dirParent = AppConfig.getDiffTextCacheDir();
            dirParent.mkdir();
            this.dir = new File(dirParent, repname);
            if (this.dir.exists()) {
                IOHelper.recursiveDelete(this.dir, 2, true);
            }
            this.dir.mkdirs();
        } else {
            this.dir = null;
        }
    }

    public DiffTextCache(File cacheDir, boolean enabled) {
        this.enabled = enabled;
        if (enabled) {
            this.dir = cacheDir;
            if (this.dir.exists()) {
                if (!this.dir.isDirectory()) {
                    throw new IllegalArgumentException("Dir " + this.dir.getAbsolutePath() + " can't be used as the diff text cache as it is not a directory");
                }
            } else if (!this.dir.mkdirs()) {
                throw new IllegalArgumentException("Unable to create the diff text cache at " + this.dir.getAbsolutePath());
            }
        } else {
            this.dir = null;
        }
    }

    public void startFileRevision(boolean asByteStream, CommonChangeInfo ci) {
        if (this.enabled) {
            this.startFileRevision(asByteStream);
            if (!this.writeError) {
                ci.setTmpDiffAddedFile(this.addFile);
                ci.setTmpDiffRemovedFile(this.removeFile);
            }
        }
    }

    public void startFileRevision(boolean asByteStream, CommonFileRevision cfr) {
        if (this.enabled) {
            this.startFileRevision(asByteStream);
            if (!this.writeError) {
                cfr.setTmpDiffAddedFile(this.addFile);
                cfr.setTmpDiffRemovedFile(this.removeFile);
            }
        }
    }

    private void startFileRevision(boolean asByteStream) {
        if (this.enabled) {
            this.writeError = false;
            try {
                if (this.fileCount >= 20000) {
                    this.writeError = true;
                } else {
                    this.addFile = this.getNewTempFile();
                    if (asByteStream) {
                        this.addedByteWriter = new FileOutputStream(this.addFile);
                    } else {
                        this.removeFile = this.getNewTempFile();
                        this.addedLineWriter = new FileWriter(this.addFile);
                        this.removedLineWriter = new FileWriter(this.removeFile);
                    }
                }
            }
            catch (IOException e2) {
                Logs.APP_LOG.error((Object)"Error initialising writing diff text to file", (Throwable)e2);
            }
        }
    }

    public void addLine(String text) {
        if (this.enabled && !this.writeError) {
            try {
                IOHelper.write(this.addedLineWriter, text);
            }
            catch (IOException e2) {
                Logs.APP_LOG.debug((Object)"Error writing diff text to file", (Throwable)e2);
                this.writeError = true;
            }
        }
    }

    public void removeLine(String text) {
        if (this.enabled && !this.writeError) {
            try {
                IOHelper.write(this.removedLineWriter, text);
            }
            catch (IOException e2) {
                Logs.APP_LOG.debug((Object)"Error writing diff text to file", (Throwable)e2);
                this.writeError = true;
            }
        }
    }

    public void addByte(byte b2) {
        if (this.enabled && !this.writeError) {
            try {
                IOHelper.write(this.addedByteWriter, b2);
            }
            catch (IOException e2) {
                Logs.APP_LOG.debug((Object)"Error writing diff text to file", (Throwable)e2);
                this.writeError = true;
            }
        }
    }

    public void finishFileRevision() {
        if (this.enabled) {
            IOHelper.close(this.addedLineWriter);
            IOHelper.close(this.addedLineWriter);
            IOHelper.close(this.removedLineWriter);
            IOHelper.close(this.addedByteWriter);
            IOHelper.deleteIfEmpty(this.addFile);
            IOHelper.deleteIfEmpty(this.removeFile);
            this.addFile = null;
            this.removeFile = null;
            this.addedLineWriter = null;
            this.removedLineWriter = null;
            this.addedByteWriter = null;
            this.writeError = false;
        }
    }

    public File getNewTempFile() throws IOException {
        if (this.enabled) {
            ++this.fileCount;
            return File.createTempFile(DIFFTEXT_CACHENAME, "_" + Long.toString(System.currentTimeMillis()) + ".txt", this.dir);
        }
        return null;
    }

    @Override
    public void write(int b2) throws IOException {
        if (this.enabled) {
            this.addByte((byte)b2);
        }
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        if (this.enabled) {
            for (int i2 = off; i2 < off + len; ++i2) {
                this.addByte(b2[i2]);
            }
        }
    }

    public boolean exists() {
        return this.dir != null && this.dir.exists() && this.dir.isDirectory();
    }

    public boolean isEmpty() {
        if (!this.exists()) {
            return true;
        }
        String[] files = this.dir.list();
        return files == null || files.length == 0;
    }

    public static enum FileType {
        ADD,
        REMOVE;

    }
}

