/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.atlassian.fisheye.activity.ActivityItemList;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.activity.BaseActivityItemProvider;
import com.atlassian.fisheye.activity.annotation.ActivityProvider;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DefaultCrossRepositorySearcher;
import com.cenqua.fisheye.rep.RepositorySearcher;
import com.cenqua.fisheye.rep.SpecificRepositorySearcher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@ActivityProvider
@Component
public class DelegatingRepositorySearcher
extends BaseActivityItemProvider {
    private final SpecificRepositorySearcher specificRepositorySearcher;
    private final DefaultCrossRepositorySearcher crossRepositorySearcher;
    private final CommitterUserMappingManager committerMappingManager;

    @Autowired
    public DelegatingRepositorySearcher(DefaultCrossRepositorySearcher crossRepositorySearcher, SpecificRepositorySearcher specificRepositorySearcher, CommitterUserMappingManager committerMappingManager) {
        this.crossRepositorySearcher = crossRepositorySearcher;
        this.specificRepositorySearcher = specificRepositorySearcher;
        this.committerMappingManager = committerMappingManager;
    }

    @Override
    public boolean isApplicable(ActivityItemSearchParams params) {
        return (AppConfig.isFishEye() || AppConfig.isCrucible()) && params.useFEData();
    }

    @Override
    public int getQueryOrder() {
        return 4;
    }

    @Override
    public ActivityItemList findActivityItems(ActivityItemSearchParams params, Principal user, ActivitySearchMonitor activitySearchMonitor) {
        ActivityItemList results;
        if (!this.isApplicable(params)) {
            return ActivityItemList.EMPTY;
        }
        RepositorySearcher provider = params.isRepConstrained() ? this.specificRepositorySearcher : this.crossRepositorySearcher;
        try {
            results = params.getUserFilter() != null && this.committerMappingManager.getAllCommittersForUser(params.getUserFilter()).isEmpty() ? ActivityItemList.EMPTY : provider.findActivityItems(params, user, activitySearchMonitor);
        }
        catch (DbException e2) {
            results = new ActivityItemList(e2);
        }
        return results;
    }
}

