/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.atlassian.fisheye.activity.ActivityItemList;
import com.atlassian.fisheye.activity.ActivityItemSearchParams;
import com.atlassian.fisheye.activity.ActivitySearchMonitor;
import com.atlassian.fisheye.activity.RepositoryConstraints;
import com.atlassian.fisheye.search.SearchSortOrder;
import com.atlassian.fugue.Option;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.cenqua.crucible.model.Principal;
import com.cenqua.fisheye.cache.RecentChangesParams2;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.crossrepo.BranchDocInfo;
import com.cenqua.fisheye.crossrepo.BranchQueryBuilder;
import com.cenqua.fisheye.crossrepo.ChangesetQueryBuilder;
import com.cenqua.fisheye.csindex.CrossRepRecentChangesSearcher2;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.model.manager.CommitterUserMappingManager;
import com.cenqua.fisheye.rep.CrossRepositorySearcher;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.rep.RepositorySearcher;
import com.cenqua.fisheye.user.UserManager;
import com.cenqua.fisheye.util.Pair;
import com.cenqua.fisheye.web.ChangeSetHolder;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@AvailableToPlugins
public class DefaultCrossRepositorySearcher
extends RepositorySearcher
implements CrossRepositorySearcher {
    private final CrossRepLuceneIndex crossRepLuceneIndex;
    private CommitterUserMappingManager committerMappingManager;
    private final UserManager userManager;
    private final RepositoryManager repositoryManager;
    private final CommitterUserMappingManager committerUserMappingManager;

    @Autowired
    public DefaultCrossRepositorySearcher(UserManager userManager, RepositoryManager repositoryManager, CommitterUserMappingManager committerMappingManager, CrossRepLuceneIndex crossRepLuceneIndex, CommitterUserMappingManager committerUserMappingManager) {
        this.userManager = userManager;
        this.repositoryManager = repositoryManager;
        this.committerMappingManager = committerMappingManager;
        this.crossRepLuceneIndex = crossRepLuceneIndex;
        this.committerUserMappingManager = committerUserMappingManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ChangeSetHolder> findRecentChangeSets(ActivityItemSearchParams itemParams, Principal user) throws DbException {
        long t0 = System.currentTimeMillis();
        try {
            if (itemParams.isRepConstrained()) {
                throw new IllegalArgumentException("DefaultCrossRepositorySearcher cannot be called with a rep constraint. Params = " + itemParams);
            }
            Map<String, RepositoryHandle> repoHandles = this.repositoryManager.getHandleMap();
            SearchSortOrder searchSortOrder = itemParams.getSearchDirection();
            int maxReturn = itemParams.getMaxItems();
            Date minDate = itemParams.getMinDate();
            Date maxDate = itemParams.getMaxDate();
            boolean onlyWholeRepositories = true;
            if (itemParams.getCrossRepConstraints() != null) {
                for (RepositoryConstraints.RepositoryConstraint constraint : itemParams.getCrossRepConstraints().getConstraints()) {
                    if (constraint.isIncludeWholeRepository() || constraint.isExcludeWholeRepository()) continue;
                    onlyWholeRepositories = false;
                    break;
                }
            }
            if (onlyWholeRepositories && itemParams.getUserFilter() == null) {
                HashSet<String> searchRepos = new HashSet<String>();
                HashSet dontSearchRepos = new HashSet();
                for (RepositoryHandle h2 : repoHandles.values()) {
                    if (itemParams.getCrossRepConstraints() != null && !itemParams.getCrossRepConstraints().isIncludeWholeRepository(h2.getName())) {
                        dontSearchRepos.add(h2.getName());
                        continue;
                    }
                    if (h2.isRunning() && this.userManager.hasPermissionToAccess(user, h2)) {
                        searchRepos.add(h2.getName());
                        continue;
                    }
                    dontSearchRepos.add(h2.getName());
                }
                if (searchRepos.size() == 0) {
                    List list = Collections.emptyList();
                    return list;
                }
                CrossRepRecentChangesSearcher2 searcher = new CrossRepRecentChangesSearcher2(this.crossRepLuceneIndex.getConnection(), repoHandles, this.committerUserMappingManager);
                String csid = itemParams.getChangeset() != null ? itemParams.getChangeset().getCsid() : null;
                ChangesetQueryBuilder.QueryBuilder queryBuilder = (ChangesetQueryBuilder.QueryBuilder)((ChangesetQueryBuilder.QueryBuilder)((ChangesetQueryBuilder.QueryBuilder)ChangesetQueryBuilder.newCrossRepoBuilder().inDateRange(minDate, maxDate)).optimalRepositoryQuery(searchRepos, dontSearchRepos)).withChangeSetIdOrCommentMatching(csid, itemParams.getCommentSearchText(), false).changesetsOnly();
                if (searchSortOrder == SearchSortOrder.BY_SCORE) {
                    queryBuilder.boostByRecency();
                }
                List<ChangeSetHolder> results = searcher.findChangesets(searchSortOrder, maxReturn, queryBuilder.build());
                this.optimiseResults(searchSortOrder, maxReturn, results);
                List<ChangeSetHolder> list = results;
                return list;
            }
            Logs.APP_LOG.debug((Object)("cross-repo search with repo constraints or user filter " + itemParams));
            HashMap<String, RecentChangesParams2> perRepoParams = new HashMap<String, RecentChangesParams2>();
            for (RepositoryHandle h3 : repoHandles.values()) {
                if (itemParams.getCrossRepConstraints() != null && itemParams.getCrossRepConstraints().getConstraintsForRep(h3.getName()) == null) continue;
                RecentChangesParams2 params = itemParams.generateChangelogParams(h3.getName());
                params.setMinDate(null);
                params.setMaxDate(null);
                if (!h3.isRunning() || !this.userManager.hasPermissionToAccess(user, h3) || itemParams.getUserFilter() != null && !this.addUserQuery(params, h3, itemParams.getUserFilter())) continue;
                perRepoParams.put(h3.getName(), params);
            }
            List<ChangeSetHolder> results = !perRepoParams.isEmpty() ? this.findRecentChangesetsForAllRep(repoHandles, perRepoParams, minDate, maxDate, searchSortOrder, maxReturn) : Collections.emptyList();
            List<ChangeSetHolder> list = results;
            return list;
        }
        finally {
            long t3 = System.currentTimeMillis();
            Logs.APP_LOG.debug((Object)("DefaultCrossRepositorySearcher.findRecentChangeSets() retrieved all changesets in " + (t3 - t0) + "ms"));
        }
    }

    @Override
    public Pair<Integer, List<String>> findRecentlyModifiedBranches(final String repository, String prefix, final int maxItems) {
        final String lowerCasePrefix = prefix == null ? null : prefix.toLowerCase();
        return this.crossRepLuceneIndex.getConnection().withIndexSearcher(CrossRepLuceneIndexes.METADATA, new LuceneConnection.IndexSearcherAction<Pair<Integer, List<String>>>(){

            @Override
            public Pair<Integer, List<String>> perform(IndexSearcher indexSearcher) throws IOException, DbException {
                TopDocs docs;
                Function scoreDocToBranchNameFunction = Functions.compose(BranchDocInfo.TO_BRANCH_NAME, BranchDocInfo.fromScoreDoc(indexSearcher));
                Option exactBranch = Option.none();
                if (StringUtils.isNotBlank((String)lowerCasePrefix)) {
                    BranchQueryBuilder exactMatchBuilder = BranchQueryBuilder.newInstance().exactMatch(repository, lowerCasePrefix);
                    docs = indexSearcher.search(exactMatchBuilder.build(), 1);
                    if (docs.scoreDocs.length > 0) {
                        String branchName = (String)scoreDocToBranchNameFunction.apply((Object)docs.scoreDocs[0]);
                        exactBranch = Option.some((Object)branchName);
                    }
                }
                Object prefixMatchBuilder = BranchQueryBuilder.newInstance().withRepo(repository).withPrefix(lowerCasePrefix);
                docs = indexSearcher.search(((BranchQueryBuilder)prefixMatchBuilder).build(), null, maxItems + (exactBranch.isDefined() ? 1 : 0), new Sort(new SortField("lastModified", 6, true)));
                Iterable prefixBranches = Iterables.filter((Iterable)Iterables.transform(Arrays.asList(docs.scoreDocs), (Function)scoreDocToBranchNameFunction), (Predicate)Predicates.not((Predicate)Predicates.equalTo((Object)exactBranch.getOrNull())));
                ImmutableList branchesCopy = ImmutableList.copyOf((Iterable)Iterables.limit((Iterable)Iterables.concat((Iterable)exactBranch, (Iterable)prefixBranches), (int)maxItems));
                return Pair.newInstance(docs.totalHits, branchesCopy);
            }
        });
    }

    private List<ChangeSetHolder> findRecentChangesetsForAllRep(Map<String, RepositoryHandle> repHandleMap, Map<String, RecentChangesParams2> perRepoParams, Date minDate, Date maxDate, SearchSortOrder searchSortOrder, int maxReturn) throws DbException {
        CrossRepRecentChangesSearcher2 searcher = new CrossRepRecentChangesSearcher2(this.crossRepLuceneIndex.getConnection(), repHandleMap, this.committerUserMappingManager);
        List<ChangeSetHolder> results = searcher.findRecentChangeSets(perRepoParams, minDate, maxDate, searchSortOrder, maxReturn, null);
        this.optimiseResults(searchSortOrder, maxReturn, results);
        return results;
    }

    private boolean addUserQuery(RecentChangesParams2 params, RepositoryHandle h2, String user) throws DbException {
        List<String> matchingCommitters = this.committerMappingManager.getAllCommittersForUserInRep(h2.getName(), user);
        for (String s2 : matchingCommitters) {
            params.addAnyCommiter(s2);
        }
        return !matchingCommitters.isEmpty();
    }

    @Override
    public ActivityItemList findActivityItems(ActivityItemSearchParams itemParams, Principal user, ActivitySearchMonitor activitySearchMonitor) {
        ActivityItemList results;
        if (itemParams.isRepConstrained()) {
            throw new IllegalStateException("Cross repository searcher called with repository constraint");
        }
        try {
            results = new ActivityItemList(this.findRecentChangeSets(itemParams, user));
        }
        catch (DbException e2) {
            results = new ActivityItemList(e2);
        }
        return results;
    }
}

