/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.atlassian.fecru.util.EggTimer;
import com.atlassian.fisheye.model.managers.ChangesetCommentManager;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.cache.BaseRevisionCache;
import com.cenqua.fisheye.cache.InternalRevisionCache;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.SpringContext;
import com.cenqua.fisheye.csindex.ChangesetCommentIndexer;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.util.Timer;
import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;

public abstract class CommonRepositoryScanner<C extends BaseRevisionCache> {
    protected final RepositoryConfig repositoryConfig;
    protected final RepositoryStatus status;
    protected final IndexingContext indexingContext;
    protected C cache;

    public CommonRepositoryScanner(RepositoryConfig repositoryConfig, IndexingContext indexingContext, C cache) {
        this.repositoryConfig = repositoryConfig;
        this.status = repositoryConfig.getStatus();
        this.indexingContext = indexingContext;
        this.cache = cache;
    }

    protected String getRepoName() {
        return this.repositoryConfig.getName();
    }

    protected boolean isStopRequested() {
        return this.status.isStopRequested();
    }

    public void reindexChangesetComments(boolean removeExisting) {
        ChangesetCommentManager changesetCommentManager = SpringContext.getComponentByClass(ChangesetCommentManager.class);
        ChangesetCommentIndexer cci = new ChangesetCommentIndexer(changesetCommentManager);
        cci.reindexRep((InternalRevisionCache)this.getCache(), this.status, removeExisting);
    }

    public abstract void ping() throws DbException, ConfigException;

    public abstract boolean isLicenseLimitReached();

    protected abstract void resetScmMetaData();

    protected Timer startIndexingTimer(long start, long end) {
        return new Timer(String.format("indexChangesetsAndAuthors - %s (%s:%s)", this.getRepoName(), start, end));
    }

    protected void stopIndexingTimer(Timer timer, int changesetCount) {
        if (timer.enabled()) {
            timer.end(String.format("%s changesets (%.2f ms/cs)", changesetCount, changesetCount == 0 ? 0.0 : (double)timer.getTime() / (double)changesetCount));
        } else {
            timer.end();
        }
    }

    public abstract long reindexChangesets(@Nullable Long var1, EggTimer var2) throws DbException;

    @VisibleForTesting
    public C getCache() {
        return this.cache;
    }

    public RepositoryStatus getStatus() {
        return this.status;
    }

    protected void setStatusReindexingChangesets(long start, long end) {
        this.getStatus().setMessage("Background upgrading changesets " + start + " to " + end);
    }
}

