/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.atlassian.crucible.spi.TxCallback;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.fecru.search.index.service.NonScoringCollector;
import com.atlassian.fisheye.event.ChangesetsIndexedEvent;
import com.atlassian.fisheye.event.CommitEventImpl;
import com.atlassian.fisheye.event.DvcsCommitEventImpl;
import com.atlassian.fisheye.event.RepositoryScanProcessedEvent;
import com.atlassian.fisheye.search.SearchSortOrder;
import com.atlassian.fisheye.spi.TxTemplate;
import com.cenqua.crucible.hibernate.HibernateUtil;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.RepositoryManager;
import com.cenqua.fisheye.crossrepo.BranchDocInfo;
import com.cenqua.fisheye.crossrepo.BranchQueryBuilder;
import com.cenqua.fisheye.crossrepo.ChangesetDocInfo;
import com.cenqua.fisheye.crossrepo.ChangesetQueryBuilder;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndex;
import com.cenqua.fisheye.lucene.CrossRepLuceneIndexes;
import com.cenqua.fisheye.lucene.LuceneConnection;
import com.cenqua.fisheye.lucene.LuceneHelper;
import com.cenqua.fisheye.rep.BranchChange;
import com.cenqua.fisheye.rep.BranchState;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.CommitNotification;
import com.cenqua.fisheye.rep.CommitNotificationDAO;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.util.ConfigurableThreadFactory;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TotalHitCountCollector;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.TransactionStatus;

public class CommitEventGenerator {
    private final Executor executor;
    private final TxTemplate txTemplate;
    private final CrossRepLuceneIndex crossRepLuceneIndex;
    private final CommitNotificationDAO commitNotificationDAO;
    private final RepositoryManager repositoryManager;
    private final EventPublisher eventPublisher;

    @Autowired
    public CommitEventGenerator(TxTemplate txTemplate, CommitNotificationDAO commitNotificationDAO, CrossRepLuceneIndex crossRepLuceneIndex, RepositoryManager repositoryManager, EventPublisher eventPublisher) {
        this(txTemplate, commitNotificationDAO, crossRepLuceneIndex, repositoryManager, eventPublisher, Executors.newSingleThreadExecutor(new ConfigurableThreadFactory("CommitNotifier", true)));
    }

    public CommitEventGenerator(TxTemplate txTemplate, CommitNotificationDAO commitNotificationDAO, CrossRepLuceneIndex crossRepLuceneIndex, RepositoryManager repositoryManager, EventPublisher eventPublisher, Executor executor) {
        this.txTemplate = txTemplate;
        this.commitNotificationDAO = commitNotificationDAO;
        this.crossRepLuceneIndex = crossRepLuceneIndex;
        this.repositoryManager = repositoryManager;
        this.eventPublisher = eventPublisher;
        this.executor = executor;
    }

    @PostConstruct
    public void init() {
        this.eventPublisher.register((Object)this);
    }

    @PreDestroy
    public void release() {
        this.eventPublisher.unregister((Object)this);
    }

    @EventListener
    public void onChangesetsIndexed(ChangesetsIndexedEvent event) {
        CommitEventNotifier notifierTask = new CommitEventNotifier(this.repositoryManager.getRepository(event.getRepositoryName()));
        Logs.APP_LOG.debug((Object)("Submitting CommitEventNotifier (" + notifierTask + ") for repository " + event.getRepositoryName()));
        this.executor.execute(notifierTask);
    }

    protected RepositoryScanProcessedEvent getRepositoryChanges(CommitNotification commitNotification, String repoName, RevisionCache<? extends ChangeSet> revCache) {
        long currentCsIndexSerial;
        Logs.APP_LOG.debug((Object)("CommitNotification is: " + commitNotification));
        long revLastMod = revCache.getLastModifiedDate();
        long currentCsn = revCache.getCacheSerialNumber();
        try {
            currentCsIndexSerial = this.crossRepLuceneIndex.getConnection().getIndexSerial(CrossRepLuceneIndexes.METADATA);
        }
        catch (IOException e2) {
            Logs.APP_LOG.error((Object)"Error fetching index version, not emitting commit notifications", (Throwable)e2);
            return new RepositoryScanProcessedEvent(repoName, Collections.emptySet(), Collections.emptySet());
        }
        Logs.APP_LOG.debug((Object)String.format("Current state is: revLastMod=%s, currentCsn=%s, currentCsIndexSerial=%s", revLastMod, currentCsn, currentCsIndexSerial));
        boolean cacheSerialDiffers = currentCsn != commitNotification.getCacheSerialOfLastRevision();
        boolean indexVersionDiffers = currentCsIndexSerial != commitNotification.getChangesetIndexSerial();
        boolean hasBeenReindexed = cacheSerialDiffers || indexVersionDiffers;
        long lastChecked = hasBeenReindexed ? System.currentTimeMillis() : commitNotification.getLastChecked();
        Logs.APP_LOG.debug((Object)String.format("cacheSerialDiffers=%s, indexVersionDiffers=%s -> hasBeenReindexed=%s", cacheSerialDiffers, indexVersionDiffers, hasBeenReindexed));
        revLastMod = revLastMod > 0L ? revLastMod : System.currentTimeMillis();
        RepositoryScanProcessedEvent changesEvent = hasBeenReindexed ? new RepositoryScanProcessedEvent(repoName, Collections.emptySet(), Collections.emptySet()) : this.findChanges(repoName, lastChecked, revLastMod);
        commitNotification.setCacheSerialOfLastRevision(currentCsn);
        commitNotification.setLastChecked(revLastMod);
        commitNotification.setChangesetIndexSerial(currentCsIndexSerial);
        Logs.APP_LOG.debug((Object)("Updating CommitNotification: " + commitNotification));
        return changesEvent;
    }

    protected RepositoryScanProcessedEvent findChanges(final String repoName, final long minIndexingTime, final long maxIndexingTime) {
        return this.crossRepLuceneIndex.getConnection().withIndexSearcher(CrossRepLuceneIndexes.METADATA, new LuceneConnection.IndexSearcherAction<RepositoryScanProcessedEvent>(){

            @Override
            public RepositoryScanProcessedEvent perform(IndexSearcher searcher) throws IOException, DbException {
                Logs.APP_LOG.debug((Object)String.format("Looking for changesets and branches indexed between %s and %s", minIndexingTime, maxIndexingTime));
                List csids = CommitEventGenerator.this.findChangedChangesetIds(searcher, repoName, minIndexingTime, maxIndexingTime);
                ImmutableList branches = CommitEventGenerator.this.findChangedBranches(searcher, repoName, minIndexingTime, maxIndexingTime);
                Logs.APP_LOG.debug((Object)String.format("Returning RepositoryScanProcessedEvent with %s csids and %s branches", csids.size(), branches.size()));
                return new RepositoryScanProcessedEvent(repoName, csids, (Iterable<BranchChange>)branches);
            }
        });
    }

    private List<String> findChangedChangesetIds(final IndexSearcher searcher, String repoName, long minIndexingTime, long maxIndexingTime) throws IOException {
        ImmutableList csids;
        Query csQuery = ChangesetQueryBuilder.queryChangesetsIndexedBetween(repoName, minIndexingTime, maxIndexingTime);
        TotalHitCountCollector csCountCollector = new TotalHitCountCollector();
        searcher.search(csQuery, (Collector)csCountCollector);
        if (csCountCollector.getTotalHits() > 0) {
            TopFieldDocs csDocs = searcher.search(csQuery, csCountCollector.getTotalHits(), SearchSortOrder.TOWARDS_FUTURE.getLuceneSort());
            csids = ImmutableList.copyOf((Collection)Lists.transform(Arrays.asList(csDocs.scoreDocs), (Function)new Function<ScoreDoc, String>(){

                public String apply(ScoreDoc input) {
                    try {
                        return ChangesetDocInfo.fromSearchHitRepCsidOnly(searcher, input).getChangesetId();
                    }
                    catch (IOException e2) {
                        throw new DbException(e2);
                    }
                }
            }));
        } else {
            csids = Collections.emptyList();
        }
        return csids;
    }

    private ImmutableList<BranchChange> findChangedBranches(IndexSearcher searcher, String repoName, final long minIndexingTime, long maxIndexingTime) throws IOException {
        final ImmutableList.Builder branchChanges = ImmutableList.builder();
        searcher.search(((BranchQueryBuilder)((BranchQueryBuilder)BranchQueryBuilder.newInstance().withRepo(repoName).updatedBetween(minIndexingTime, maxIndexingTime)).inAnyState()).build(), (Collector)new NonScoringCollector(){

            public void collect(int doc) throws IOException {
                BranchDocInfo branchDocInfo = BranchDocInfo.fromDocumentToBranchDocInfo(this.currentReader.document(doc));
                Long firstIndexed = branchDocInfo.getFirstIndexedTimestamp();
                String branchState = branchDocInfo.getBranchState();
                if (branchState != null && BranchState.of(branchState).isRemovedState()) {
                    branchChanges.add((Object)new BranchChange(branchDocInfo.getBranch(), BranchChange.ChangeType.REMOVED));
                } else if (firstIndexed != null && firstIndexed > minIndexingTime) {
                    branchChanges.add((Object)new BranchChange(branchDocInfo.getBranch(), BranchChange.ChangeType.ADDED));
                } else {
                    branchChanges.add((Object)new BranchChange(branchDocInfo.getBranch(), BranchChange.ChangeType.MODIFIED));
                }
            }
        });
        return branchChanges.build();
    }

    public CommitNotification findOrCreateCommitNotification(final String repoName) {
        CommitNotification commitNotification = this.txTemplate.execute(new TxCallback<CommitNotification>(){

            @Override
            public CommitNotification doInTransaction(TransactionStatus status) throws Exception {
                return CommitEventGenerator.this.commitNotificationDAO.getCommitNotification(repoName);
            }
        });
        if (commitNotification != null) {
            return commitNotification;
        }
        CommitNotification newCommitNotification = new CommitNotification(repoName);
        Logs.APP_LOG.debug((Object)("No CommitNotification found, created new one: " + newCommitNotification));
        return newCommitNotification;
    }

    public void saveOrUpdateCommitNotification(final CommitNotification commitNotification) {
        this.txTemplate.execute(new TxCallback<Void>(){

            @Override
            public Void doInTransaction(TransactionStatus status) throws Exception {
                CommitEventGenerator.this.commitNotificationDAO.saveOrUpdateCommitNotification(commitNotification);
                return null;
            }
        });
    }

    public boolean existsInMultipleRepositories(final String csid) {
        return this.crossRepLuceneIndex.getConnection().withIndexSearcher(CrossRepLuceneIndexes.METADATA, new LuceneConnection.IndexSearcherAction<Boolean>(){

            @Override
            public Boolean perform(IndexSearcher indexSearcher) throws IOException, DbException {
                return LuceneHelper.countMatchingDocuments(indexSearcher, ((ChangesetQueryBuilder.QueryBuilder)ChangesetQueryBuilder.newCrossRepoBuilder().changesetsOnly()).withChangeSetId(csid).build()) > 1;
            }
        });
    }

    class CommitEventNotifier
    implements Runnable {
        private final RepositoryHandle repositoryHandle;

        public CommitEventNotifier(RepositoryHandle repositoryHandle) {
            this.repositoryHandle = repositoryHandle;
        }

        @Override
        public void run() {
            try {
                Logs.APP_LOG.debug((Object)("Processing CommitEventNotifier (" + this + ") for repository " + this.repositoryHandle.getName()));
                if (!this.repositoryHandle.isRunning()) {
                    Logs.APP_LOG.debug((Object)"Repository not running, aborting");
                    return;
                }
                this.repositoryHandle.withEngine(new Function<RepositoryEngine, Void>(){

                    public Void apply(RepositoryEngine engine) {
                        boolean dvcs = CommitEventNotifier.this.repositoryHandle.getCfg().getRepositoryType().isDvcs();
                        CommitNotification commitNotification = CommitEventGenerator.this.findOrCreateCommitNotification(engine.getName());
                        RepositoryScanProcessedEvent scanProcessedEvent = CommitEventGenerator.this.getRepositoryChanges(commitNotification, engine.getName(), engine.getRevisionCache());
                        Logs.APP_LOG.debug((Object)("Changeset ID list contains " + scanProcessedEvent.getChangesetIds().size() + " changesets"));
                        for (String csid : scanProcessedEvent.getChangesetIds()) {
                            Logs.APP_LOG.debug((Object)("publishing event for changeset id " + csid));
                            CommitEventImpl event = dvcs ? new DvcsCommitEventImpl(engine.getName(), csid, CommitEventGenerator.this.existsInMultipleRepositories(csid)) : new CommitEventImpl(engine.getName(), csid);
                            CommitEventGenerator.this.eventPublisher.publish((Object)event);
                        }
                        if (scanProcessedEvent.hasItems()) {
                            Logs.APP_LOG.debug((Object)("Publishing RepositoryScanProcessedEvent: " + scanProcessedEvent));
                            CommitEventGenerator.this.eventPublisher.publish((Object)scanProcessedEvent);
                        }
                        CommitEventGenerator.this.saveOrUpdateCommitNotification(commitNotification);
                        return null;
                    }
                });
            }
            catch (Exception e2) {
                Logs.APP_LOG.error((Object)"Error sending commitEvent", (Throwable)e2);
            }
            finally {
                HibernateUtil.closeSession();
            }
        }
    }
}

