/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import java.util.HashMap;
import java.util.Map;

public enum ChangeSetIndexingState {
    UNKNOWN(0),
    SCANNED(1),
    INFILLED(2),
    METADATA_INDEXED(3),
    CONTENT_INDEXED(4),
    COMPLETE(5);

    private final int value;
    private static final Map<Integer, ChangeSetIndexingState> stateMap;

    private ChangeSetIndexingState(int i2) {
        this.value = i2;
    }

    public int getValue() {
        return this.value;
    }

    public static ChangeSetIndexingState getState(int value) {
        ChangeSetIndexingState state = stateMap.get(value);
        return state == null ? UNKNOWN : state;
    }

    public ChangeSetIndexingState previous() {
        if (this == UNKNOWN) {
            return UNKNOWN;
        }
        return ChangeSetIndexingState.getState(this.value - 1);
    }

    static {
        stateMap = new HashMap<Integer, ChangeSetIndexingState>();
        for (ChangeSetIndexingState state : ChangeSetIndexingState.values()) {
            stateMap.put(state.getValue(), state);
        }
    }
}

