/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.fisheye.Visitor;
import com.atlassian.fisheye.db.FileRevisionDAO;
import com.cenqua.crucible.CrucibleSysProps;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.ChangeSetIndexingState;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.LazySoftReference;
import com.cenqua.fisheye.rep.MutableChangeSet;
import com.cenqua.fisheye.rep.Position;
import com.cenqua.fisheye.rep.impl.ChangeSetDAO;
import com.cenqua.fisheye.util.CompareUtil;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ChangeSetImpl<F extends FileRevision>
implements MutableChangeSet {
    private ChangeSetDAO<F, ? extends ChangeSet> changeSetDAO;
    private FileRevisionDAO<F> fileRevisionDAO;
    private Set<String> tags;
    private List<String> parents;
    private List<String> children;
    private String id = null;
    private String comment = null;
    private String author = null;
    private long date = 0L;
    private Position position = null;
    private Integer numberOfRevisions = null;
    private Boolean isMetaDataOnlyChange;
    private Boolean isPartialMetaDataChange;
    private LazySoftReference<List<F>> readonlyRevisions = new LazySoftReference<List<F>>(){

        @Override
        protected List<F> load() {
            final ArrayList revs = new ArrayList();
            try {
                ChangeSetImpl.this.fileRevisionDAO.visitChangeSetRevisions(ChangeSetImpl.this.getId(), new StoppableVisitor<FileRevision>(){

                    @Override
                    public boolean visit(FileRevision revision) {
                        revs.add(revision);
                        return true;
                    }
                });
            }
            catch (DbException e2) {
                Logs.APP_LOG.info((Object)("Problem loading file revisions for changeset " + ChangeSetImpl.this.getId()), (Throwable)e2);
            }
            return revs;
        }
    };
    private Set<String> branches;
    private Set<String> branchesContributedTo;
    private String repName = null;
    private Set<String> nextCrossBranchCommits;
    private ChangeSetIndexingState indexingState = ChangeSetIndexingState.UNKNOWN;
    private Map<ChangeSetIndexingState, Long> indexingStateVersions;

    protected ChangeSetImpl() {
    }

    public ChangeSetImpl(String id, ChangeSetDAO<F, ? extends ChangeSet> changeSetDAO, FileRevisionDAO<F> revisionDAO) {
        this.id = id;
        this.changeSetDAO = changeSetDAO;
        this.fileRevisionDAO = revisionDAO;
        this.tags = new HashSet<String>(1);
        this.branches = new HashSet<String>(1);
        this.parents = new ArrayList<String>(2);
        this.children = new ArrayList<String>(2);
        this.branchesContributedTo = new HashSet<String>(0);
        this.nextCrossBranchCommits = new HashSet<String>(0);
    }

    @Override
    public int compareTo(ChangeSet changeSet) {
        return CompareUtil.compare(this.getPosition(), changeSet.getPosition());
    }

    protected FileRevisionDAO<F> getFileRevisionDao() {
        return this.fileRevisionDAO;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    @Override
    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        this.author = author.trim();
    }

    @Override
    public String getRepName() {
        return this.repName;
    }

    @Override
    public String getCrossRepoId() {
        return this.getRepName() + ":" + this.getId();
    }

    public void setRepName(String repName) {
        this.repName = repName;
    }

    @Override
    public String getBranch() {
        return this.branches != null && !this.branches.isEmpty() ? this.branches.iterator().next() : null;
    }

    public Set<String> getBranchesContributedTo() {
        return this.branchesContributedTo;
    }

    public void setBranchesContributedTo(List<String> branches) {
        this.branchesContributedTo.clear();
        this.branchesContributedTo.addAll(branches);
    }

    @Override
    public Set<String> getBranches() {
        return this.branches;
    }

    @Override
    public void setBranches(Collection<String> branches) {
        this.branches.clear();
        this.branches.addAll(branches);
    }

    public void setBranch(String branch) {
        this.branches.clear();
        this.branches.add(branch);
    }

    @Override
    public String getDisplayId() {
        return this.getId();
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Position position) {
        this.position = position;
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    @Override
    public long getDate() {
        return this.date;
    }

    public void setDate(long date) {
        this.date = date;
    }

    @Override
    public Date getDateValue() {
        return new Date(this.getDate());
    }

    @Override
    public Set<String> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    public void setTags(Collection<String> tags) {
        this.tags.clear();
        this.tags.addAll(tags);
    }

    @Override
    public List<String> getParents() {
        return Collections.unmodifiableList(this.parents);
    }

    @Override
    public void setParents(Iterable<String> parents) {
        this.parents.clear();
        Iterables.addAll(this.parents, parents);
    }

    @Override
    public List<String> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public void setChildren(List<String> children) {
        this.children.clear();
        this.children.addAll(children);
    }

    public List<F> getFileRevisions() {
        return Collections.unmodifiableList(this.readonlyRevisions.get());
    }

    @Override
    public int getRevisionInfosCount() {
        if (this.numberOfRevisions == null) {
            this.numberOfRevisions = this.changeSetDAO.getRevisionCount(this.getId());
        }
        return this.numberOfRevisions;
    }

    public static int dateCompare(ChangeSet cs1, ChangeSet cs2) {
        int c2 = CompareUtil.compareTo(cs1.getDate(), cs2.getDate());
        if (c2 == 0) {
            if (cs1.getRepName().equals(cs2.getRepName())) {
                return cs1.compareSecondarySort(cs2);
            }
            return CompareUtil.compare(cs1.getRepName(), cs2.getRepName());
        }
        return c2;
    }

    @Override
    public int dateCompare(ChangeSet bound) {
        return ChangeSetImpl.dateCompare(this, bound);
    }

    @Override
    public int compareSecondarySort(ChangeSet bound) {
        return CompareUtil.compare(this.getId(), bound.getId());
    }

    @Override
    public Set<Integer> getReviewIds() throws DbException {
        return this.getFileRevisionDao().getCommonRevInfoDAO().getReviewsForChangeset(this.getId());
    }

    public F searchRevisions(Predicate<FileRevision> predicate) throws DbException {
        return this.fileRevisionDAO.searchChangeSetRevisions(this.getId(), predicate);
    }

    @Override
    public void visitRevisions(StoppableVisitor<FileRevision> visitor) throws DbException {
        this.fileRevisionDAO.visitChangeSetRevisions(this.getId(), visitor);
    }

    @Override
    public void visitRevisions(final Visitor<FileRevision> visitor) throws DbException {
        this.visitRevisions(new StoppableVisitor<FileRevision>(){

            @Override
            public boolean visit(FileRevision object) {
                visitor.visit(object);
                return true;
            }
        });
    }

    public void visitRevisions(Visitor<FileRevision> visitor, Predicate<Integer> breakCondition) throws DbException {
        this.fileRevisionDAO.visitChangeSetRevisions(this.getId(), visitor, breakCondition);
    }

    @Override
    public boolean isAfter(ChangeSet other) {
        if (this.getPosition() != null && other != null && other.getPosition() != null) {
            return this.getPosition().compareTo(other.getPosition()) > 0;
        }
        return false;
    }

    @Override
    public boolean isBefore(ChangeSet other) {
        if (this.getPosition() != null && other != null && other.getPosition() != null) {
            return this.getPosition().compareTo(other.getPosition()) < 0;
        }
        return false;
    }

    @Override
    public Set<String> getNextCrossBranchCommits() {
        return this.nextCrossBranchCommits;
    }

    public void setNextCrossBranchCommits(Collection<String> commits) {
        this.nextCrossBranchCommits.clear();
        this.nextCrossBranchCommits.addAll(commits);
    }

    @Override
    public Iterable<Path> getPaths() {
        return this.fileRevisionDAO.getPathsInChangeset(this.getId());
    }

    @Override
    public boolean isMetadataOnlyChange() {
        if (this.isMetaDataOnlyChange == null) {
            this.calculateMetaDataProperties(false);
        }
        return this.isMetaDataOnlyChange;
    }

    @Override
    public boolean isPartialMetadataChange() {
        if (this.isPartialMetaDataChange == null) {
            this.calculateMetaDataProperties(true);
        }
        return this.isPartialMetaDataChange;
    }

    private void calculateMetaDataProperties(final boolean testForPartial) {
        if (this.isPartialMetaDataChange == null) {
            final boolean[] foundMetaDataChange = new boolean[]{false};
            final boolean[] foundNonMetaDataChange = new boolean[]{false};
            final boolean[] brokeEarly = new boolean[]{false};
            if (CrucibleSysProps.DETECT_METADATA_REVISION_CHANGES) {
                this.visitRevisions(new Visitor<FileRevision>(){

                    @Override
                    public void visit(FileRevision rev) {
                        if (rev.isMetadataOnlyChange()) {
                            foundMetaDataChange[0] = true;
                        } else {
                            foundNonMetaDataChange[0] = true;
                        }
                    }
                }, new Predicate<Integer>(){

                    public boolean apply(Integer input) {
                        boolean result = testForPartial ? foundMetaDataChange[0] && foundNonMetaDataChange[0] : foundNonMetaDataChange[0];
                        brokeEarly[0] = result;
                        return result;
                    }
                });
            }
            this.isMetaDataOnlyChange = foundMetaDataChange[0] && !foundNonMetaDataChange[0];
            if (foundMetaDataChange[0] && foundNonMetaDataChange[0]) {
                this.isPartialMetaDataChange = true;
            } else if (!(brokeEarly[0] || foundMetaDataChange[0] && foundNonMetaDataChange[0])) {
                this.isPartialMetaDataChange = false;
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ChangeSetImpl other = (ChangeSetImpl)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public Iterable<F> getRevisionsIterable() {
        return this.fileRevisionDAO.getRevisionIterable(this.getId());
    }

    public void setIndexingState(ChangeSetIndexingState indexingState) {
        this.indexingState = indexingState;
    }

    public ChangeSetIndexingState getIndexingState() {
        return this.indexingState;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Changeset: ");
        sb.append(" id: ").append(this.id);
        sb.append(", author: ").append(this.author);
        sb.append(", date: ").append(this.date);
        sb.append(", comment: ").append(this.comment);
        return sb.toString();
    }

    public void setIndexingStateVersions(Map<ChangeSetIndexingState, Long> indexingStateVersions) {
        this.indexingStateVersions = indexingStateVersions;
    }

    public Long getIndexingStateVersion(ChangeSetIndexingState state) {
        return this.indexingStateVersions.get((Object)state);
    }

    @Override
    public Collection<String> getFixes() throws DbException {
        return Collections.emptyList();
    }

    @Override
    public boolean isInBranch(String branchName) {
        return this.getBranches().contains(branchName);
    }
}

