/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.atlassian.fisheye.StoppableVisitor;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.util.Timer;
import com.cenqua.fisheye.web.tags.ExpressionUtil;
import java.util.concurrent.atomic.AtomicReference;

public class ChangeSetDescriber {
    public static String describe(ChangeSet changeset) {
        Timer t2 = new Timer("describe csid=" + changeset.getId());
        final AtomicReference<FragmentType> type = new AtomicReference<FragmentType>();
        int revCount = changeset.getRevisionInfosCount();
        t2.mark("revcount=" + revCount);
        if (revCount > 50) {
            type.set(FragmentType.MIXED);
        } else {
            changeset.visitRevisions(new StoppableVisitor<FileRevision>(){

                @Override
                public boolean visit(FileRevision rev) {
                    FragmentType revType = FragmentType.getTypeForRevision(rev);
                    if (type.get() == null) {
                        type.set(revType);
                    } else if (type.get() != revType) {
                        type.set(FragmentType.MIXED);
                        return false;
                    }
                    return true;
                }
            });
        }
        if (type.get() == null) {
            type.set(FragmentType.MIXED);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(((FragmentType)((Object)type.get())).getVerb()).append(" ").append(revCount).append(" ").append(ExpressionUtil.pluralise("file", "files", revCount));
        t2.end();
        return sb.toString();
    }

    private static enum FragmentType {
        ADDED("added"){

            @Override
            boolean describes(FileRevision rev) {
                return rev.isAdded();
            }
        }
        ,
        DELETED("deleted"){

            @Override
            boolean describes(FileRevision rev) {
                return rev.isDead();
            }
        }
        ,
        MOVED("moved"){

            @Override
            boolean describes(FileRevision rev) {
                return rev.isMove();
            }
        }
        ,
        COPIED("copied"){

            @Override
            boolean describes(FileRevision rev) {
                return rev.isCopy();
            }
        }
        ,
        MODIFIED_BINARY("updated"){

            @Override
            boolean describes(FileRevision rev) {
                return rev.isModify() && rev.isBinary();
            }
        }
        ,
        UPDATED_METADATA("updated metadata for"){

            @Override
            boolean describes(FileRevision rev) {
                return rev.isMetadataOnlyChange();
            }
        }
        ,
        MIXED("changed"){

            @Override
            boolean describes(FileRevision rev) {
                return true;
            }
        };

        private final String verb;

        private FragmentType(String verb) {
            this.verb = verb;
        }

        public String getVerb() {
            return this.verb;
        }

        abstract boolean describes(FileRevision var1);

        public static FragmentType getTypeForRevision(FileRevision rev) {
            for (FragmentType type : FragmentType.values()) {
                if (!type.describes(rev)) continue;
                return type;
            }
            return MIXED;
        }
    }
}

