/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.atlassian.fisheye.StoppableVisitor;
import com.atlassian.fisheye.Visitor;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.Position;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;

public interface ChangeSet
extends Comparable<ChangeSet> {
    public static final Comparator<ChangeSet> COMPARE_TOWARDS_FUTURE = new Comparator<ChangeSet>(){

        @Override
        public int compare(ChangeSet a2, ChangeSet b2) {
            if (a2 == null) {
                return b2 == null ? 0 : 1;
            }
            return a2.dateCompare(b2);
        }
    };
    public static final Comparator<ChangeSet> COMPARE_TOWARDS_PAST = new Comparator<ChangeSet>(){

        @Override
        public int compare(ChangeSet a2, ChangeSet b2) {
            if (a2 == null) {
                return b2 == null ? 0 : -1;
            }
            return -a2.dateCompare(b2);
        }
    };
    public static final Function<ChangeSet, String> TO_CSID = new Function<ChangeSet, String>(){

        public String apply(ChangeSet input) {
            return input.getId();
        }
    };
    public static final Function<ChangeSet, String> TO_COMMENT = new Function<ChangeSet, String>(){

        @Nullable
        public String apply(@Nullable ChangeSet changeSet) {
            return changeSet != null ? changeSet.getComment() : null;
        }
    };

    public String getId();

    public String getDisplayId();

    public String getAuthor();

    public String getRepName();

    public String getCrossRepoId();

    public List<String> getParents();

    public List<String> getChildren();

    public Position getPosition();

    public boolean isBefore(ChangeSet var1);

    public boolean isAfter(ChangeSet var1);

    public Set<String> getTags();

    public String getBranch();

    public Set<String> getBranches();

    public boolean isInBranch(String var1);

    public String getComment();

    public long getDate();

    public Date getDateValue();

    public Iterable<Path> getPaths();

    public List<? extends FileRevision> getFileRevisions();

    public int getRevisionInfosCount();

    public FileRevision searchRevisions(Predicate<FileRevision> var1) throws DbException;

    public void visitRevisions(StoppableVisitor<FileRevision> var1) throws DbException;

    public void visitRevisions(Visitor<FileRevision> var1) throws DbException;

    public Set<Integer> getReviewIds() throws DbException;

    public int dateCompare(ChangeSet var1);

    public Set<String> getNextCrossBranchCommits();

    public boolean isMetadataOnlyChange();

    public boolean isPartialMetadataChange();

    public int compareSecondarySort(ChangeSet var1);

    public Iterable<? extends FileRevision> getRevisionsIterable();

    public Collection<String> getFixes() throws DbException;
}

