/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryHandle;
import com.cenqua.fisheye.util.BaseThreadedProcessor;
import com.cenqua.fisheye.util.Disposer;

public class CacheWarmer
extends BaseThreadedProcessor {
    @Override
    protected void processEvent(Object event) throws Exception {
        Disposer.pushThreadInstance();
        try {
            this.warm((String)event);
        }
        finally {
            Disposer.popThreadInstance();
        }
    }

    private void warm(String repname) throws DbException {
        RepositoryEngine eng;
        Logs.APP_LOG.debug((Object)("Warming " + repname));
        RootConfig rootConfig = AppConfig.getsConfig();
        RepositoryHandle rh = rootConfig.getRepositoryManager().getRepository(repname);
        if (rh == null) {
            if (!AppConfig.isTestMode()) {
                Logs.APP_LOG.warn((Object)("couldn't find repository " + repname));
            }
            return;
        }
        try {
            eng = rh.acquireEngine();
        }
        catch (RepositoryHandle.StateException e2) {
            Logs.APP_LOG.debug((Object)("repository wasn't running: " + repname));
            return;
        }
        eng.getDirTreeCache().warm();
    }
}

