/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import java.util.EnumSet;

public enum BranchState {
    ACTIVE("A"),
    INACTIVE("I"),
    CLOSED("C"),
    REMOVED("D");

    private static final EnumSet<BranchState> REMOVED_STATES;
    private String value;

    private BranchState(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public static BranchState of(String value) {
        for (BranchState bs : BranchState.values()) {
            if (!bs.value.equals(value)) continue;
            return bs;
        }
        throw new IllegalArgumentException("No BranchState defined for value " + value);
    }

    public boolean isRemovedState() {
        return REMOVED_STATES.contains((Object)this);
    }

    static {
        REMOVED_STATES = EnumSet.of(CLOSED, REMOVED);
    }
}

