/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.atlassian.fugue.Option;
import com.cenqua.fisheye.rep.BranchState;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import javax.annotation.Nullable;

public class Branch
implements Cloneable {
    public static final long UNKNOWN_TIMESTAMP = -1L;
    private final String name;
    private BranchState state;
    private String latestChangeSetId;
    private Option<String> latestMarkedChangesetId = Option.none();
    private long firstIndexedTimestamp = -1L;
    private long lastIndexedTimestamp = -1L;
    public static final Function<Branch, String> TO_LATEST_CHANGESET_ID = new Function<Branch, String>(){

        public String apply(Branch input) {
            return input.getLatestChangeSetId();
        }
    };
    public static final Function<Branch, String> TO_NAME = new Function<Branch, String>(){

        public String apply(Branch input) {
            return input.getName();
        }
    };
    public static final Predicate<Branch> NOT_REMOVED = Predicates.not(Branch.inState(BranchState.REMOVED));

    public Branch(String name) {
        this(name, null, null);
    }

    public Branch(String name, String latestChangeset, BranchState state) {
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.latestChangeSetId = latestChangeset;
        this.state = state;
    }

    public String getName() {
        return this.name;
    }

    public BranchState getState() {
        return this.state;
    }

    public void setState(BranchState state) {
        this.state = state;
    }

    public String getLatestChangeSetId() {
        return this.latestChangeSetId;
    }

    public void setLatestChangeSetId(String latestChangeSetId) {
        this.latestChangeSetId = latestChangeSetId;
    }

    public long getFirstIndexedTimestamp() {
        return this.firstIndexedTimestamp;
    }

    public long getLastIndexedTimestamp() {
        return this.lastIndexedTimestamp;
    }

    public void setFirstIndexedTimestamp(long firstIndexedTimestamp) {
        this.firstIndexedTimestamp = firstIndexedTimestamp;
    }

    public void setLastIndexedTimestamp(long lastIndexedTimestamp) {
        this.lastIndexedTimestamp = lastIndexedTimestamp;
    }

    public Option<String> getLatestMarkedChangesetId() {
        return this.latestMarkedChangesetId;
    }

    public void setLatestMarkedChangesetId(Option<String> latestMarkedChangesetId) {
        this.latestMarkedChangesetId = (Option)Preconditions.checkNotNull(latestMarkedChangesetId);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Branch other = (Branch)obj;
        return Objects.equal((Object)this.name, (Object)other.name) && Objects.equal((Object)((Object)this.state), (Object)((Object)other.state)) && Objects.equal((Object)this.latestChangeSetId, (Object)other.latestChangeSetId);
    }

    public String toString() {
        return this.name + "@" + this.latestChangeSetId + "(" + (Object)((Object)this.state) + ")" + (this.latestMarkedChangesetId == null ? "" : " (latest marked: " + this.latestMarkedChangesetId);
    }

    public Branch clone() {
        try {
            return (Branch)super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new IllegalStateException(e2);
        }
    }

    public static Predicate<Branch> inState(final BranchState state) {
        return new Predicate<Branch>(){

            public boolean apply(@Nullable Branch input) {
                return input != null && input.getState() == state;
            }
        };
    }
}

