/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.FileRevision;
import java.util.Date;
import java.util.Objects;

public class BlameInfo {
    private final String author;
    private final Path path;
    private final String revision;
    private final long date;
    private final String displayRevision;
    private final String changeSetId;

    public BlameInfo(FileRevision fileRevision) {
        this(fileRevision.getRevision(), fileRevision.getDisplayRevision(), fileRevision.getChangeSetId(), fileRevision.getPath(), fileRevision.getAuthor(), fileRevision.getDate());
    }

    protected BlameInfo(String revision, String displayRevision, String changeSetId, Path path, String author, long date) {
        this.author = author;
        this.path = path;
        this.revision = revision;
        this.date = date;
        this.displayRevision = displayRevision;
        this.changeSetId = changeSetId;
    }

    public String getAuthor() {
        return this.author;
    }

    public Path getPath() {
        return this.path;
    }

    public String getRevision() {
        return this.revision;
    }

    public long getDate() {
        return this.date;
    }

    public Date getDateValue() {
        return new Date(this.date);
    }

    public String getDisplayRevision() {
        return this.displayRevision;
    }

    public String getChangeSetId() {
        return this.changeSetId;
    }

    public int hashCode() {
        return Objects.hash(this.author, this.path, this.revision, this.date, this.displayRevision, this.changeSetId);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BlameInfo other = (BlameInfo)obj;
        return Objects.equals(this.author, other.author) && Objects.equals(this.path, other.path) && Objects.equals(this.revision, other.revision) && Objects.equals(this.date, other.date) && Objects.equals(this.displayRevision, other.displayRevision) && Objects.equals(this.changeSetId, other.changeSetId);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{" + "author='" + this.author + '\'' + ", revision='" + this.revision + '\'' + ", date=" + this.date + ", displayRevision='" + this.displayRevision + '\'' + ", changeSetId='" + this.changeSetId + '\'' + '}';
    }
}

