/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.rep.BlameInfo;
import com.cenqua.fisheye.rep.FileRevision;
import java.util.Objects;

public class BlameChunk
implements Comparable<BlameChunk> {
    private BlameInfo info;
    private int start;
    private int originalStartingLine;
    private int revId = -1;
    private int length = 1;

    public BlameChunk(FileRevision info, int start, int originalStartingLine) {
        if (info != null) {
            this.info = new BlameInfo(info);
            this.revId = info.getRevID();
        }
        this.start = start;
        this.originalStartingLine = originalStartingLine;
    }

    public BlameChunk(BlameInfo info, int start, int originalStartingLine, int length) {
        this.info = info;
        this.start = start;
        this.originalStartingLine = originalStartingLine;
        this.length = length;
    }

    public BlameChunk(int start, int originalStartingLine, int length, int revId) {
        this.start = start;
        this.originalStartingLine = originalStartingLine;
        this.length = length;
        this.revId = revId;
    }

    @Override
    public int compareTo(BlameChunk span) {
        return this.start - span.start;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public BlameChunk getCopy() {
        BlameChunk copy = new BlameChunk(this.info, this.start, this.originalStartingLine, this.length);
        copy.setRevId(this.revId);
        return copy;
    }

    public int getRevId() {
        return this.revId;
    }

    public void setRevId(int revId) {
        this.revId = revId;
    }

    public void setBlameInfo(FileRevision info) {
        if (info != null) {
            this.setBlameInfo(new BlameInfo(info));
        }
    }

    public void setBlameInfo(BlameInfo info) {
        this.info = info;
    }

    public String getRevision() {
        if (this.info == null) {
            return String.valueOf(this.revId);
        }
        return this.info.getRevision();
    }

    public String getDisplayRevision() {
        if (this.info == null) {
            return String.valueOf(this.revId);
        }
        return this.info.getDisplayRevision();
    }

    public BlameInfo getInfo() {
        return this.info;
    }

    public int getStart() {
        return this.start;
    }

    public int getOriginalStartingLine() {
        return this.originalStartingLine;
    }

    public int getLength() {
        return this.length;
    }

    public void incLength(int inc) {
        this.length += inc;
    }

    public String toString() {
        return this.start + "-" + (this.start + this.length) + ":" + this.getRevId() + (this.info == null ? "" : " - " + this.info);
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        BlameChunk that = (BlameChunk)o2;
        return this.start == that.start && this.originalStartingLine == that.originalStartingLine && this.revId == that.revId && this.length == that.length && Objects.equals(this.info, that.info);
    }

    public int hashCode() {
        return Objects.hash(this.info, this.start, this.originalStartingLine, this.revId, this.length);
    }
}

