/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.AppConfig;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.cache.BaseDirInfoCache;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.crossrepo.BranchIndexer;
import com.cenqua.fisheye.crossrepo.PathIndexer;
import com.cenqua.fisheye.csindex.ChangesetIndexer;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.rep.BaseRepositoryEngine;
import com.cenqua.fisheye.rep.CommonProperties;
import com.cenqua.fisheye.rep.CommonRepositoryScanner;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.DiffTextCache;
import com.cenqua.fisheye.rep.IndexingFeatures;
import com.cenqua.fisheye.rep.LogicalPathMatcher;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.rep.RepositoryIndexer;
import com.cenqua.fisheye.rep.StopRequestedException;
import com.cenqua.fisheye.rep.impl.CommonIndexer;
import java.util.concurrent.CancellationException;

public abstract class BaseRepositoryScanner<C extends BaseDirInfoCache>
extends CommonRepositoryScanner<C> {
    private final ChangesetIndexer csIndexer = new ChangesetIndexer();
    private final CommonIndexer indexer;
    private final LogicalPathMatcher logicalPathMatcher;
    private final RepositoryEngine engine;
    private boolean licenseLimitReached;
    private RepositoryIndexer repositoryIndexer;
    private IndexingFeatures features;
    private DiffTextCache diffTextCache;
    private boolean crucibleOnly;

    protected BaseRepositoryScanner(BaseRepositoryEngine<? extends BaseRepositoryScanner<C>, C> engine) {
        super(engine.getCfg(), engine.getIndexingContext(), null);
        this.engine = engine;
        this.indexer = engine.getIndexer();
        this.logicalPathMatcher = engine.getPathMatcher();
        this.licenseLimitReached = false;
        this.repositoryIndexer = null;
        this.diffTextCache = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void ping() throws DbException, ConfigException {
        try {
            if (this.getCache() == null) {
                throw new IllegalStateException("Scanner's cache has not been initialized");
            }
            this.status.setMessage("Contacting repository.");
            if (!this.status.isInitialIndexingComplete() && !this.status.isActive()) {
                Logs.APP_LOG.info((Object)("[" + this.getRepoName() + "] starting initial scan of repository "));
            }
            boolean updateOccurred = this.updateLocalRepoClone();
            Logs.APP_LOG.info((Object)("processing " + this.getRepoName()));
            long t0 = System.currentTimeMillis();
            this.doSlurpTransaction(updateOccurred);
            long t1 = System.currentTimeMillis();
            Logs.APP_LOG.info((Object)("done slurp for /" + this.getRepoName() + " time = " + (t1 - t0) + "ms"));
        }
        finally {
            this.status.setMessage("");
        }
    }

    protected abstract void doSlurpTransaction(boolean var1) throws ConfigException;

    protected boolean setLicensePolicyReached(LicensePolicyException e2) {
        boolean limitBreached = false;
        if (!this.licenseLimitReached) {
            Logs.APP_LOG.warn((Object)"License limit reached", (Throwable)e2);
            limitBreached = true;
        }
        this.licenseLimitReached = true;
        return limitBreached;
    }

    protected void clearLicensePolicyReached() {
        this.licenseLimitReached = false;
    }

    @Override
    public boolean isLicenseLimitReached() {
        return this.licenseLimitReached;
    }

    protected ChangesetIndexer getChangesetIndexer() {
        return this.csIndexer;
    }

    protected LogicalPathMatcher getPathMatcher() {
        return this.logicalPathMatcher;
    }

    protected DiffTextCache getDiffTextCache() {
        return this.diffTextCache;
    }

    protected RepositoryIndexer getRepositoryIndexer() {
        return this.repositoryIndexer;
    }

    protected CommonIndexer getIndexer() {
        return this.indexer;
    }

    public RepositoryConfig getRepositoryConfig() {
        return this.repositoryConfig;
    }

    public IndexingFeatures getFeatures() {
        return this.features;
    }

    private void determineIndexingFeatures() throws DbException, ConfigException {
        IndexingFeatures features = ((BaseDirInfoCache)this.cache).loadIndexingFeatures();
        if (features == null) {
            if (((BaseDirInfoCache)this.cache).isInitialIndexingComplete()) {
                Logs.APP_LOG.debug((Object)("Repository " + this.getRepoName() + " does not have an indexing configuration but has been indexed"));
            }
            features = this.createIndexingFeatures();
            ((BaseDirInfoCache)this.cache).storeIndexingFeatures(features);
            ((BaseDirInfoCache)this.cache).commit();
        } else {
            if (features.isStoreDiffs() && !this.repositoryConfig.isStoreDiffs()) {
                features.setStoreDiffs(false);
                ((BaseDirInfoCache)this.cache).storeIndexingFeatures(features);
                ((BaseDirInfoCache)this.cache).commit();
            }
            if (!((BaseDirInfoCache)this.cache).hasScanProperty(CommonProperties.LOC_ENABLED.value)) {
                features.setLocEnabled(this.repositoryConfig.isLocEnabled());
                ((BaseDirInfoCache)this.cache).storeIndexingFeatures(features);
                ((BaseDirInfoCache)this.cache).commit();
            }
            if (features.isLocEnabled() && !this.repositoryConfig.isLocEnabled()) {
                features.setLocEnabled(false);
                ((BaseDirInfoCache)this.cache).storeIndexingFeatures(features);
                ((BaseDirInfoCache)this.cache).commit();
            }
            this.validateIndexingFeatures(features);
        }
        features.setLocEnabled(!this.crucibleOnly && this.repositoryConfig.isLocEnabled());
        this.features = features;
    }

    private void validateIndexingFeatures(IndexingFeatures features) throws ConfigException {
        IndexingFeatures desiredFeatures = this.createIndexingFeatures();
        if (!desiredFeatures.equals(features)) {
            if (this.crucibleOnly) {
                throw new ConfigException("Current repository index for \"" + this.getRepoName() + "\" is not compatible with your license, please re-index");
            }
            Logs.APP_LOG.warn((Object)("The repository index for \"" + this.getRepoName() + "\" does not match the repository configuration - using configuration from current index"));
        }
    }

    private IndexingFeatures createIndexingFeatures() {
        IndexingFeatures features = new IndexingFeatures();
        this.initIndexingFeatures(features);
        if (this.crucibleOnly) {
            features.setStoreDiffs(false);
        }
        return features;
    }

    private void initIndexingFeatures(IndexingFeatures features) {
        features.setStoreDiffs(this.repositoryConfig.isStoreDiffs());
        features.setLocEnabled(this.repositoryConfig.isLocEnabled());
    }

    protected void createParentDir(Path dir) throws DbException {
        if (!((BaseDirInfoCache)this.cache).existsDir(dir)) {
            if (!dir.isRoot()) {
                this.createParentDir(dir.getParent());
            }
            ((BaseDirInfoCache)this.cache).createDir(dir);
        }
    }

    public void start(C newCache) throws DbException, ConfigException {
        AppConfig.getTempDir().mkdirs();
        this.cache = newCache;
        this.repositoryIndexer = new RepositoryIndexer(this.indexer, ((BaseDirInfoCache)this.cache).getLuceneConnection(), this.getRepositoryConfig());
        this.determineIndexingFeatures();
        ((BaseDirInfoCache)this.cache).setFeatures(this.features);
        this.diffTextCache = new DiffTextCache(this.repositoryConfig.getName(), this.features.isStoreDiffs());
    }

    protected void handleSlurpException(Exception e2) throws ConfigException {
        Logs.APP_LOG.warn((Object)("Problem processing revisions from repo " + this.getRepoName() + " due to " + e2.getClass() + " - " + e2.getMessage()), (Throwable)e2);
        this.engine.startPause(e2);
        if (e2 instanceof ConfigException) {
            throw (ConfigException)e2;
        }
    }

    protected void updatePauseStatus() {
        long remaining;
        if (this.status.isPaused() && (remaining = this.status.getPauseEndTime() - System.currentTimeMillis()) <= 0L) {
            this.engine.finishPause();
        }
    }

    public void setCrucibleOnly(boolean crucibleOnly) {
        this.crucibleOnly = crucibleOnly;
    }

    protected abstract void validateRepository() throws ConfigException;

    protected abstract boolean updateLocalRepoClone() throws ConfigException;

    public abstract void stop();

    public abstract String updateRevisions(String var1, String var2) throws RepositoryClientException, DbException, LicensePolicyException;

    protected void notifyUpdate() {
        if (((BaseDirInfoCache)this.getCache()).getEventMulticaster() != null) {
            ((BaseDirInfoCache)this.getCache()).getEventMulticaster().cacheUpdated();
        }
    }

    public boolean isUserInitiatedException(Exception e2) {
        Throwable cause = e2;
        do {
            if (!(cause instanceof StopRequestedException) && !(cause instanceof CancellationException)) continue;
            return true;
        } while ((cause = cause.getCause()) != null);
        return false;
    }

    protected PathIndexer getPathCrossRepoIndexer() {
        return this.indexingContext.getPathCrossRepoIndexer();
    }

    protected BranchIndexer getBranchCrossRepoIndexer() {
        return this.indexingContext.getBranchCrossRepoIndexer();
    }

    protected RepositoryEngine getEngine() {
        return this.engine;
    }
}

