/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.atlassian.fecru.upgrade.UpgradeManager;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.cache.BaseDirInfoCache;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.rep.BaseRepositoryScanner;
import com.cenqua.fisheye.rep.CommonRepositoryScanner;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import java.io.IOException;

public abstract class BaseRepositoryEngine<S extends BaseRepositoryScanner<C>, C extends BaseDirInfoCache>
extends RepositoryEngine {
    private S scanner = null;
    private C cache = null;

    protected BaseRepositoryEngine(RepositoryConfig config, UpgradeManager upgradeManager, IndexingContext indexingContext) {
        super(config, upgradeManager, indexingContext);
    }

    @Override
    public void init() throws DbException, ConfigException {
        this.scanner = this.createScanner();
        ((BaseRepositoryScanner)this.scanner).setCrucibleOnly(this.getIndexingContext().isCrucibleOnly());
    }

    @Override
    public boolean isLicenseLimitReached() {
        return ((BaseRepositoryScanner)this.scanner).isLicenseLimitReached();
    }

    @Override
    protected void doStart(long cacheSerial) throws IOException, DbException, ConfigException {
        if (this.scanner == null) {
            throw new IllegalStateException("No scanner has been configured for repository " + this.getName());
        }
        this.ensureCorrectScmVersion();
        this.cache = this.createCache(cacheSerial);
        try {
            this.getLicenseEnforcer().validateCommitterLimit(null, this.getDatabaseHandle());
        }
        catch (LicensePolicyException e2) {
            throw new ConfigException("Current repository index is not compatible with your license, please re-index", e2);
        }
        ((BaseRepositoryScanner)this.scanner).start(this.cache);
    }

    public RevisionCache getRevisionCache() {
        return this.cache;
    }

    public C getInternalRevisionCache() {
        return this.cache;
    }

    public S getScanner() {
        return this.scanner;
    }

    @Override
    public void doSlurp() throws DbException, ConfigException {
        ((BaseRepositoryScanner)this.scanner).ping();
    }

    @Override
    public void requestStop() {
        ((BaseRepositoryScanner)this.scanner).stop();
    }

    @Override
    public String rescan(String start, String end) throws RepositoryClientException, DbException, LicensePolicyException {
        return ((BaseRepositoryScanner)this.scanner).updateRevisions(start, end);
    }

    protected abstract void ensureCorrectScmVersion() throws ConfigException;

    protected abstract S createScanner() throws DbException, ConfigException;

    protected abstract C createCache(long var1);

    @Override
    protected void resetScmMetaData() {
        ((CommonRepositoryScanner)this.scanner).resetScmMetaData();
    }
}

