/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.rep;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.y;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;

public class AncestorLink {
    private final IntList revids = new IntArrayList();
    private final Type type;

    public AncestorLink(Type type, int ... revids) {
        if (revids.length == 0) {
            throw new IllegalArgumentException("At least 1 parent revid must be provided");
        }
        for (int revid : revids) {
            this.addRevid(revid);
        }
        this.type = type;
    }

    private void addRevid(int revid) {
        if (revid == -1) {
            Logs.APP_LOG.warn((Object)"Setting ancestor with invalid revid (-1)", (Throwable)new Exception());
        } else {
            this.revids.add(revid);
        }
    }

    public AncestorLink(Type type, Iterable<Integer> revids) {
        if (revids == null || Iterables.isEmpty(revids)) {
            throw new IllegalArgumentException("At least 1 parent revid must be provided");
        }
        for (Integer revid : revids) {
            if (revid == null) continue;
            this.addRevid(revid);
        }
        this.type = type;
    }

    public IntList getRevids() {
        return this.revids;
    }

    public Type getType() {
        return this.type;
    }

    public boolean isDirect() {
        return Type.DIRECT.equals((Object)this.type);
    }

    public boolean isBranchPoint() {
        return Type.BRANCHPOINT.equals((Object)this.type);
    }

    public boolean isCopy() {
        return Type.COPY.equals((Object)this.type);
    }

    public boolean isMove() {
        return Type.MOVE.equals((Object)this.type);
    }

    public boolean isMerge() {
        return this.revids.size() > 1;
    }

    public static AncestorLink fromCu(ac db, y cu, int pl) throws IOException {
        IntArrayList revids = new IntArrayList();
        int type = -1;
        do {
            revids.add((int)cu.v(pl));
            if (type != -1) continue;
            type = (int)cu.v(cu.w(pl));
        } while (db.a(cu, pl));
        return new AncestorLink(Type.fromValue(type), (Iterable<Integer>)revids);
    }

    public String toString() {
        return "AncestorLink[" + this.revids + "," + (Object)((Object)this.type) + "]";
    }

    public static enum Type {
        DIRECT(0),
        BRANCHPOINT(1),
        COPY(2),
        MOVE(3);

        private int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type fromValue(int value) {
            for (Type type : Type.values()) {
                if (type.getValue() != value) continue;
                return type;
            }
            throw new IllegalArgumentException("Unknown AncestorLink.Type for value " + value);
        }
    }
}

