/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce.search;

import com.cenqua.fisheye.infinitydb.query3.RegexQuery3;
import com.cenqua.fisheye.infinitydb.query3.TermQuery3;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.perforce.P4Cache;
import com.cenqua.fisheye.perforce.db.P4Schema;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RepositoryEngine;
import com.cenqua.fisheye.search.QueryBuilder;
import com.cenqua.fisheye.search.query.P4FixesClause;
import com.cenqua.fisheye.search.query.P4FixesRegexClause;
import java.io.IOException;
import java.util.regex.Pattern;

public class P4QueryBuilder
extends QueryBuilder {
    private final P4Cache cache;

    public P4QueryBuilder(RepositoryEngine repoEngine) {
        super(repoEngine);
        this.cache = (P4Cache)repoEngine.getRevisionCache();
    }

    @Override
    public void visitP4FixesClause(P4FixesClause p4FixesClause) throws IOException {
        try {
            long jobId = this.cache.getJobId(p4FixesClause.getJobId());
            TermQuery3 t2 = new TermQuery3(P4Schema.I_JOBID_TO_REVID, jobId, null);
            this.setQuery(t2);
        }
        catch (DbException e2) {
            Logs.APP_LOG.error((Object)("Unable to lookup job id for fixes clause: " + p4FixesClause));
        }
    }

    @Override
    public void visitP4FixesRegexClause(P4FixesRegexClause p4FixesRegexClause) {
        Pattern match = p4FixesRegexClause.getMatch();
        this.setQuery(new RegexQuery3(P4Schema.E_NAMES, P4Schema.I_JOBID_TO_REVID, match));
    }
}

