/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce.db;

import com.atlassian.fisheye.db.BaseFileRevisionDAO;
import com.cenqua.fisheye.LicenseEnforcer;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.infinitydb.InfinityDbHandle;
import com.cenqua.fisheye.infinitydb.UniqueStringTable;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.perforce.P4BranchMapping;
import com.cenqua.fisheye.perforce.P4BranchSpec;
import com.cenqua.fisheye.perforce.client.P4Job;
import com.cenqua.fisheye.perforce.db.P4RevInfo;
import com.cenqua.fisheye.perforce.db.P4Schema;
import com.cenqua.fisheye.perforce.db.P4StringTables;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.impl.CommonDirInfoDAO;
import com.cenqua.fisheye.rep.impl.LineCountState;
import com.cenqua.fisheye.rep.impl.NumberBasedRevisionUtil;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import com.cenqua.obfuscate.idb.I;
import com.cenqua.obfuscate.idb.ac;
import com.cenqua.obfuscate.idb.y;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class P4RevInfoDAO
extends BaseFileRevisionDAO<P4RevInfo, P4StringTables> {
    private final CommonDirInfoDAO dirDAO;

    public P4RevInfoDAO(InfinityDbHandle dbh, P4StringTables stringTables, boolean caseSensitive, String repositoryName, LicenseEnforcer licenseEnforcer) {
        super(repositoryName, dbh, stringTables, false, caseSensitive, licenseEnforcer);
        this.dirDAO = new CommonDirInfoDAO(dbh, stringTables, caseSensitive);
    }

    @Override
    public int insertNew(P4RevInfo revInfo, AncestorLink ancestorLink, boolean storeDiffs) throws DbException, LicensePolicyException {
        int revid = this.commonDAO.insertNew(revInfo, ancestorLink, storeDiffs, this.isStoreSuffixPaths());
        long pathId = this.commonDAO.getPathId(revInfo.getPath());
        Logs.APP_LOG.debug((Object)("Path id for path " + revInfo.getPath() + " and revid = " + revid + " returned as " + pathId));
        this.commonDAO.addRevidLongIndex(P4Schema.I_CHANGESETID_REVID, revInfo.getP4ChangeSetId(), revid);
        this.commonDAO.addPathLongProperty(P4Schema.I_PATHID_CHANGESETID, revInfo.getPath(), revInfo.getP4ChangeSetId());
        this.commonDAO.addRevIdLongProperty(P4Schema.I_REVID_TO_PATHID, revid, pathId);
        this.commonDAO.addRevIdLongProperty(P4Schema.A_FILESIZE, revid, revInfo.getFileSize());
        this.commonDAO.addRevIdLongProperty(P4Schema.A_FILEREV, revid, revInfo.getFileRev());
        this.commonDAO.addRevIdLongProperty(P4Schema.A_UNICODE, revid, revInfo.isUnicode() ? 1L : 0L);
        this.commonDAO.addRevIdLongProperty(P4Schema.A_PURGED, revid, revInfo.isPurged() ? 1L : 0L);
        long fileTypeId = ((P4StringTables)this.stringTables).p4NamesDB.add(revInfo.getP4FileType());
        this.commonDAO.addRevIdLongProperty(P4Schema.A_P4FILETYPE, revid, fileTypeId);
        this.storeFileRevisionInfo(revInfo, revid);
        this.addFixedJobs(revid, revInfo.getFixedJobs());
        return revid;
    }

    public long findJobId(String jobName) throws DbException {
        return ((P4StringTables)this.stringTables).p4NamesDB.find(jobName);
    }

    private void addFixedJobs(int revid, Collection<String> fixedJobs) throws DbException {
        y cu = y.a();
        try {
            ac db = this.dbh.get();
            for (String jobName : fixedJobs) {
                long jobId = this.createJobId(jobName);
                cu.f().a(P4Schema.I_REVID_TO_JOBID).b((long)revid).b(jobId);
                db.b(cu);
                cu.f().a(P4Schema.I_JOBID_TO_REVID).b(jobId).b((long)revid);
                db.b(cu);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateFixedJobs(int revid, Collection<String> jobs) throws DbException {
        Set<String> currentFixedJobs = this.getFixes(revid);
        HashSet<String> newFixedJobs = new HashSet<String>(jobs);
        newFixedJobs.removeAll(currentFixedJobs);
        currentFixedJobs.removeAll(jobs);
        this.removeFixedJobs(revid, currentFixedJobs);
        this.addFixedJobs(revid, newFixedJobs);
    }

    private void removeFixedJobs(int revid, Collection<String> jobs) throws DbException {
        y cu = y.a();
        ac db = this.dbh.get();
        try {
            for (String job : jobs) {
                long jobId = this.createJobId(job);
                cu.f().a(P4Schema.I_REVID_TO_JOBID).b((long)revid).b(jobId);
                db.c(cu);
                cu.f().a(P4Schema.I_JOBID_TO_REVID).b(jobId).b((long)revid);
                db.c(cu);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private long createJobId(String jobName) throws DbException {
        return ((P4StringTables)this.stringTables).p4NamesDB.add(jobName);
    }

    public Set<String> getFixes(int revid) throws DbException {
        try {
            ac db = this.dbh.get();
            HashSet<String> result = new HashSet<String>();
            y cu = y.a().a(P4Schema.I_REVID_TO_JOBID).b((long)revid);
            int keyLength = cu.e();
            while (db.a(cu, keyLength)) {
                long jobId = cu.v(keyLength);
                String jobName = ((P4StringTables)this.stringTables).p4NamesDB.get(jobId);
                result.add(jobName);
            }
            return result;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void storeFileRevisionInfo(P4RevInfo revInfo, int revid) throws DbException {
        try {
            ac db = this.dbh.get();
            long pathId = this.commonDAO.getPathId(revInfo.getPath());
            if (pathId == -1L) {
                throw new DbException("Unable to find path " + revInfo.getPath() + ", not in database");
            }
            y cu = y.a().a(P4Schema.I_PATHID_FILEREV_REVID);
            cu.b(pathId).b((long)revInfo.getFileRev()).b((long)revid);
            db.b(cu);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public int getRevIdByFileRev(Path path, int fileRev) throws DbException {
        try {
            ac db = this.dbh.get();
            y cu = y.a().a(P4Schema.I_PATHID_FILEREV_REVID);
            long pathId = this.commonDAO.getPathId(path);
            int revid = -1;
            if (pathId != -1L) {
                cu.b(pathId).b((long)fileRev);
                int keyLength = cu.e();
                if (db.a(cu, keyLength)) {
                    revid = (int)cu.v(keyLength);
                }
            }
            return revid;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public SortedIntSet getRevidsInChangeSetRange(long fromCSID, long toCSID) throws DbException {
        return this.commonDAO.getRevidsInLongIndexRange(P4Schema.I_CHANGESETID_REVID, fromCSID, toCSID);
    }

    @Override
    public P4RevInfo load(int revId) throws DbException {
        P4RevInfo revInfo = null;
        if (this.commonDAO.exists(revId)) {
            try {
                String fileType;
                revInfo = new P4RevInfo();
                this.commonDAO.load(revId, revInfo);
                revInfo.setFileSize(this.commonDAO.getLongProperty(P4Schema.A_FILESIZE, revId, 0L));
                revInfo.setFileRev((int)this.commonDAO.getLongProperty(P4Schema.A_FILEREV, revId, 0L));
                revInfo.setUnicode(this.commonDAO.getLongProperty(P4Schema.A_UNICODE, revId, 0L) == 1L);
                revInfo.setPurged(this.commonDAO.getLongProperty(P4Schema.A_PURGED, revId, 0L) == 1L);
                long fileTypeId = this.commonDAO.getLongProperty(P4Schema.A_P4FILETYPE, revId, -1L);
                if (fileTypeId != -1L && (fileType = ((P4StringTables)this.stringTables).p4NamesDB.get(fileTypeId)) != null) {
                    revInfo.setP4FileType(fileType);
                }
                revInfo.setFixedJobs(this.getFixes(revId));
            }
            catch (DbException e2) {
                Logs.APP_LOG.warn((Object)"Exception", (Throwable)e2);
                revInfo = null;
            }
        }
        return revInfo;
    }

    public SortedMap<Long, Integer> getPathRevisions(Path path) throws DbException {
        Map<String, Integer> revMap = this.commonDAO.getPathRevisions(path);
        TreeMap<Long, Integer> result = new TreeMap<Long, Integer>();
        for (Map.Entry<String, Integer> entry : revMap.entrySet()) {
            result.put(Long.valueOf(entry.getKey()), entry.getValue());
        }
        return result;
    }

    public long getLatestPathChange(Path path) throws DbException {
        return this.commonDAO.getPathLargestProperty(P4Schema.I_PATHID_CHANGESETID, path, -1L, -1L);
    }

    public int getLatestPathRevid(Path path) throws DbException {
        long latestPathChangeRev = this.getLatestPathChange(path);
        int revid = -1;
        if (latestPathChangeRev != -1L) {
            revid = this.getRevId(path, latestPathChangeRev);
        }
        return revid;
    }

    public int getRevId(Path path, long p4id) throws DbException {
        int revid = -1;
        long pathId = this.commonDAO.getPathId(path);
        if (pathId != -1L) {
            revid = this.commonDAO.getRevId(pathId, Long.toString(p4id));
        }
        return revid;
    }

    public SortedIntSet getPaths(SortedIntSet revids) throws DbException {
        return this.commonDAO.getLongProperySet(P4Schema.I_REVID_TO_PATHID, revids);
    }

    public long getTagUpdateTime(String tag) throws DbException {
        try {
            ac db = this.dbh.get();
            long tagid = ((P4StringTables)this.stringTables).tagDB.find(tag);
            if (tagid == -1L) {
                return -1L;
            }
            y cu = y.a().a(P4Schema.E_TAG_TIME);
            cu.b(tagid);
            int pl = cu.e();
            long updateTime = -1L;
            if (db.a(cu, pl)) {
                updateTime = cu.v(pl);
            }
            return updateTime;
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void setTagUpdateTime(String tag, long updateTime) throws DbException {
        try {
            ac db = this.dbh.get();
            long tagid = ((P4StringTables)this.stringTables).tagDB.add(tag);
            y cu = y.a().a(P4Schema.E_TAG_TIME);
            cu.b(tagid);
            int pl = cu.e();
            cu.b(updateTime);
            db.e(cu, pl);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void updateLineCount(RevInfoKey key, int lineCount, int linesAdded, int linesRemoved) throws DbException {
        this.commonDAO.updateLineCount(key, lineCount, linesAdded, linesRemoved, LineCountState.FULL);
    }

    public void updateJob(P4Job job) throws DbException {
        Logs.APP_LOG.debug((Object)("Updating Job " + job.getName()));
        try {
            ac db = this.dbh.get();
            long jobId = this.createJobId(job.getName());
            y cu = y.a().a(P4Schema.E_JOBS);
            cu.b(jobId);
            int pk = cu.e();
            String description = job.getDescription();
            if (description == null) {
                description = "";
            }
            long descriptionId = ((P4StringTables)this.stringTables).p4JobStringsDB.add(description);
            cu.b(descriptionId);
            db.e(cu, pk);
            this.removeJobFields(db, cu, jobId);
            this.addJobFields(db, cu, jobId, job.getFields());
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public P4Job loadJob(String jobName) throws DbException {
        long jobId = this.findJobId(jobName);
        if (jobId == -1L) {
            return null;
        }
        P4Job job = null;
        try {
            ac db = this.dbh.get();
            y cu = y.a().a(P4Schema.E_JOBS);
            cu.b(jobId);
            int pk = cu.e();
            if (db.a(cu, pk)) {
                String description = this.getP4JobStringAt(cu, pk);
                Map<String, String> fields = this.loadJobFields(db, cu, jobId);
                job = new P4Job(jobName, description, fields);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        return job;
    }

    private String getP4JobStringAt(y cu, int pk) throws DbException {
        String result;
        if (cu.f(pk) == 7) {
            long stringId = cu.v(pk);
            result = ((P4StringTables)this.stringTables).p4JobStringsDB.get(stringId);
        } else {
            result = cu.m(pk);
        }
        return result;
    }

    private Map<String, String> loadJobFields(ac db, y cu, long jobId) throws DbException {
        HashMap<String, String> fields = new HashMap<String, String>();
        try {
            cu.f().b(jobId);
            int pk = cu.e();
            while (db.a(cu, pk)) {
                long fieldNameId = cu.v(pk);
                int offset = cu.w(pk);
                String fieldValue = this.getP4JobStringAt(cu, offset);
                String fieldName = ((P4StringTables)this.stringTables).p4NamesDB.get(fieldNameId);
                if (fieldName == null) continue;
                fields.put(fieldName, fieldValue);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
        return fields;
    }

    private void addJobFields(ac db, y cu, long jobId, Map<String, String> fields) throws DbException {
        try {
            cu.f().b(jobId);
            int pk = cu.e();
            for (Map.Entry<String, String> entry : fields.entrySet()) {
                long fieldId = ((P4StringTables)this.stringTables).p4NamesDB.add(entry.getKey());
                String value = entry.getValue();
                if (value != null) {
                    long valueId = ((P4StringTables)this.stringTables).p4JobStringsDB.add(value);
                    cu.b(fieldId).b(valueId);
                    db.b(cu);
                }
                cu.d(pk);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void removeJobFields(ac db, y cu, long jobId) throws DbException {
        try {
            cu.f().b(jobId);
            int pk = cu.e();
            while (db.a(cu, pk)) {
                db.c(cu);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void addHunk(RevInfoKey key, Hunk hunk) throws DbException {
        int revid = this.commonDAO.getRevId(key);
        ArrayList<Hunk> hunkList = new ArrayList<Hunk>();
        hunkList.add(hunk);
        this.commonDAO.setHunks(revid, hunkList);
    }

    private void loadBranchTimes(Map<String, Long> branchTimes) throws DbException {
        try {
            ac db = this.dbh.get();
            y cu = y.a().a(P4Schema.E_BRANCH_TIMES);
            int pk = cu.e();
            while (db.a(cu, pk)) {
                long branchNameId = cu.v(pk);
                int offset = cu.w(pk);
                long updateTime = cu.v(offset);
                String branchName = ((P4StringTables)this.stringTables).p4BranchNames.get(branchNameId);
                branchTimes.put(branchName, updateTime);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void loadBranches(Map<String, Long> branchTimes, List<P4BranchSpec> branchSpecs) {
        this.loadBranchTimes(branchTimes);
        try {
            branchSpecs.clear();
            ac db = this.dbh.get();
            y cu = y.a().a(P4Schema.E_BRANCH_SPECS);
            int pk = cu.e();
            long currentBranchNameId = -1L;
            P4BranchSpec spec = null;
            while (db.a(cu, pk)) {
                long branchNameId = cu.v(pk);
                if (branchNameId != currentBranchNameId) {
                    String branchName = ((P4StringTables)this.stringTables).p4BranchNames.get(branchNameId);
                    currentBranchNameId = branchNameId;
                    spec = new P4BranchSpec(branchName);
                    branchSpecs.add(spec);
                }
                int offset = cu.w(pk);
                boolean negative = cu.s(offset);
                offset = cu.t(offset);
                long fromId = cu.v(offset);
                offset = cu.w(offset);
                long toId = cu.v(offset);
                offset = cu.w(offset);
                P4BranchMapping mapping = new P4BranchMapping(negative, ((P4StringTables)this.stringTables).pathDB.get(fromId), ((P4StringTables)this.stringTables).pathDB.get(toId));
                spec.addMapping(mapping);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public void storeBranch(P4BranchSpec branchSpec, long branchTime) {
        this.updateBranchTime(branchSpec.getName(), branchTime);
        try {
            ac db = this.dbh.get();
            y cu = y.a().a(P4Schema.E_BRANCH_SPECS);
            long branchNameId = ((P4StringTables)this.stringTables).p4BranchNames.add(branchSpec.getName());
            cu.b(branchNameId);
            int pk = cu.e();
            while (db.a(cu, pk)) {
                db.c(cu);
            }
            for (P4BranchMapping p4BranchMapping : branchSpec.getMappings()) {
                long fromId = ((P4StringTables)this.stringTables).pathDB.add(p4BranchMapping.getFrom());
                long toId = ((P4StringTables)this.stringTables).pathDB.add(p4BranchMapping.getTo());
                cu.f().a(P4Schema.E_BRANCH_SPECS).b(branchNameId).a(p4BranchMapping.isNegative()).b(fromId).b(toId);
                db.b(cu);
            }
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    private void updateBranchTime(String branchName, Long newTime) throws DbException {
        try {
            ac db = this.dbh.get();
            y cu = y.a().a(P4Schema.E_BRANCH_TIMES);
            long branchNameId = ((P4StringTables)this.stringTables).p4BranchNames.add(branchName);
            cu.b(branchNameId);
            int pk = cu.e();
            cu.b(newTime);
            db.e(cu, pk);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    public LongLinkedOpenHashSet getChangeSets(long start, long end) throws DbException {
        return this.commonDAO.getLongIndexKeyRange(P4Schema.I_CHANGESETID_REVID, start, end);
    }

    public long getLatestPathChangeUpto(Path physicalPath, long limitRevision) throws DbException {
        try {
            return this.getLatestPathUpTo(((P4StringTables)this.stringTables).pathDB, P4Schema.I_PATHID_CHANGESETID, physicalPath, limitRevision);
        }
        catch (IOException e2) {
            throw new DbException(e2);
        }
    }

    @Override
    public boolean isStoreSuffixPaths() {
        return true;
    }

    private long getLatestPathUpTo(UniqueStringTable pathTable, I pathIndexTable, Path path, long limitRevision) throws IOException, DbException {
        return NumberBasedRevisionUtil.getLatestCsIdOnPathUpTo(this.dbh.get(), pathTable, pathIndexTable, path, limitRevision);
    }
}

