/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce.client;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.perforce.client.P4CliUtils;
import com.cenqua.fisheye.perforce.client.P4ClientException;
import com.cenqua.fisheye.perforce.client.P4OutputLineProcessor;
import com.cenqua.fisheye.perforce.client.P4ZTagProcessor;
import java.text.ParsePosition;
import java.util.HashMap;
import java.util.Map;

public class P4ZTagExtractor
extends P4OutputLineProcessor {
    private static final int MAX_FIELD_SIZE = 50000;
    private Map<String, String> currentGroup = null;
    private String currentKey = null;
    private StringBuilder otherOutput = new StringBuilder();
    private P4ZTagProcessor processor;
    private String keyTag;

    public P4ZTagExtractor(String keyTag, P4ZTagProcessor processor) {
        this.keyTag = keyTag;
        this.processor = processor;
    }

    @Override
    public void processLine(String ztagLine, int count) throws P4ClientException {
        if (ztagLine.trim().length() == 0) {
            return;
        }
        if (this.keyTag == null && this.currentGroup == null) {
            this.currentGroup = new HashMap<String, String>();
        }
        if (ztagLine.startsWith("... ")) {
            String line = ztagLine.substring(4);
            ParsePosition pos = new ParsePosition(0);
            this.currentKey = P4CliUtils.getWord(line, pos);
            if (pos.getIndex() < line.length()) {
                String value = line.substring(pos.getIndex() + 1);
                if (this.keyTag != null && this.currentKey.equals(this.keyTag)) {
                    if (this.currentGroup != null) {
                        this.processor.processGroup(this.currentGroup);
                    }
                    this.currentGroup = new HashMap<String, String>();
                }
                if (this.currentGroup != null) {
                    this.currentGroup.put(this.currentKey, value);
                }
            }
        } else if (this.currentKey != null && this.currentGroup != null) {
            String currentValue = this.currentGroup.get(this.currentKey);
            if (currentValue == null) {
                currentValue = "";
            }
            if (currentValue.length() < 50000) {
                if ((currentValue = currentValue + "\n" + ztagLine).length() > 50000) {
                    currentValue = currentValue.substring(0, 50000);
                }
                this.currentGroup.put(this.currentKey, currentValue);
            }
        } else {
            this.otherOutput.append(ztagLine).append('\n');
        }
    }

    @Override
    public void complete() throws P4ClientException {
        if (this.currentGroup != null) {
            if (!this.currentGroup.isEmpty()) {
                this.processor.processGroup(this.currentGroup);
            } else {
                Logs.APP_LOG.debug((Object)("No group info found - additional output: " + this.otherOutput.toString()));
                throw new P4ClientException("Problems processing output, output detected was: " + this.otherOutput.toString());
            }
        }
        this.currentGroup = null;
    }
}

