/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce.client;

import com.cenqua.fisheye.perforce.client.P4FieldProcessor;
import com.cenqua.fisheye.perforce.client.P4OutputLineProcessor;

public class P4LineToFieldProcessor
extends P4OutputLineProcessor {
    private String fieldName;
    private String fieldValue;
    private final boolean streamFieldLines;
    private final P4FieldProcessor processor;

    public P4LineToFieldProcessor(boolean streamFieldLines, P4FieldProcessor processor) {
        this.streamFieldLines = streamFieldLines;
        this.processor = processor;
    }

    @Override
    public void processLine(String line, int count) {
        if (line.startsWith("#")) {
            return;
        }
        if (line.startsWith("\t") && this.fieldName != null) {
            if (this.streamFieldLines) {
                this.processField();
                this.fieldValue = line.substring(1);
            } else if (this.fieldValue != null) {
                this.fieldValue = this.fieldValue + "\n";
                this.fieldValue = this.fieldValue + line.substring(1);
            } else {
                this.fieldValue = line.substring(1);
            }
        } else if (line.trim().length() != 0) {
            this.processField();
            int colonIndex = line.indexOf(58);
            if (colonIndex != -1) {
                this.fieldName = line.substring(0, colonIndex);
                this.fieldValue = line.length() >= colonIndex + 2 ? line.substring(colonIndex + 2) : null;
            }
        }
    }

    @Override
    public void complete() {
        this.processField();
    }

    private void processField() {
        if (this.fieldName != null && this.fieldValue != null) {
            this.processor.processField(this.fieldName, this.fieldValue);
        }
        this.fieldValue = null;
    }
}

