/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce.client;

import com.atlassian.utils.process.Watchdog;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.perforce.client.P4ClientException;
import com.cenqua.fisheye.perforce.client.P4FileSpec;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParsePosition;

public class P4InputDemuxer {
    private InputStream input;
    private Object2LongMap<P4FileSpec> files;
    private Callback callback;
    private static final int MAX_LINE = 8192;
    private byte[] buffer = new byte[8192];
    private Watchdog watchdog;
    private int bufferFill;
    private int bufferOffset;
    private long currentFileSize;
    private long currentFileRead;
    private StringBuilder lastPartialLine = new StringBuilder();

    public P4InputDemuxer(Watchdog watchdog, InputStream input, Object2LongMap<P4FileSpec> files, Callback callback) throws P4ClientException {
        this.watchdog = watchdog;
        this.files = files;
        this.callback = callback;
        this.input = input;
    }

    private int fillBuffer() throws IOException {
        if (this.bufferOffset != this.bufferFill) {
            System.arraycopy(this.buffer, this.bufferOffset, this.buffer, 0, this.bufferFill - this.bufferOffset);
        }
        this.bufferFill -= this.bufferOffset;
        this.bufferOffset = 0;
        int numRead = this.input.read(this.buffer, this.bufferFill, this.buffer.length - this.bufferFill);
        if (this.watchdog != null) {
            this.watchdog.resetWatchdog();
        }
        if (numRead != -1) {
            this.bufferFill += numRead;
        }
        this.bufferOffset = 0;
        return numRead;
    }

    private int getNextLineEndPos(int start) {
        for (int i2 = start; i2 < this.bufferFill; ++i2) {
            byte b2 = this.buffer[i2];
            if (b2 != 13 && b2 != 10) continue;
            return i2;
        }
        return -1;
    }

    private String readLine() throws IOException {
        if (this.isBufferEmpty() && this.fillBuffer() == -1) {
            return null;
        }
        StringBuilder line = new StringBuilder();
        int lineEnd = this.getNextLineEndPos(this.bufferOffset);
        while (lineEnd == -1) {
            line.append(new String(this.buffer, this.bufferOffset, this.bufferFill - this.bufferOffset));
            this.bufferOffset = this.bufferFill;
            if (this.fillBuffer() == -1) {
                this.bufferFill = 0;
                this.bufferOffset = 0;
                return line.toString();
            }
            if (line.length() > 8192) {
                line.delete(0, line.length() - 4096);
            }
            lineEnd = this.getNextLineEndPos(this.bufferOffset);
        }
        line.append(new String(this.buffer, this.bufferOffset, lineEnd - this.bufferOffset));
        this.bufferOffset = lineEnd != this.bufferFill - 2 && this.buffer[lineEnd] == 13 && this.buffer[lineEnd + 1] == 10 ? lineEnd + 2 : lineEnd + 1;
        return line.toString();
    }

    private boolean isBufferEmpty() {
        return this.bufferOffset >= this.bufferFill;
    }

    private void readFromBuffer(byte[] b2, int offset, int numRead) {
        System.arraycopy(this.buffer, this.bufferOffset, b2, offset, numRead);
        this.bufferOffset += numRead;
        this.currentFileRead += (long)numRead;
    }

    private InputStream createSubStream(P4FileSpec file) {
        this.currentFileRead = 0L;
        this.currentFileSize = this.files.getLong((Object)file);
        this.lastPartialLine.setLength(0);
        return new InputStream(){

            @Override
            public int read() throws IOException {
                byte[] b2 = new byte[1];
                int numRead = this.read(b2, 0, 1);
                if (numRead == -1) {
                    return -1;
                }
                return b2[0];
            }

            @Override
            public int read(byte[] b2, int off, int len) throws IOException {
                int toRead = len;
                int offset = off;
                int read = 0;
                while (!(toRead <= 0 || P4InputDemuxer.this.isBufferEmpty() && P4InputDemuxer.this.fillBuffer() == -1)) {
                    int numRead;
                    int remainingInBuffer = P4InputDemuxer.this.bufferFill - P4InputDemuxer.this.bufferOffset;
                    int remainingInFile = (int)(P4InputDemuxer.this.currentFileSize - P4InputDemuxer.this.currentFileRead);
                    if (P4InputDemuxer.this.currentFileSize != 0L && remainingInFile == 0) break;
                    if (remainingInFile > 0) {
                        numRead = remainingInFile >= remainingInBuffer ? remainingInBuffer : remainingInFile;
                    } else {
                        int eol = P4InputDemuxer.this.getNextLineEndPos(P4InputDemuxer.this.bufferOffset);
                        if (eol != -1) {
                            String line = new String(P4InputDemuxer.this.buffer, P4InputDemuxer.this.bufferOffset, eol - P4InputDemuxer.this.bufferOffset, "US-ASCII");
                            ParsePosition start = new ParsePosition(0);
                            ParsePosition end = new ParsePosition(line.length());
                            P4FileSpec followingSpec = P4FileSpec.match(line, start, end);
                            String followingString = line.substring(end.getIndex());
                            if (followingSpec != null && P4InputDemuxer.this.files.containsKey((Object)followingSpec) && followingString.startsWith(" - ")) {
                                numRead = start.getIndex();
                                if (numRead == 0) {
                                    break;
                                }
                            } else {
                                numRead = eol - P4InputDemuxer.this.bufferOffset + 1;
                            }
                        } else if (P4InputDemuxer.this.bufferOffset != 0) {
                            P4InputDemuxer.this.fillBuffer();
                            numRead = 0;
                        } else {
                            numRead = Math.min(4096, P4InputDemuxer.this.bufferFill);
                        }
                    }
                    if (numRead == 0) continue;
                    numRead = Math.min(toRead, numRead);
                    P4InputDemuxer.this.readFromBuffer(b2, offset, numRead);
                    toRead -= numRead;
                    offset += numRead;
                    read += numRead;
                }
                if (read == 0) {
                    return -1;
                }
                return read;
            }

            @Override
            public void close() throws IOException {
                int remainingInFile = (int)(P4InputDemuxer.this.currentFileSize - P4InputDemuxer.this.currentFileRead);
                while (remainingInFile > 0 && this.skip(remainingInFile) != 0L) {
                    remainingInFile = (int)(P4InputDemuxer.this.currentFileSize - P4InputDemuxer.this.currentFileRead);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process() throws IOException {
        block8: {
            try {
                P4FileSpec spec;
                String line = this.readLine();
                if (line == null) break block8;
                ParsePosition start = new ParsePosition(0);
                ParsePosition end = new ParsePosition(line.length());
                while ((spec = P4FileSpec.match(line, start, end)) != null) {
                    String followingString = line.substring(end.getIndex());
                    if (this.files.containsKey((Object)spec) && followingString.startsWith(" - ")) {
                        try (InputStream subStream = this.createSubStream(spec);){
                            this.callback.processFile(spec, subStream);
                        }
                    }
                    if ((line = this.readLine()) != null) {
                        start = new ParsePosition(0);
                        end = new ParsePosition(line.length());
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable) {
                IOHelper.close(this.input);
                throw throwable;
            }
        }
        IOHelper.close(this.input);
    }

    public static interface Callback {
        public void processFile(P4FileSpec var1, InputStream var2) throws IOException;
    }
}

