/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce.client;

import java.text.ParsePosition;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class P4FileSpec {
    private String path;
    private int startRev;
    private int endRev;
    private static final Pattern fileSpecPattern = Pattern.compile("(//[^#]*)#([0-9]+)(,([0-9]+)|)");

    public static P4FileSpec match(CharSequence data) {
        return P4FileSpec.match(data, new ParsePosition(0), new ParsePosition(data.length()));
    }

    public static P4FileSpec match(CharSequence data, ParsePosition position) {
        ParsePosition endPosition = new ParsePosition(data.length());
        P4FileSpec fileSpec = P4FileSpec.match(data, position, endPosition);
        position.setIndex(endPosition.getIndex());
        return fileSpec;
    }

    public static P4FileSpec match(CharSequence data, ParsePosition startPos, ParsePosition endPos) {
        P4FileSpec fileSpec = null;
        Matcher matcher = fileSpecPattern.matcher(data);
        matcher.region(startPos.getIndex(), endPos.getIndex());
        if (matcher.find()) {
            String path = matcher.group(1);
            String startRevStr = matcher.group(2);
            String endRevStr = matcher.group(4);
            try {
                fileSpec = new P4FileSpec(path, startRevStr, endRevStr);
                startPos.setIndex(matcher.start());
                endPos.setIndex(matcher.end());
            }
            catch (NumberFormatException e2) {
                fileSpec = null;
            }
        }
        return fileSpec;
    }

    public P4FileSpec(String path, String startStr, String endStr) {
        this.path = path;
        String startRevStr = startStr;
        String endRevStr = endStr;
        if (startRevStr.startsWith("#")) {
            startRevStr = startRevStr.substring(1);
        }
        if (endRevStr != null && endRevStr.startsWith("#")) {
            endRevStr = endRevStr.substring(1);
        }
        this.startRev = startRevStr.equals("none") ? -1 : Integer.parseInt(startRevStr);
        this.endRev = endRevStr != null ? Integer.parseInt(endRevStr) : this.startRev;
        if (this.startRev == -1) {
            this.startRev = this.endRev;
        }
    }

    public P4FileSpec(String path, int rev) {
        this(path, rev, rev);
    }

    public P4FileSpec(String path, int startRev, int endRev) {
        this.path = path;
        this.startRev = startRev;
        this.endRev = endRev;
    }

    public String getPath() {
        return this.path;
    }

    public int getFileRev() {
        return this.endRev;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.path);
        buffer.append('#').append(this.startRev);
        if (this.endRev != this.startRev) {
            buffer.append(",#").append(this.endRev);
        }
        return buffer.toString();
    }

    public int getStartRev() {
        return this.startRev;
    }

    public int getEndRev() {
        return this.endRev;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        P4FileSpec that = (P4FileSpec)o2;
        return this.endRev == that.endRev && this.startRev == that.startRev && (this.path == null ? that.path == null : this.path.equals(that.path));
    }

    public int hashCode() {
        int result = this.path != null ? this.path.hashCode() : 0;
        result = 31 * result + this.startRev;
        result = 31 * result + this.endRev;
        return result;
    }
}

