/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce.client;

import com.atlassian.utils.process.BaseOutputHandler;
import com.atlassian.utils.process.ExternalProcess;
import com.atlassian.utils.process.ExternalProcessBuilder;
import com.atlassian.utils.process.InputHandler;
import com.atlassian.utils.process.OutputHandler;
import com.atlassian.utils.process.PluggableProcessHandler;
import com.atlassian.utils.process.ProcessException;
import com.atlassian.utils.process.ProcessHandler;
import com.atlassian.utils.process.ProcessMonitor;
import com.atlassian.utils.process.StringInputHandler;
import com.atlassian.utils.process.StringOutputHandler;
import com.atlassian.utils.process.Watchdog;
import com.cenqua.fisheye.SafeExternalProcessBuilder;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.perforce.P4RepositoryInfo;
import com.cenqua.fisheye.perforce.client.P4CliUtils;
import com.cenqua.fisheye.perforce.client.P4ClientException;
import com.cenqua.fisheye.perforce.client.P4FieldProcessor;
import com.cenqua.fisheye.perforce.client.P4LineToFieldProcessor;
import com.cenqua.fisheye.perforce.client.P4OutputProcessor;
import com.cenqua.fisheye.perforce.client.P4Processor;
import com.cenqua.fisheye.perforce.client.P4Visitor;
import com.cenqua.fisheye.perforce.client.P4ZTagExtractor;
import com.cenqua.fisheye.perforce.client.P4ZTagProcessor;
import com.cenqua.fisheye.util.NamedProcessHandler;
import com.cenqua.fisheye.util.Throttle;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class P4Exec {
    private static final int DEFAULT_LOGIN_TIMEOUT = 30000;
    private static final int DEFAULT_EXEC_TIMEOUT = 600000;
    private static final int CANCEL_MILLIS = 10000;
    private static final String DEFAULT_P4_EXECUTABLE = "p4";
    private static String p4Executable = "p4";
    private List<String> commandRoot;
    private boolean requiresLogin;
    private final P4RepositoryInfo repoInfo;
    private final long loginCommandTimeout;
    private final long execCommandTimeout;
    private volatile Thread executingThread;
    private final LinkedList<ExternalProcess> processStack = new LinkedList();
    private final Object processLock = new Object();
    private final ProcessMonitor processMonitor;
    private final ProcessMonitor activityMonitor;
    private static final String[] P4_ENVIRONMENT_VARIABLES = new String[]{"P4CLIENT", "P4PORT", "P4PASSWD", "P4USER", "P4CONFIG", "P4DIFF", "P4EDITOR", "P4MERGE", "P4CHARSET", "P4PAGER", "PWD", "TMP", "TEMP", "P4TICKETS", "P4LANGUAGE", "P4COMMANDCHARSET", "P4DIFFUNICODE", "P4MERGEUNICODE", "P4AUDIT", "P4JOURNAL", "P4LOG", "P4PORT", "P4ROOT", "P4DEBUG", "P4NAME", "P4DESCRIPTION", "P4ZEROCONF"};

    public static void setP4Executable(String executable) {
        p4Executable = executable;
    }

    public static String getP4Executable() {
        return p4Executable;
    }

    public P4Exec(P4RepositoryInfo repoInfo, final Throttle throttle, ProcessMonitor activityMonitor) throws P4ClientException {
        this.repoInfo = repoInfo;
        if (repoInfo.getCommandTimeout() == -1L) {
            this.loginCommandTimeout = 30000L;
            this.execCommandTimeout = 600000L;
        } else {
            this.loginCommandTimeout = repoInfo.getCommandTimeout();
            this.execCommandTimeout = repoInfo.getCommandTimeout();
        }
        this.setup();
        this.activityMonitor = activityMonitor;
        this.processMonitor = new ProcessMonitor(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onBeforeStart(ExternalProcess process) {
                Thread thread = Thread.currentThread();
                Object object = P4Exec.this.processLock;
                synchronized (object) {
                    throttle.apply();
                    P4Exec.this.executingThread = thread;
                    P4Exec.this.processStack.push(process);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onAfterFinished(ExternalProcess externalProcess) {
                Object object = P4Exec.this.processLock;
                synchronized (object) {
                    P4Exec.this.processStack.pop();
                    P4Exec.this.executingThread = null;
                }
            }
        };
    }

    private void setup() throws P4ClientException {
        this.commandRoot = new ArrayList<String>();
        this.commandRoot.add(p4Executable);
        this.commandRoot.add("-p");
        this.commandRoot.add(this.repoInfo.getServer() + ":" + this.repoInfo.getPort());
        if (this.repoInfo.isUnicode()) {
            this.commandRoot.add("-C");
            this.commandRoot.add("utf8");
        }
        if (this.repoInfo.getUsername() != null) {
            this.commandRoot.add("-u");
            this.commandRoot.add(this.repoInfo.getUsername());
            if (this.repoInfo.getPassword() != null) {
                this.requiresLogin = true;
            }
        }
    }

    public String login() {
        String statusMessage = null;
        if (this.requiresLogin) {
            ArrayList<String> commandArgs = new ArrayList<String>(this.commandRoot);
            commandArgs.add("login");
            P4CliUtils.dumpCommandLine("[" + this.repoInfo.getRepositoryDescriptor() + "]", commandArgs);
            String[] args = commandArgs.toArray(new String[commandArgs.size()]);
            ExternalProcess process = this.createProcess(args, this.loginCommandTimeout);
            PluggableProcessHandler handler = (PluggableProcessHandler)process.getHandler();
            StringOutputHandler soh = new StringOutputHandler();
            handler.setOutputHandler((OutputHandler)soh);
            String password = this.repoInfo.getPassword();
            if (StringUtils.isEmpty((String)password)) {
                password = "\n";
            }
            handler.setInputHandler((InputHandler)new StringInputHandler(password));
            process.execute();
            statusMessage = P4Exec.getProcessStatusMessage(handler);
            if (statusMessage != null) {
                statusMessage = "Unable to login: " + statusMessage;
                P4Exec.testP4Env(this.repoInfo, false);
            }
        }
        return statusMessage;
    }

    private String executeStreamCommand(String[] cmdArray, String input, final P4Visitor.ProcessOutputVisitor visitor) {
        final ExternalProcess process = this.createProcess(cmdArray, this.execCommandTimeout);
        PluggableProcessHandler handler = (PluggableProcessHandler)process.getHandler();
        if (input != null) {
            handler.setInputHandler((InputHandler)new StringInputHandler(input));
        }
        handler.setOutputHandler((OutputHandler)new BaseOutputHandler(){

            public void process(InputStream inputStream) throws ProcessException {
                visitor.visit((Watchdog)process, inputStream, P4Exec.this.repoInfo.getEncoding());
            }
        });
        process.execute();
        return P4Exec.getProcessStatusMessage(handler);
    }

    private ExternalProcess createProcess(String[] command, long timeout) {
        NamedProcessHandler handler = new NamedProcessHandler(this.repoInfo.getName());
        ExternalProcessBuilder builder = new SafeExternalProcessBuilder().command(Arrays.asList(command)).handler((ProcessHandler)handler).timeout(timeout);
        builder.addMonitor(new ProcessMonitor[]{this.processMonitor});
        if (this.activityMonitor != null) {
            builder.addMonitor(new ProcessMonitor[]{this.activityMonitor});
        }
        handler.setErrorHandler((OutputHandler)new StringOutputHandler());
        return builder.build();
    }

    private String processCommand(String[] cmdArray, String input, P4OutputProcessor processor) throws P4ClientException {
        String exitStatus = this.rawProcessCommand(cmdArray, input, processor);
        if (exitStatus != null && this.requiresLogin) {
            Logs.APP_LOG.debug((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Command failed with status = " + exitStatus + " - retrying with fresh login"));
            exitStatus = this.login();
            if (exitStatus == null) {
                exitStatus = this.rawProcessCommand(cmdArray, input, processor);
            }
        }
        return exitStatus;
    }

    private String rawProcessCommand(String[] cmdArray, String input, final P4OutputProcessor processor) {
        final ExternalProcess process = this.createProcess(cmdArray, this.execCommandTimeout);
        PluggableProcessHandler handler = (PluggableProcessHandler)process.getHandler();
        handler.setOutputHandler((OutputHandler)new BaseOutputHandler(){

            public void process(InputStream inputStream) throws ProcessException {
                try {
                    processor.processOutput((Watchdog)process, inputStream, P4Exec.this.repoInfo.getEncoding());
                }
                catch (IOException e2) {
                    throw new ProcessException((Throwable)e2);
                }
                catch (P4ClientException e3) {
                    throw new ProcessException((Throwable)e3);
                }
            }

            public void complete() throws ProcessException {
                try {
                    processor.complete();
                }
                catch (P4ClientException e2) {
                    throw new ProcessException((Throwable)e2);
                }
            }
        });
        if (input != null) {
            handler.setInputHandler((InputHandler)new StringInputHandler(input));
        }
        process.execute();
        return P4Exec.getProcessStatusMessage(handler);
    }

    private static String getProcessStatusMessage(PluggableProcessHandler handler) {
        String status = null;
        ProcessException e2 = handler.getException();
        if (e2 != null) {
            status = ((Object)((Object)e2)).getClass().getName() + ":" + e2.getMessage();
            Logs.APP_LOG.debug((Object)"Exception processing P4 command - returning as status", (Throwable)e2);
        }
        String errorOutput = null;
        StringOutputHandler errorOutputHandler = (StringOutputHandler)handler.getErrorHandler();
        if (errorOutputHandler != null && !StringUtils.isEmpty((String)errorOutputHandler.getOutput())) {
            errorOutput = errorOutputHandler.getOutput();
        }
        if (status == null) {
            status = errorOutput;
        } else if (errorOutput != null) {
            status = status + " | " + errorOutput;
        }
        return status;
    }

    private String[] setUpCommand(List<String> command, String commandInput, P4Processor processor) {
        ArrayList<String> commandArgs = new ArrayList<String>(this.commandRoot);
        if (processor != null && processor.getFormatOption() != null) {
            commandArgs.add(processor.getFormatOption());
        }
        commandArgs.addAll(command);
        P4CliUtils.dumpCommandLine("[" + this.repoInfo.getRepositoryDescriptor() + "]", commandArgs, commandInput);
        return commandArgs.toArray(new String[commandArgs.size()]);
    }

    public String executeAndStream(List<String> command, String input, P4Visitor.ProcessOutputVisitor visitor) throws P4ClientException {
        String[] args = this.setUpCommand(command, input, null);
        String exitStatus = this.executeStreamCommand(args, input, visitor);
        if (exitStatus != null && this.requiresLogin && (exitStatus = this.login()) == null) {
            exitStatus = this.executeStreamCommand(args, input, visitor);
        }
        return exitStatus;
    }

    public String executeCommand(List<String> command, String commandInput, P4OutputProcessor processor) throws P4ClientException {
        String[] cmdArray = this.setUpCommand(command, commandInput, processor);
        return this.processCommand(cmdArray, commandInput, processor);
    }

    public String executeFieldCommand(List<String> command, String commandInput, boolean streamFieldLines, P4FieldProcessor processor) throws P4ClientException {
        String[] cmdArray = this.setUpCommand(command, commandInput, processor);
        return this.processCommand(cmdArray, commandInput, new P4LineToFieldProcessor(streamFieldLines, processor));
    }

    public String executeZTagCommand(List<String> command, String commandInput, String keyTag, P4ZTagProcessor processor) throws P4ClientException {
        return this.executeWithInput(command, commandInput, keyTag, processor);
    }

    public String executeWithInput(List<String> command, String commandInput, String keyTag, P4ZTagProcessor processor) throws P4ClientException {
        String[] cmdArray = this.setUpCommand(command, commandInput, processor);
        P4ZTagExtractor extractor = new P4ZTagExtractor(keyTag, processor);
        return this.processCommand(cmdArray, commandInput, extractor);
    }

    public static void setupExecutable(String p4ExecutableFilePath) throws ConfigException {
        if (StringUtils.isBlank((String)p4ExecutableFilePath)) {
            P4Exec.setP4Executable(DEFAULT_P4_EXECUTABLE);
        } else {
            File p4ExecutableFile = new File(p4ExecutableFilePath);
            if (p4ExecutableFile.exists() && p4ExecutableFile.isFile()) {
                P4Exec.setP4Executable(p4ExecutableFile.getAbsolutePath());
            } else {
                throw new ConfigException("P4 executable does not exist at configured location: " + p4ExecutableFile.getAbsolutePath() + ", using 'p4' instead, make sure it is on your PATH.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.processLock;
        synchronized (object) {
            while (!this.processStack.isEmpty()) {
                ExternalProcess process = this.processStack.pop();
                process.cancel();
            }
            if (this.executingThread != null) {
                try {
                    Thread.sleep(10000L);
                    this.executingThread.interrupt();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    public static void dumpP4Env() {
        Logs.APP_LOG.debug((Object)"Dump of P4 related environment variables: ");
        for (String env : P4_ENVIRONMENT_VARIABLES) {
            Logs.APP_LOG.debug((Object)(env + " = " + System.getenv(env)));
        }
    }

    public static void testP4Env(P4RepositoryInfo repoInfo, boolean dumpSysEnv) {
        String p4CharsetEnv;
        String p4TicketsEnv;
        if (dumpSysEnv) {
            P4Exec.dumpP4Env();
        }
        if ((p4TicketsEnv = System.getenv("P4TICKETS")) != null) {
            File p4TicketsFile = new File(p4TicketsEnv);
            if (p4TicketsFile.isDirectory()) {
                Logs.APP_LOG.warn((Object)("Environment variable P4TICKETS is incorrectly set to a directory path '" + p4TicketsEnv + "'. It must specify a file path."));
            } else if (!(p4TicketsFile.exists() || p4TicketsFile.getParentFile() != null && p4TicketsFile.getParentFile().exists() && p4TicketsFile.getParentFile().isDirectory())) {
                Logs.APP_LOG.warn((Object)("Environment variable P4TICKETS is set to an invalid path '" + p4TicketsEnv + "'"));
            }
        }
        if ((p4CharsetEnv = System.getenv("P4CHARSET")) != null && !repoInfo.isUnicode()) {
            Logs.APP_LOG.warn((Object)("Environment variable P4CHARSET is set to '" + p4CharsetEnv + "' but the FishEye config for repository '" + repoInfo.getName() + "' has unicodeServer=false"));
            Logs.APP_LOG.warn((Object)"This is may cause a connection failure.");
        }
    }
}

