/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce.client;

import com.atlassian.fisheye.RuntimeWrappedException;
import com.atlassian.utils.process.Watchdog;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.perforce.P4BranchSpec;
import com.cenqua.fisheye.perforce.P4RepositoryInfo;
import com.cenqua.fisheye.perforce.client.AnnotateCallBack;
import com.cenqua.fisheye.perforce.client.BranchFieldProcessor;
import com.cenqua.fisheye.perforce.client.DescribeProcessor;
import com.cenqua.fisheye.perforce.client.P4ChangeList;
import com.cenqua.fisheye.perforce.client.P4ChangePath;
import com.cenqua.fisheye.perforce.client.P4CliUtils;
import com.cenqua.fisheye.perforce.client.P4ClientException;
import com.cenqua.fisheye.perforce.client.P4Exec;
import com.cenqua.fisheye.perforce.client.P4FieldProcessor;
import com.cenqua.fisheye.perforce.client.P4FileSpec;
import com.cenqua.fisheye.perforce.client.P4Fix;
import com.cenqua.fisheye.perforce.client.P4Job;
import com.cenqua.fisheye.perforce.client.P4Label;
import com.cenqua.fisheye.perforce.client.P4OutputLineProcessor;
import com.cenqua.fisheye.perforce.client.P4OutputProcessor;
import com.cenqua.fisheye.perforce.client.P4Visitor;
import com.cenqua.fisheye.perforce.client.P4ZTagProcessor;
import com.cenqua.fisheye.rep.DiffTextCache;
import com.cenqua.fisheye.rep.RepositoryStatus;
import com.cenqua.fisheye.rep.activity.ActivityLogMonitor;
import com.cenqua.fisheye.util.Throttle;
import it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class P4Client {
    private static final int DEFAULT_MAX_FILELOGS = 50000;
    private static final int DEFAULT_MAX_PRINT = 100;
    private static final int DEFAULT_MAX_PRINT_BYTES = 1000000;
    private static final Pattern CSID_PATTERN = Pattern.compile("([0-9]+): (.*)");
    private final P4RepositoryInfo repoInfo;
    private RepositoryStatus status;
    private final P4Exec exec;
    private final int maxFilelogs;
    private final int maxPrint;
    private final String separator = System.getProperty("line.separator");
    private final int maxPrintBytes;
    private static final int BYTE_MASK = 255;

    public P4Client(P4RepositoryInfo repoInfo, Throttle throttle, RepositoryStatus status) throws P4ClientException {
        this.repoInfo = repoInfo;
        this.status = status;
        ActivityLogMonitor activityMonitor = null;
        if (status != null) {
            activityMonitor = new ActivityLogMonitor(status.getRecentActivities(), null);
        }
        this.exec = new P4Exec(repoInfo, throttle, activityMonitor);
        this.exec.login();
        this.maxFilelogs = repoInfo.getMaxFilelogs() > 0 ? repoInfo.getMaxFilelogs() : 50000;
        this.maxPrint = 100;
        this.maxPrintBytes = 1000000;
    }

    public Map<String, String> info() throws P4ClientException {
        final HashMap<String, String> result = new HashMap<String, String>(10);
        String exitStatus = this.exec.executeZTagCommand(P4CliUtils.tokenizeCommand("info"), null, null, new P4ZTagProcessor(){

            @Override
            public void processGroup(Map<String, String> group) {
                result.putAll(group);
            }
        });
        if (exitStatus != null) {
            throw new P4ClientException("Unable to get repository info: " + exitStatus);
        }
        return result;
    }

    public int getMaxPrint() {
        return this.maxPrint;
    }

    public long getLatestRevision() throws P4ClientException {
        Long[] result;
        String pathSpec;
        List<String> command = P4CliUtils.tokenizeCommand("-x - changes -m 1 -s submitted");
        String exitStatus = this.exec.executeZTagCommand(command, pathSpec = this.repoInfo.getBasePath() + '/' + "...", null, new P4ZTagProcessor(result = new Long[1]){
            final /* synthetic */ Long[] val$result;
            {
                this.val$result = longArray;
            }

            @Override
            public void processGroup(Map<String, String> group) {
                this.val$result[0] = Long.valueOf(group.get("change"));
            }
        });
        if (exitStatus != null) {
            Logs.APP_LOG.warn((Object)("Non-zero exit status determining latest revision: " + exitStatus));
        }
        if (result[0] == null) {
            throw new P4ClientException("Unable to determine latest revision. No revision information was returned - check path exists, permissions and output encoding");
        }
        return result[0];
    }

    public Long2ObjectSortedMap<P4ChangeList> getChangeLists(long startRevision, long blockSize, long latestRevision, final boolean fullInfo, boolean storeDiffs, DiffTextCache diffTextCache) throws P4ClientException {
        Long2ObjectAVLTreeMap changeLists;
        String changelistSpec;
        List<String> command;
        String status;
        long endRevision;
        if (blockSize > 0L) {
            endRevision = startRevision + blockSize - 1L;
            if (endRevision > latestRevision) {
                endRevision = latestRevision;
            }
        } else {
            endRevision = latestRevision;
        }
        if ((status = this.exec.executeZTagCommand(command = fullInfo ? P4CliUtils.tokenizeCommand("-x - changes -l") : P4CliUtils.tokenizeCommand("-x - changes"), changelistSpec = this.repoInfo.getBasePath() + '/' + "..." + "@" + startRevision + "," + endRevision, "change", new P4ZTagProcessor((Long2ObjectSortedMap)(changeLists = new Long2ObjectAVLTreeMap())){
            final /* synthetic */ Long2ObjectSortedMap val$changeLists;
            {
                this.val$changeLists = long2ObjectSortedMap;
            }

            @Override
            public void processGroup(Map<String, String> group) {
                long changeListId = Long.parseLong(group.get("change"));
                if (fullInfo) {
                    P4ChangeList changeList = new P4ChangeList(changeListId);
                    changeList.setUser(group.get("user"));
                    changeList.setClient(group.get("client"));
                    changeList.addComment(group.get("desc"));
                    changeList.setDate(1000L * Long.parseLong(group.get("time")));
                    Logs.APP_LOG.debug((Object)("[" + P4Client.this.repoInfo.getRepositoryDescriptor() + "] Adding changelist " + changeListId));
                    this.val$changeLists.put(changeListId, (Object)changeList);
                } else {
                    this.val$changeLists.put(changeListId, null);
                }
            }
        })) != null) {
            throw new P4ClientException(status);
        }
        if (fullInfo) {
            this.addChangesInformation((Long2ObjectSortedMap<P4ChangeList>)changeLists, storeDiffs, diffTextCache);
            this.addChangeFileInfo((Long2ObjectSortedMap<P4ChangeList>)changeLists, false);
        }
        return changeLists;
    }

    public P4ChangeList getChangeList(long changeListId) throws P4ClientException {
        StringBuilder commandStr = new StringBuilder("change ");
        commandStr.append("-o ");
        commandStr.append(changeListId);
        List<String> command = P4CliUtils.tokenizeCommand(commandStr.toString());
        final P4ChangeList changeList = new P4ChangeList(changeListId);
        String status = this.exec.executeZTagCommand(command, null, null, new P4ZTagProcessor(){

            @Override
            public void processGroup(Map<String, String> group) {
                changeList.setUser(group.get("User"));
                changeList.setClient(group.get("Client"));
                changeList.addComment(group.get("Description"));
                changeList.setDate(P4CliUtils.parseP4DateString(group.get("Date")).getTime());
            }
        });
        if (status != null) {
            throw new P4ClientException(status);
        }
        Long2ObjectAVLTreeMap map = new Long2ObjectAVLTreeMap();
        map.put(changeList.getId(), (Object)changeList);
        this.addFixes((Long2ObjectSortedMap<P4ChangeList>)map);
        return changeList;
    }

    public void addChangeFileInfo(Long2ObjectSortedMap<P4ChangeList> changeLists, boolean importMode) throws P4ClientException {
        this.addFileInfo(changeLists, importMode);
        this.addFixes(changeLists);
        this.removeBadPaths((Map<Long, P4ChangeList>)changeLists);
    }

    private void addFixes(final Long2ObjectSortedMap<P4ChangeList> changeLists) throws P4ClientException {
        if (changeLists.isEmpty()) {
            return;
        }
        if (this.status.isStopRequested()) {
            return;
        }
        Logs.APP_LOG.debug((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Adding fix information"));
        long firstChangeList = changeLists.firstLongKey();
        long lastChangeList = changeLists.lastLongKey();
        List<String> command = P4CliUtils.tokenizeCommand("-x - fixes");
        String changelistSpec = this.repoInfo.getBasePath() + '/' + "..." + "@" + firstChangeList + "," + lastChangeList;
        String status = this.exec.executeZTagCommand(command, changelistSpec, "Job", new P4ZTagProcessor(){

            @Override
            public void processGroup(Map<String, String> group) {
                String jobName = group.get("Job");
                long changeId = Long.parseLong(group.get("Change"));
                long fixDate = Long.parseLong(group.get("Date"));
                String user = group.get("User");
                P4Fix fix = new P4Fix(jobName, changeId, fixDate, user);
                P4ChangeList change = (P4ChangeList)changeLists.get(changeId);
                if (change != null) {
                    change.addFix(fix);
                }
            }
        });
        if (status != null) {
            throw new P4ClientException(status);
        }
    }

    private static String quoteIfNeeded(String s2) {
        if (s2 != null && s2.length() > 0 && s2.charAt(0) == '-') {
            StringBuilder b2 = new StringBuilder();
            return b2.append("\\\"").append(s2).append("\\\"").toString();
        }
        return s2;
    }

    public P4Job getJob(String jobName) throws P4ClientException {
        List<String> command = P4CliUtils.tokenizeCommand("-x - job -o");
        final P4Job job = new P4Job();
        String status = this.exec.executeFieldCommand(command, P4Client.quoteIfNeeded(jobName), false, new P4FieldProcessor(){

            @Override
            public void processField(String fieldName, String fieldValue) {
                if (fieldName.equals("Job")) {
                    job.setName(fieldValue);
                } else if (fieldName.equals("Description")) {
                    job.setDescription(fieldValue);
                } else {
                    job.setField(fieldName, fieldValue);
                }
            }
        });
        if (status != null) {
            throw new P4ClientException(status);
        }
        return job;
    }

    private void removeBadPaths(Map<Long, P4ChangeList> changeLists) {
        for (P4ChangeList changeList : changeLists.values()) {
            changeList.removeBadPaths();
        }
    }

    private void addFileInfo(Long2ObjectSortedMap<P4ChangeList> changeLists, boolean importMode) throws P4ClientException {
        if (changeLists.isEmpty()) {
            return;
        }
        Logs.APP_LOG.debug((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Adding file information"));
        int numPaths = 0;
        ArrayList<String> fileList = new ArrayList<String>();
        boolean hasFiles = false;
        for (P4ChangeList changeList : changeLists.values()) {
            for (P4ChangePath changePath : changeList.getChangePaths()) {
                if (this.status.isStopRequested()) {
                    return;
                }
                fileList.add(changePath.getPath() + "#" + changePath.getFileRev());
                hasFiles = true;
                if (++numPaths <= this.maxFilelogs) continue;
                this.execFilelog(changeLists, fileList, importMode);
                fileList.clear();
                numPaths = 0;
            }
        }
        if (numPaths != 0) {
            this.execFilelog(changeLists, fileList, importMode);
        }
        if (!hasFiles) {
            Logs.APP_LOG.warn((Object)("No change paths were found in the change lists : " + changeLists));
        }
    }

    private void execFilelog(Long2ObjectSortedMap<P4ChangeList> changeLists, List<String> fileList, boolean importMode) throws P4ClientException {
        String status = this.fetchFileLog(changeLists, fileList, importMode);
        if (status != null) {
            int size = fileList.size();
            if (size > 1) {
                int midPoint = size / 2;
                this.execFilelog(changeLists, fileList.subList(0, midPoint), importMode);
                this.execFilelog(changeLists, fileList.subList(midPoint, size - 1), importMode);
            } else if (size == 1) {
                Logs.APP_LOG.warn((Object)("Unable to get file log for " + fileList.get(0)));
            }
        }
    }

    private String fetchFileLog(final Long2ObjectSortedMap<P4ChangeList> changeLists, List<String> fileList, final boolean importMode) throws P4ClientException {
        StringBuilder filelogArgs = new StringBuilder();
        filelogArgs.append("-m 1").append(this.separator);
        for (String fileSpec : fileList) {
            filelogArgs.append(fileSpec).append(this.separator);
        }
        String status = this.exec.executeWithInput(P4CliUtils.tokenizeCommand("-x - filelog"), filelogArgs.toString(), "depotFile", new P4ZTagProcessor(){

            @Override
            public void processGroup(Map<String, String> pathProps) {
                String path = pathProps.get("depotFile");
                int index = 0;
                while (pathProps.containsKey("change" + index)) {
                    block10: {
                        P4ChangePath p4Path;
                        block12: {
                            block11: {
                                long changeListId = importMode ? changeLists.firstLongKey() : Long.parseLong(pathProps.get("change" + index));
                                P4ChangeList changeList = (P4ChangeList)changeLists.get(changeListId);
                                if (changeList == null) break block10;
                                p4Path = changeList.getChangePath(path);
                                if (p4Path != null) break block11;
                                int rev = Integer.parseInt(pathProps.get("rev" + index));
                                Logs.APP_LOG.warn((Object)("[" + P4Client.this.repoInfo.getRepositoryDescriptor() + "] Skipping path " + path + "#" + rev + " from filelog for " + changeListId + " as it is not included in the changelist's affected files list"));
                                break block10;
                            }
                            if (!pathProps.containsKey("rev" + index)) break block12;
                            int filerev = Integer.parseInt(pathProps.get("rev" + index));
                            if (p4Path.getFileRev() != filerev) break block10;
                        }
                        if (!pathProps.containsKey("type" + index)) {
                            Logs.APP_LOG.warn((Object)("[" + P4Client.this.repoInfo.getRepositoryDescriptor() + "] Unable to determine file's type from filelog property map: " + pathProps));
                        }
                        p4Path.setFileType(pathProps.get("type" + index));
                        if (importMode) {
                            p4Path.setAction("add");
                        } else {
                            p4Path.setAction(pathProps.get("action" + index));
                        }
                        if (pathProps.containsKey("fileSize" + index)) {
                            p4Path.setFileSize(Long.parseLong(pathProps.get("fileSize" + index)));
                        }
                        int subIndex = 0;
                        while (pathProps.containsKey("how" + index + "," + subIndex)) {
                            String key = index + "," + subIndex;
                            String how = pathProps.get("how" + key);
                            if (how.endsWith(" from")) {
                                String sourcePath = pathProps.get("file" + key);
                                String startRev = pathProps.get("srev" + key);
                                String endRev = pathProps.get("erev" + key);
                                try {
                                    P4FileSpec sourceSpec = new P4FileSpec(sourcePath, startRev, endRev);
                                    String integrationAction = P4CliUtils.getWord(how);
                                    p4Path.setSourceInfo(integrationAction, sourceSpec);
                                }
                                catch (NumberFormatException e2) {
                                    Logs.APP_LOG.debug((Object)("[" + P4Client.this.repoInfo.getRepositoryDescriptor() + "] Unable to parse filespec: " + sourcePath + " " + startRev + ":" + endRev));
                                }
                            }
                            ++subIndex;
                        }
                    }
                    ++index;
                }
            }
        });
        return status;
    }

    private void addChangesInformation(Long2ObjectSortedMap<P4ChangeList> changeLists, boolean storeDiffs, DiffTextCache diffTextCache) throws P4ClientException {
        DescribeProcessor.DescribeType describeType;
        if (changeLists.isEmpty()) {
            return;
        }
        Logs.APP_LOG.debug((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Adding change information"));
        StringBuilder describeBase = new StringBuilder();
        if (storeDiffs) {
            describeBase.append("describe -dn");
            describeType = DescribeProcessor.DescribeType.RCS;
        } else {
            describeBase.append("describe -ds");
            describeType = DescribeProcessor.DescribeType.SUMMARY;
        }
        StringBuilder describeCommand = new StringBuilder(describeBase);
        for (P4ChangeList changeList : changeLists.values()) {
            describeCommand.append(' ');
            describeCommand.append(changeList.getId());
        }
        DescribeProcessor processor = new DescribeProcessor(this.repoInfo, (SortedMap<Long, P4ChangeList>)changeLists, describeType, diffTextCache);
        String exitStatus = this.exec.executeCommand(P4CliUtils.tokenizeCommand(describeCommand.toString()), null, processor);
        if (exitStatus != null) {
            Logs.APP_LOG.warn((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Problem executing " + describeCommand + ": " + exitStatus));
            Logs.APP_LOG.debug((Object)"Dropping to individual changelists");
            for (Map.Entry p4ChangeListEntry : changeLists.entrySet()) {
                ((P4ChangeList)p4ChangeListEntry.getValue()).getChangePaths().clear();
                long csid = (Long)p4ChangeListEntry.getKey();
                if (this.status.isStopRequested()) {
                    return;
                }
                describeCommand.setLength(0);
                describeCommand.append((CharSequence)describeBase).append(' ').append(csid);
                exitStatus = this.exec.executeCommand(P4CliUtils.tokenizeCommand(describeCommand.toString()), null, processor);
                if (exitStatus == null) continue;
                Logs.APP_LOG.warn((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Problem executing " + describeCommand + ": " + exitStatus));
                ((P4ChangeList)changeLists.get(csid)).getChangePaths().clear();
                this.getShortChangeInfo(changeLists, csid, processor);
            }
        }
    }

    private void getShortChangeInfo(Long2ObjectSortedMap<P4ChangeList> changeLists, long csid, DescribeProcessor processor) throws P4ClientException {
        String command = "describe -s " + csid;
        String status = this.exec.executeCommand(P4CliUtils.tokenizeCommand(command), null, processor);
        if (status != null) {
            Logs.APP_LOG.warn((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Problem executing " + command + ": " + status));
            Logs.APP_LOG.warn((Object)("Removing changelist " + csid));
            changeLists.remove(csid);
        }
    }

    public void streamContent(P4FileSpec fileSpec, String kopt, P4Visitor.ProcessOutputVisitor visitor) throws P4ClientException {
        List<String> command = P4CliUtils.tokenizeCommand("-x - print -q");
        String status = this.exec.executeAndStream(command, fileSpec.getPath() + '#' + fileSpec.getFileRev(), visitor);
        if (status != null) {
            throw new P4ClientException(status);
        }
    }

    public void streamContent(String path, long changeListId, String kopt, P4Visitor.ProcessOutputVisitor visitor) throws P4ClientException {
        List<String> command = P4CliUtils.tokenizeCommand("-x - print -q");
        String status = this.exec.executeAndStream(command, path + '@' + changeListId, visitor);
        if (status != null) {
            throw new P4ClientException(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exportContent(String path, File contentFile, long changeListId) throws FileNotFoundException, P4ClientException {
        boolean bl;
        final FileOutputStream fos = new FileOutputStream(contentFile);
        try {
            this.streamContent(path, changeListId, null, new P4Visitor.ProcessOutputVisitor(){

                @Override
                public void visit(Watchdog watchdog, InputStream is, String encoding) throws RuntimeWrappedException {
                    try {
                        IOHelper.copyStream(is, (OutputStream)fos);
                    }
                    catch (IOException e2) {
                        try {
                            throw new RuntimeWrappedException(e2);
                        }
                        catch (Throwable throwable) {
                            IOHelper.close(is);
                            throw throwable;
                        }
                    }
                    IOHelper.close(is);
                }
            });
            bl = true;
        }
        catch (Throwable throwable) {
            IOHelper.close(fos);
            throw throwable;
        }
        IOHelper.close(fos);
        return bl;
    }

    public void getBlame(String fileSpec, String fileType, long changeListId, boolean isUnicodeServer, final AnnotateCallBack callback) throws P4ClientException {
        P4OutputProcessor processor;
        String pathSpec;
        List<String> command = P4CliUtils.tokenizeCommand("-x - annotate -c -q");
        String status = this.exec.executeCommand(command, pathSpec = fileSpec + '@' + changeListId, processor = !isUnicodeServer && fileType.equals("unicode") ? new P4OutputProcessor(){

            @Override
            public void processOutput(Watchdog watchdog, InputStream is, String encoding) throws IOException, P4ClientException {
                P4Client.this.processMixedBlameStream(watchdog, is, callback);
            }
        } : new P4OutputLineProcessor(){

            @Override
            public void processLine(String infoLine, int count) {
                if (infoLine.trim().length() != 0) {
                    Matcher m2 = CSID_PATTERN.matcher(infoLine);
                    if (m2.matches()) {
                        long changeList = Long.parseLong(m2.group(1));
                        String text = m2.group(2);
                        callback.singleLine(changeList, text);
                    } else {
                        callback.continueLine(infoLine);
                    }
                }
            }
        });
        if (status != null) {
            throw new P4ClientException(status);
        }
    }

    private void processMixedBlameStream(Watchdog watchdog, InputStream is, AnnotateCallBack callback) throws IOException {
        long csid = this.readAnnotationLineNum(is);
        byte[] bom = new byte[2];
        int numRead = is.read(bom);
        if (numRead != 2) {
            throw new IOException("Stream does not include BOM");
        }
        boolean littleEndian = bom[0] == -1 && bom[1] == -2 ? true : (bom[0] == -2 && bom[1] == -1 ? false : false);
        int lineNumber = 1;
        String line = this.readUnicodeLine(is, littleEndian);
        callback.singleLine(csid, line);
        do {
            watchdog.resetWatchdog();
            csid = this.readAnnotationLineNum(is);
            if (csid == -1L) continue;
            line = this.readUnicodeLine(is, littleEndian);
            if (line.length() > 0 && line.charAt(line.length() - 1) == '\r') {
                line = line.substring(0, line.length() - 1);
            }
            ++lineNumber;
            callback.singleLine(csid, line);
        } while (csid != -1L);
    }

    private long readAnnotationLineNum(InputStream is) throws IOException {
        int c2;
        StringBuilder numberBuffer = new StringBuilder();
        while ((c2 = is.read()) != -1 && c2 != 58) {
            numberBuffer.append((char)c2);
        }
        if (c2 == -1) {
            return -1L;
        }
        c2 = is.read();
        if (c2 != 32) {
            throw new IOException("Unexpected content in P4 annotation output");
        }
        return Long.parseLong(numberBuffer.toString());
    }

    private String readUnicodeLine(InputStream is, boolean littleEndian) throws IOException {
        int numRead;
        StringBuilder line = new StringBuilder();
        byte[] b2 = new byte[2];
        while ((numRead = is.read(b2)) != -1) {
            if (numRead != 2) {
                throw new IOException("Annotated output is malformed - unable to read Unicode character");
            }
            int c2 = littleEndian ? (b2[1] & 0xFF) << 8 | b2[0] & 0xFF : (b2[0] & 0xFF) << 8 | b2[1] & 0xFF;
            if (c2 != 10) {
                line.append((char)c2);
            }
            if (c2 != 10) continue;
        }
        return line.toString();
    }

    public Map<String, Long> getBranchUpdateTimes() throws P4ClientException {
        final HashMap<String, Long> branchTimes = new HashMap<String, Long>();
        String status = this.exec.executeZTagCommand(P4CliUtils.tokenizeCommand("branches"), null, "branch", new P4ZTagProcessor(){

            @Override
            public void processGroup(Map<String, String> branchProps) {
                try {
                    branchTimes.put(branchProps.get("branch"), Long.valueOf(branchProps.get("Update")));
                }
                catch (Exception e2) {
                    Logs.APP_LOG.warn((Object)("[" + P4Client.this.repoInfo.getRepositoryDescriptor() + "] Unable to get branch update time: " + branchProps));
                }
            }
        });
        if (status != null) {
            throw new P4ClientException(status);
        }
        return branchTimes;
    }

    public P4BranchSpec getBranchSpec(String branchName) throws P4ClientException {
        P4BranchSpec branchSpec;
        List<String> command = P4CliUtils.tokenizeCommand("-x - branch -o");
        String status = this.exec.executeFieldCommand(command, branchName, false, new BranchFieldProcessor(branchSpec = new P4BranchSpec(branchName)));
        if (status != null) {
            Logs.APP_LOG.warn((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Failed to read branch spec '" + branchName + "': " + status));
            return null;
        }
        return branchSpec;
    }

    public P4Label getLabel(final String name) throws P4ClientException {
        P4Label label;
        List<String> command = P4CliUtils.tokenizeCommand("-x - label -o");
        String status = this.exec.executeZTagCommand(command, name, null, new P4ZTagProcessor(label = new P4Label(name)){
            final /* synthetic */ P4Label val$label;
            {
                this.val$label = p4Label;
            }

            @Override
            public void processGroup(Map<String, String> labelProps) {
                String labelName = labelProps.get("Label");
                if (labelName != null) {
                    if (labelName.equals(name)) {
                        this.val$label.setUpdateTime(P4CliUtils.parseP4DateToTime(labelProps.get("Update")));
                        this.val$label.setAccessTime(P4CliUtils.parseP4DateToTime(labelProps.get("Access")));
                    }
                } else {
                    Logs.APP_LOG.warn((Object)("Unable to label information for label " + name + ", props = " + labelProps));
                }
            }
        });
        if (status != null) {
            Logs.APP_LOG.error((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Unable to get Perforce label information for " + name + " - command status: " + status));
        }
        return label;
    }

    public void visitLabels(List<Path> includedPaths, P4Visitor.LabelVisitor visitor) throws P4ClientException {
        if (includedPaths.isEmpty()) {
            this.visitPathLabels(visitor, Path.ROOT);
        } else {
            for (Path path : includedPaths) {
                this.visitPathLabels(visitor, path);
            }
        }
    }

    private void visitPathLabels(final P4Visitor.LabelVisitor visitor, Path path) throws P4ClientException {
        String serverPath;
        List<String> command = P4CliUtils.tokenizeCommand("-x - labels");
        String status = this.exec.executeZTagCommand(command, serverPath = this.repoInfo.getServerPath(path, -1L) + '/' + "...", "label", new P4ZTagProcessor(){

            @Override
            public void processGroup(Map<String, String> labelProps) {
                String accessValue;
                P4Label label = new P4Label(labelProps.get("label"));
                String updateValue = labelProps.get("Update");
                if (updateValue != null) {
                    label.setUpdateTime(Long.parseLong(updateValue));
                }
                if ((accessValue = labelProps.get("Access")) != null) {
                    label.setAccessTime(Long.parseLong(accessValue));
                }
                visitor.visit(label);
            }
        });
        if (status != null) {
            Logs.APP_LOG.error((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Unable to get Perforce label information - command status: " + status));
        }
    }

    public void visitLabelFiles(String label, P4Visitor.FileVisitor visitor) throws P4ClientException {
        String pathModifier = "@" + label;
        this.visitFilesByTree(this.repoInfo.getBasePath(), visitor, pathModifier);
    }

    public void visitRevisionFiles(String path, long revision, P4Visitor.FileVisitor visitor) throws P4ClientException {
        String pathModifier = "@" + revision;
        this.visitFilesByTree(path, visitor, pathModifier);
    }

    private void visitFilesByTree(String dir, final P4Visitor.FileVisitor visitor, String pathModifier) throws P4ClientException {
        String pathSpec;
        List<String> command = P4CliUtils.tokenizeCommand("-x - files");
        String status = this.exec.executeZTagCommand(command, pathSpec = dir + '/' + "..." + pathModifier, "depotFile", new P4ZTagProcessor(){

            @Override
            public void processGroup(Map<String, String> fileInfo) {
                if (!"delete".equals(fileInfo.get("action"))) {
                    P4FileSpec fileSpec = new P4FileSpec(fileInfo.get("depotFile"), Integer.parseInt(fileInfo.get("rev")));
                    visitor.visit(fileSpec);
                }
            }
        });
        if (status != null) {
            Logs.APP_LOG.warn((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Unable to load file information for directory " + dir + pathModifier + ", due to status = " + status));
            this.visitFilesByDirTrees(dir, visitor, pathModifier);
        }
    }

    private void visitFilesByDirTrees(String dir, final P4Visitor.FileVisitor visitor, final String pathModifier) throws P4ClientException {
        this.visitFilesinDir(dir, visitor, pathModifier);
        List<String> command = P4CliUtils.tokenizeCommand("-x - dirs");
        String status = this.exec.executeZTagCommand(command, dir + "/*", "dir", new P4ZTagProcessor(){

            @Override
            public void processGroup(Map<String, String> dirInfo) throws P4ClientException {
                P4Client.this.visitFilesByTree(dirInfo.get("dir"), visitor, pathModifier);
            }
        });
        if (status != null) {
            Logs.APP_LOG.warn((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Unable to list dirs for " + dir + pathModifier + " - skipping this dir" + ", due to status = " + status));
        }
    }

    private void visitFilesinDir(String dir, final P4Visitor.FileVisitor visitor, String pathModifier) throws P4ClientException {
        String pathSpec;
        List<String> command = P4CliUtils.tokenizeCommand("-x - files");
        String status = this.exec.executeZTagCommand(command, pathSpec = dir + "/*" + pathModifier, "depotFile", new P4ZTagProcessor(){

            @Override
            public void processGroup(Map<String, String> fileInfo) {
                if (!"delete".equals(fileInfo.get("action"))) {
                    P4FileSpec fileSpec = new P4FileSpec(fileInfo.get("depotFile"), Integer.parseInt(fileInfo.get("rev")));
                    visitor.visit(fileSpec);
                }
            }
        });
        if (status != null) {
            Logs.APP_LOG.warn((Object)("[" + this.repoInfo.getRepositoryDescriptor() + "] Unable to get list of files in dir " + dir + pathModifier + ", due to status = " + status));
        }
    }

    public void streamMultipleContent(Set<P4FileSpec> fileSpecs, P4Visitor.ProcessOutputVisitor visitor) throws P4ClientException {
        HashSet<P4FileSpec> specList = new HashSet<P4FileSpec>(fileSpecs);
        int numPaths = 0;
        StringBuilder printArgs = new StringBuilder();
        for (P4FileSpec fileSpec : specList) {
            if (printArgs.length() != 0) {
                printArgs.append(this.separator);
            }
            printArgs.append(fileSpec);
            if (++numPaths <= this.maxPrint) continue;
            this.execMultiPrint(printArgs, visitor);
            printArgs.setLength(0);
            numPaths = 0;
        }
        String status = null;
        if (numPaths != 0) {
            status = this.execMultiPrint(printArgs, visitor);
        }
        if (status != null) {
            throw new P4ClientException(status);
        }
    }

    private String execMultiPrint(StringBuilder printArgs, P4Visitor.ProcessOutputVisitor visitor) throws P4ClientException {
        String exitStatus = null;
        if (printArgs.length() != 0) {
            exitStatus = this.exec.executeAndStream(P4CliUtils.tokenizeCommand("-x - print"), printArgs.toString(), visitor);
        }
        return exitStatus;
    }

    public int getMaxPrintBytes() {
        return this.maxPrintBytes;
    }

    public void cancel() {
        this.exec.cancel();
    }
}

