/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce.client;

import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.perforce.client.P4FileSpec;
import com.cenqua.fisheye.rep.impl.CommonChangeInfo;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Locale;
import java.util.regex.Pattern;

public class P4ChangePath
extends CommonChangeInfo {
    public static final String FILETYPE_UNKNOWN = "unknown";
    private final P4FileSpec fileSpec;
    private String action;
    private String fileType = "unknown";
    private String integrationAction;
    private P4FileSpec sourceFileSpec;
    private long fileSize;
    private static final Pattern TEXT_TYPE_PATTERN = Pattern.compile(".*(text|unicode|utf16).*");

    public P4ChangePath(P4FileSpec fileSpec) {
        this.fileSpec = fileSpec;
    }

    public String getPath() {
        return this.fileSpec.getPath();
    }

    public String getAction() {
        return this.action;
    }

    public void setFileType(String fileType) {
        this.fileType = fileType;
    }

    public String getFileType() {
        return this.fileType;
    }

    public int getFileRev() {
        return this.fileSpec.getFileRev();
    }

    public void setSourceInfo(String integrationAction, P4FileSpec sourceFileSpec) {
        this.integrationAction = integrationAction;
        this.sourceFileSpec = sourceFileSpec;
    }

    @Override
    public String toString() {
        String result = "P4ChangePath - " + this.fileSpec.toString() + " " + this.action + " " + this.fileType;
        if (this.integrationAction != null) {
            result = result + " " + this.integrationAction + " from " + this.sourceFileSpec;
        }
        return result;
    }

    @Override
    public String toStringChild() {
        return this.toString();
    }

    public P4FileSpec getFileSpec() {
        return this.fileSpec;
    }

    public P4FileSpec getSourceFileSpec() {
        return this.sourceFileSpec;
    }

    public String getIntegrationAction() {
        return this.integrationAction;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public long getFileSize() {
        return this.fileSize;
    }

    public boolean isBinary() {
        String type = this.fileType.toLowerCase(Locale.US);
        return !TEXT_TYPE_PATTERN.matcher(type).matches();
    }

    @Override
    public void addHunk(Hunk hunk) {
        List<Hunk> hunks = this.getHunks();
        if (hunks == null || hunks.isEmpty()) {
            super.addHunk(hunk);
        } else {
            int lastIndex = hunks.size() - 1;
            Hunk lastHunk = hunks.get(lastIndex);
            int firstLineAfterDeleteHunk = lastHunk.getFrom() + lastHunk.getFromCount();
            int firstLineOfAddHunk = hunk.getFrom() + 1;
            if (lastHunk.isDelete() && hunk.isAdd() && firstLineAfterDeleteHunk == firstLineOfAddHunk) {
                hunks.remove(lastIndex);
                int fromCount = lastHunk.getFromCount() + hunk.getFromCount();
                int toCount = lastHunk.getToCount() + hunk.getToCount();
                Hunk combinedHunk = new Hunk(lastHunk.getFrom(), hunk.getTo(), fromCount, toCount);
                Preconditions.checkState((boolean)combinedHunk.isChange(), (String)"Expected a change hunk, got %s", (Object[])new Object[]{combinedHunk});
                hunks.add(combinedHunk);
            } else {
                hunks.add(hunk);
            }
        }
    }
}

