/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce.client;

import com.cenqua.fisheye.perforce.client.P4ChangePath;
import com.cenqua.fisheye.perforce.client.P4Fix;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;

public class P4ChangeList {
    private String author;
    private long date;
    private final StringBuilder comment;
    private final long id;
    private final SortedMap<String, P4ChangePath> changePaths = new TreeMap<String, P4ChangePath>();
    private final List<P4Fix> fixes = new ArrayList<P4Fix>();
    private String client;

    public P4ChangeList(long id) {
        this.id = id;
        this.comment = new StringBuilder();
    }

    public void setDate(long date) {
        this.date = date;
    }

    public void setUser(String userSpec) {
        if (userSpec != null) {
            int atIndex = userSpec.indexOf(64);
            this.author = atIndex == -1 ? userSpec : userSpec.substring(0, atIndex);
        }
    }

    public void addComment(String s2) {
        if (this.comment.length() != 0) {
            this.comment.append('\n');
        }
        this.comment.append(s2);
    }

    public String getAuthor() {
        return this.author;
    }

    public long getDate() {
        return this.date;
    }

    public String getComment() {
        return this.comment.toString();
    }

    public long getId() {
        return this.id;
    }

    public P4ChangePath getChangePath(String path) {
        return (P4ChangePath)this.changePaths.get(path);
    }

    public Collection<P4ChangePath> getChangePaths() {
        return this.changePaths.values();
    }

    public void addChangePath(P4ChangePath changePath) {
        this.changePaths.put(changePath.getPath(), changePath);
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder("Change ");
        buffer.append(this.id).append(": ").append(this.author).append(" ").append(new Date(this.date));
        buffer.append('\n').append((CharSequence)this.comment).append('\n').append("Paths: \n");
        for (P4ChangePath path : this.changePaths.values()) {
            buffer.append(path.toString()).append('\n');
        }
        return buffer.toString();
    }

    public void removeBadPaths() {
        Iterator<P4ChangePath> pathIterator = this.changePaths.values().iterator();
        while (pathIterator.hasNext()) {
            P4ChangePath changePath = pathIterator.next();
            if (changePath.getAction() != null) continue;
            pathIterator.remove();
        }
    }

    public void addFix(P4Fix fix) {
        this.fixes.add(fix);
    }

    public List<P4Fix> getFixes() {
        return this.fixes;
    }

    public void setClient(String client) {
        this.client = client;
    }

    public String getClient() {
        return this.client;
    }
}

