/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce.client;

import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.perforce.P4BranchMapping;
import com.cenqua.fisheye.perforce.P4BranchSpec;
import com.cenqua.fisheye.perforce.client.P4FieldProcessor;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;

public class BranchFieldProcessor
extends P4FieldProcessor {
    private final P4BranchSpec branchSpec;

    public BranchFieldProcessor(P4BranchSpec branchSpec) {
        this.branchSpec = branchSpec;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processField(String fieldName, String fieldValue) {
        if (fieldName.equals("View")) {
            BufferedReader reader = new BufferedReader(new StringReader(fieldValue));
            try {
                String viewInfo;
                while ((viewInfo = reader.readLine()) != null) {
                    boolean negative = (viewInfo = viewInfo.trim()).startsWith("-");
                    if (negative) {
                        viewInfo = viewInfo.substring(1);
                    }
                    int maptoIndex = viewInfo.lastIndexOf("//");
                    String from = viewInfo.substring(0, maptoIndex - 1).trim();
                    String to = viewInfo.substring(maptoIndex).trim();
                    P4BranchMapping mapping = new P4BranchMapping(negative, from, to);
                    this.branchSpec.addMapping(mapping);
                }
            }
            catch (IOException e2) {
                try {
                    Logs.APP_LOG.warn((Object)("Unexpected exception processing field " + fieldName), (Throwable)e2);
                }
                catch (Throwable throwable) {
                    IOHelper.close(reader);
                    throw throwable;
                }
                IOHelper.close(reader);
            }
            IOHelper.close(reader);
        }
    }
}

