/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.cenqua.fisheye.Path;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;

public class P4Utils {
    private static Map<String, String> p4Escapes = new LinkedHashMap<String, String>();

    public static String getServerPath(String basePathSpec, Path localPath) {
        String path = localPath.isRoot() ? basePathSpec : basePathSpec + "/" + localPath.getPath();
        Object[] escapes = p4Escapes.entrySet().toArray();
        for (int i2 = escapes.length - 1; i2 >= 0; --i2) {
            Map.Entry escape = (Map.Entry)escapes[i2];
            path = path.replace((CharSequence)escape.getValue(), (CharSequence)escape.getKey());
        }
        return path;
    }

    public static Path getLocalPath(Path basePath, boolean caseSensitive, String p4Path) {
        String pathString = p4Path.substring(1);
        for (Map.Entry<String, String> entry : p4Escapes.entrySet()) {
            pathString = pathString.replace(entry.getKey().toLowerCase(Locale.US), entry.getValue());
            pathString = pathString.replace(entry.getKey().toUpperCase(Locale.US), entry.getValue());
        }
        Path path = new Path(pathString);
        return path.getRelativePath(basePath, caseSensitive);
    }

    static {
        p4Escapes.put("%40", "@");
        p4Escapes.put("%23", "#");
        p4Escapes.put("%2A", "*");
        p4Escapes.put("%25", "%");
    }
}

