/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.atlassian.fecru.upgrade.UpgradeManager;
import com.atlassian.fisheye.scmapi.BaseScmConfig;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.ScmType;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.config.RootConfig;
import com.cenqua.fisheye.config1.P4RepType;
import com.cenqua.fisheye.config1.RepositorySystemType;
import com.cenqua.fisheye.config1.UserPassAuthType;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.perforce.P4RepositoryEngine;
import com.cenqua.fisheye.perforce.P4RepositoryInfo;
import com.cenqua.fisheye.perforce.client.P4Client;
import com.cenqua.fisheye.perforce.client.P4ClientException;
import com.cenqua.fisheye.perforce.client.P4Exec;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.NetworkRepositorySettings;
import com.cenqua.fisheye.util.Interval;
import com.cenqua.fisheye.util.Throttle;
import com.google.common.base.Strings;
import java.util.Map;

public class P4ScmConfig
extends BaseScmConfig {
    private static final int DEFAULT_P4_PORT = 1666;
    public static final String DEFAULT_ENCODING = System.getProperty("file.encoding");
    public static final int CACHE_VERSION = 12;
    private String server;
    private int port;
    private String path;
    private boolean isUnicode;
    private String encoding;
    private long blocksize;
    private boolean caseSensitive;
    private int maxFilelogs;
    private Interval commandTimeout;
    private NetworkRepositorySettings networkSettings;
    private boolean skipLabels;
    private long startRev;
    private boolean initialImport;
    private boolean multiPrintEnabled;
    private final P4RepType p4Config;

    public P4ScmConfig(String name, RootConfig rootConfig, RepositorySystemType scmConfig) {
        super(12, rootConfig);
        this.p4Config = (P4RepType)scmConfig;
        this.server = this.p4Config.getServer();
        this.port = this.p4Config.isSetPort() ? this.p4Config.getPort().intValue() : 1666;
        this.path = this.p4Config.getPath();
        boolean bl = this.isUnicode = this.p4Config.isSetUnicode() && this.p4Config.getUnicode();
        this.encoding = this.isUnicode ? "UTF-8" : (this.p4Config.isSetCharset() ? this.p4Config.getCharset() : DEFAULT_ENCODING);
        this.skipLabels = this.p4Config.isSetSkipLabels() ? this.p4Config.getSkipLabels() : false;
        this.blocksize = this.p4Config.isSetBlocksize() ? this.p4Config.getBlocksize().longValue() : 200L;
        UserPassAuthType auth = this.p4Config.isSetAuth() ? this.p4Config.getAuth() : null;
        float cpsLimit = this.p4Config.isSetCps() ? this.p4Config.getCps() : 0.0f;
        if (this.p4Config.isSetStartRev()) {
            this.startRev = this.p4Config.getStartRev().longValue();
            this.initialImport = this.p4Config.getInitialImport();
        } else {
            this.startRev = 0L;
            this.initialImport = false;
        }
        this.networkSettings = new NetworkRepositorySettings(auth, this.parseUpdateSettings(), cpsLimit);
        this.caseSensitive = !this.p4Config.isSetCasesensitive() || this.p4Config.getCasesensitive();
        this.maxFilelogs = this.p4Config.isSetFileloglimit() ? this.p4Config.getFileloglimit().intValue() : -1;
        if (this.p4Config.isSetCommandTimeout() && !Strings.isNullOrEmpty((String)this.p4Config.getCommandTimeout().trim())) {
            String commandTimeoutStr = this.p4Config.getCommandTimeout();
            try {
                this.commandTimeout = new Interval(commandTimeoutStr, 2);
            }
            catch (NumberFormatException e2) {
                this.setConfigException("Command timeout interval is not valid: " + commandTimeoutStr);
            }
        } else {
            this.commandTimeout = null;
        }
        this.multiPrintEnabled = !this.p4Config.getDisableMulti();
    }

    @Override
    public void reloadUpdateSettings() {
        String pollPeriod = this.parseUpdateSettings();
        this.networkSettings.setPollPeriod(pollPeriod);
    }

    private String parseUpdateSettings() {
        String pollPeriod = null;
        if (this.p4Config.isSetUpdater()) {
            pollPeriod = this.p4Config.getUpdater().getPollPeriod();
        } else if (this.defaults != null && this.defaults.isSetUpdater()) {
            pollPeriod = this.defaults.getUpdater().getPolled().getPollPeriod();
        }
        return pollPeriod;
    }

    @Override
    public P4RepositoryEngine createRepositoryEngine(RepositoryConfig repoConfig, UpgradeManager upgradeManager, IndexingContext indexingContext) {
        return new P4RepositoryEngine(repoConfig, upgradeManager, indexingContext);
    }

    @Override
    public void testConnection(RepositoryConfig config) throws ConfigException {
        this.testConnection(new P4RepositoryInfo(config));
    }

    public void testConnection(P4RepositoryInfo info) throws ConfigException {
        P4Exec.testP4Env(info, true);
        try {
            P4Client client = new P4Client(info, new Throttle(), null);
            Map<String, String> serverInfo = client.info();
            if (serverInfo == null || serverInfo.isEmpty()) {
                throw new ConfigException("Unable to get server information");
            }
            Logs.APP_LOG.info((Object)("Perforce Server Version: " + serverInfo.get("serverVersion")));
            Logs.APP_LOG.info((Object)("Perforce Server Time: " + serverInfo.get("serverDate")));
            client.getLatestRevision();
        }
        catch (P4ClientException e2) {
            throw new ConfigException("Problem communicating with repository : " + e2.getMessage(), e2);
        }
    }

    @Override
    public ScmType getRepositoryType() {
        return ScmType.P4;
    }

    public NetworkRepositorySettings getNetworkSettings() {
        return this.networkSettings;
    }

    public String getServer() {
        return this.server;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isUnicodeServer() {
        return this.isUnicode;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public long getBlocksize() {
        return this.blocksize;
    }

    public boolean isCaseSensitive() {
        return this.caseSensitive;
    }

    public boolean isSkipLabels() {
        return this.skipLabels;
    }

    public long getStartRev() {
        return this.startRev;
    }

    public boolean isInitialImport() {
        return this.initialImport;
    }

    public int getMaxFilelogs() {
        return this.maxFilelogs;
    }

    public Interval getCommandTimeout() {
        return this.commandTimeout;
    }

    public String getRepositoryDescriptor() {
        return this.getServer() + ":" + this.getPort() + this.getPath();
    }

    public boolean isMultiPrintEnabled() {
        return this.multiPrintEnabled;
    }
}

