/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.atlassian.fecru.util.EggTimer;
import com.atlassian.fisheye.RuntimeWrappedException;
import com.atlassian.fisheye.spi.admin.data.ImportMode;
import com.atlassian.utils.process.Watchdog;
import com.cenqua.fisheye.FishEyeSysProps;
import com.cenqua.fisheye.LicensePolicyException;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.cache.RevisionCache;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.diff.Hunk;
import com.cenqua.fisheye.io.IOHelper;
import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.perforce.P4BranchSpec;
import com.cenqua.fisheye.perforce.P4Cache;
import com.cenqua.fisheye.perforce.P4ChangeSetAncestryProcessor;
import com.cenqua.fisheye.perforce.P4ChangeSetImpl;
import com.cenqua.fisheye.perforce.P4MultiLineCountStream;
import com.cenqua.fisheye.perforce.P4RepoBranches;
import com.cenqua.fisheye.perforce.P4RepositoryEngine;
import com.cenqua.fisheye.perforce.P4RepositoryInfo;
import com.cenqua.fisheye.perforce.client.P4ChangeList;
import com.cenqua.fisheye.perforce.client.P4ChangePath;
import com.cenqua.fisheye.perforce.client.P4Client;
import com.cenqua.fisheye.perforce.client.P4ClientException;
import com.cenqua.fisheye.perforce.client.P4FileSpec;
import com.cenqua.fisheye.perforce.client.P4Fix;
import com.cenqua.fisheye.perforce.client.P4InputDemuxer;
import com.cenqua.fisheye.perforce.client.P4Job;
import com.cenqua.fisheye.perforce.client.P4Label;
import com.cenqua.fisheye.perforce.client.P4Visitor;
import com.cenqua.fisheye.perforce.db.P4ChangeSetDAO;
import com.cenqua.fisheye.perforce.db.P4RevInfo;
import com.cenqua.fisheye.perforce.db.P4RevInfoDAO;
import com.cenqua.fisheye.rep.AncestorLink;
import com.cenqua.fisheye.rep.Branch;
import com.cenqua.fisheye.rep.ChangeSet;
import com.cenqua.fisheye.rep.ChangeSetResolver;
import com.cenqua.fisheye.rep.ChangesetProcessor;
import com.cenqua.fisheye.rep.CommonProperties;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.IndexingState;
import com.cenqua.fisheye.rep.LifecycleRepositoryScanner;
import com.cenqua.fisheye.rep.RepositoryClientException;
import com.cenqua.fisheye.rep.RepositoryInfo;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.rep.RevListCache;
import com.cenqua.fisheye.rep.RevidChangeSet;
import com.cenqua.fisheye.util.LineCountingInputStream;
import com.cenqua.fisheye.util.ReversedLongSortedSet;
import com.cenqua.fisheye.util.Timer;
import com.cenqua.fisheye.util.bitset.BitSets;
import com.cenqua.fisheye.util.bitset.SegmentedIntSet;
import com.cenqua.fisheye.util.bitset.SortedIntSet;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.longs.Long2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectSortedMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongLinkedOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSortedSet;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;

public class P4Scanner
extends LifecycleRepositoryScanner<P4Cache> {
    private static final int MAX_DELETE_SIZE = 1000;
    private static final int BATCH_SIZE = 400;
    private static final int ADDEDFILE_BATCHSIZE = 2000;
    private final RevListCache<P4ChangeList> revListCache = new RevListCache();
    private final P4RepositoryInfo p4RepInfo;
    protected P4RevInfoDAO fileRevDao;
    protected P4Client client;
    private P4Cache cache;
    private P4RepoBranches repoBranches = null;
    private P4ChangeSetDAO csDAO;
    private ChangesetProcessor ancestryProcessor;
    private long commitBlockSize = 100L;
    private volatile long latestRevision = -1L;

    public P4Scanner(P4RepositoryEngine engine) {
        super(engine);
        this.p4RepInfo = engine.getRepoInfo();
        this.setCommitBlockSize(200L);
    }

    @Override
    public void start(P4Cache cache) throws DbException, ConfigException {
        super.start(cache);
        this.cache = cache;
        this.fileRevDao = cache.getFileRevisionDAO();
        this.csDAO = cache.getChangeSetDAO();
        this.ancestryProcessor = new P4ChangeSetAncestryProcessor(cache);
    }

    private P4RepoBranches getRepoBranchCache() {
        if (this.repoBranches == null) {
            this.repoBranches = new P4RepoBranches(this.fileRevDao, this);
        }
        return this.repoBranches;
    }

    public P4Client getClient() {
        if (this.client == null) {
            this.client = this.cache.allocateClient();
        }
        return this.client;
    }

    private Long2ObjectMap<P4ChangeList> getRevList(long startRevision, long endRevision) throws RepositoryClientException {
        long blockEnd;
        Long2ObjectSortedMap<P4ChangeList> result = null;
        long blockStart = startRevision;
        long blockLookAhead = 8192L;
        do {
            blockEnd = endRevision > blockStart + blockLookAhead ? blockStart + blockLookAhead - 1L : endRevision;
            try {
                boolean storeDiffs = this.getFeatures().isStoreDiffs();
                Long2ObjectSortedMap<P4ChangeList> revs = this.getClient().getChangeLists(blockStart, blockLookAhead, blockEnd, false, storeDiffs, null);
                if (result == null) {
                    result = revs;
                } else {
                    result.putAll(revs);
                }
                blockStart = blockEnd + 1L;
                if (blockLookAhead >= 8192L) continue;
                blockLookAhead <<= 1;
            }
            catch (P4ClientException e2) {
                Logs.APP_LOG.warn((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Unable to get revlist due to:" + e2.getMessage()));
                blockLookAhead >>= 2;
                blockEnd = blockStart;
            }
        } while (blockLookAhead != 0L && (result == null || (long)result.size() < this.getCommitBlockSize()) && blockEnd < endRevision);
        if (blockLookAhead == 0L) {
            throw new P4ClientException("Unable to get P4 changelists");
        }
        return result;
    }

    @Override
    protected void validateRepository() throws ConfigException {
        this.p4RepInfo.testConnection();
    }

    private long slurpRevisionBlock(long startRevision, long endRevision) throws RepositoryClientException, DbException {
        Timer timer = new Timer("Slurping from " + startRevision + " to " + endRevision);
        long lastProcessed = -1L;
        if (!FishEyeSysProps.P4_BRANCH_SPEC_DISABLE) {
            this.getRepoBranchCache().updateBranchMappings();
        }
        Long2ObjectSortedMap<P4ChangeList> changeLists = this.client.getChangeLists(startRevision, 0L, endRevision, true, this.getFeatures().isStoreDiffs(), this.getDiffTextCache());
        Map<String, P4Job> jobInfo = this.getJobInfo((Long2ObjectMap<P4ChangeList>)changeLists);
        if (changeLists.size() != 0) {
            long firstFetched = changeLists.firstLongKey();
            long lastFetched = changeLists.lastLongKey();
            this.getStatus().setMessage("Processing changelists " + firstFetched + " to " + lastFetched);
            for (P4ChangeList changeList : changeLists.values()) {
                if (this.getStatus().isStopRequested()) break;
                try {
                    this.processChangeList(changeList, false);
                    lastProcessed = changeList.getId();
                    this.clearLicensePolicyReached();
                }
                catch (LicensePolicyException e2) {
                    this.setLicensePolicyReached(e2);
                    break;
                }
            }
        }
        this.getDiffTextCache().clear();
        if (!jobInfo.isEmpty() && !this.getStatus().isStopRequested()) {
            for (Map.Entry<String, P4Job> entry : jobInfo.entrySet()) {
                this.fileRevDao.updateJob(entry.getValue());
            }
        }
        timer.end();
        return lastProcessed;
    }

    private int insertNewRevision(P4RevInfo revInfo, AncestorLink ancestor) throws DbException, LicensePolicyException {
        this.createParentDir(revInfo.getPath().getParent());
        int revid = this.fileRevDao.insertNew(revInfo, ancestor, this.getFeatures().isStoreDiffs());
        if (this.getFeatures().isStoreDiffs()) {
            this.getRepositoryIndexer().indexDiffText(revInfo, revid, this.getDiffTextCache(), this.fileRevDao.getCommonRevInfoDAO());
        }
        return revid;
    }

    private P4RevInfo createFileRevision(P4ChangeList changeList, P4ChangePath changePath) {
        Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Creating revision for " + changePath.getFileSpec() + "@" + changeList.getId()));
        P4RevInfo revision = new P4RevInfo();
        revision.setP4ChangeSetId(changeList.getId());
        revision.setAuthor(changeList.getAuthor());
        revision.setDate(changeList.getDate());
        revision.setComment(changeList.getComment());
        revision.setPath(this.getRepositoryInfo().getLocalPath(changePath.getPath(), changeList.getId()));
        revision.setTrunkLike(true);
        revision.setHunks(changePath.getHunks());
        revision.setTmpDiffAddedFile(changePath.getTmpDiffAddedFile());
        revision.setTmpDiffRemovedFile(changePath.getTmpDiffRemovedFile());
        revision.setLinesAdded(changePath.getNumAdded());
        revision.setLinesRemoved(changePath.getNumRemoved());
        revision.setUnicode(changePath.getFileType().equals("unicode"));
        revision.setBinary(changePath.isBinary());
        revision.setFileType(1);
        revision.setFileRev(changePath.getFileRev());
        revision.setFileSize(changePath.getFileSize());
        revision.setP4FileType(changePath.getFileType());
        revision.addBranch(this.getRepoBranchCache().getChangePathBranch(changePath));
        for (P4Fix fix : changeList.getFixes()) {
            revision.addFixedJob(fix.getJobName());
        }
        if (changePath.getFileSize() > this.getRepositoryConfig().getMaxIndexableSize()) {
            revision.setOversize(true);
        }
        return revision;
    }

    private void processChangeList(P4ChangeList changeList, boolean importMode) throws DbException, P4ClientException, LicensePolicyException {
        Timer timer = new Timer("Processing changelist " + changeList.getId());
        this.getStatus().setMessage("Processing changelist " + changeList.getId());
        HashSet<String> branches = new HashSet<String>();
        this.processFileRevisions(changeList, importMode, branches);
        this.processChangeSet(changeList, branches);
        timer.end();
    }

    private boolean shouldProcessChangeSet(P4ChangeList changeList) throws DbException {
        IntList revids = this.fileRevDao.getChangeSetRevids(Long.toString(changeList.getId()));
        return revids != null && !revids.isEmpty();
    }

    private void processChangeSet(P4ChangeList changeList, Set<String> branches) throws DbException, LicensePolicyException {
        if (this.shouldProcessChangeSet(changeList)) {
            P4ChangeSetImpl changeset = new P4ChangeSetImpl(changeList.getId(), this.csDAO, this.fileRevDao);
            changeset.setAuthor(changeList.getAuthor());
            changeset.setComment(changeList.getComment());
            changeset.setDate(changeList.getDate());
            ArrayList<String> csBranches = new ArrayList<String>(branches.size());
            csBranches.addAll(branches);
            changeset.setBranches(csBranches);
            this.ancestryProcessor.process(changeset);
            this.csDAO.store(changeset);
            for (String branchName : branches) {
                if (!StringUtils.isNotEmpty((String)branchName)) continue;
                Branch branch = new Branch(branchName, changeset.getId(), null);
                ((P4Cache)this.getCache()).storeBranch(branch);
            }
        } else if (Logs.APP_LOG.isDebugEnabled()) {
            Logs.APP_LOG.debug((Object)String.format("[%s]: Ignoring changeset %d; it does not contain any file revisions in the watched area", this.getRepositoryInfo().getName(), changeList.getId()));
        }
    }

    private void processFileRevisions(P4ChangeList changeList, boolean importMode, Set<String> branches) throws DbException, P4ClientException, LicensePolicyException {
        HashMap<P4FileSpec, P4ChangePath> addedFiles = new HashMap<P4FileSpec, P4ChangePath>();
        for (P4ChangePath changePath : changeList.getChangePaths()) {
            long changeListId;
            long l2 = changeListId = importMode ? this.getRepositoryInfo().getStartRev() : changeList.getId();
            if (!this.getRepositoryInfo().isPathInRepo(changePath.getPath(), changeListId)) continue;
            P4RevInfo revInfo = this.createFileRevision(changeList, changePath);
            this.processAction(changeList, changePath, revInfo, addedFiles);
            branches.add(revInfo.getBranch());
        }
        do {
            if (addedFiles.size() < 2000) {
                this.updateAddedFileLineCounts(changeList.getId(), addedFiles);
                addedFiles.clear();
                continue;
            }
            HashMap<P4FileSpec, P4ChangePath> batch = new HashMap<P4FileSpec, P4ChangePath>();
            int count = 0;
            Iterator i2 = addedFiles.entrySet().iterator();
            while (i2.hasNext()) {
                Map.Entry entry = i2.next();
                batch.put((P4FileSpec)entry.getKey(), (P4ChangePath)entry.getValue());
                i2.remove();
                if (++count < 2000) continue;
                break;
            }
            this.updateAddedFileLineCounts(changeList.getId(), batch);
        } while (!addedFiles.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateAddedFileLineCounts(final long csid, final Map<P4FileSpec, P4ChangePath> addedFiles) throws P4ClientException {
        HashMap<P4FileSpec, P4ChangePath> files;
        HashMap<P4FileSpec, P4ChangePath> nonStreamFiles;
        HashMap<P4FileSpec, P4ChangePath> multiStreamFiles;
        block12: {
            if (addedFiles.isEmpty()) {
                return;
            }
            final HashSet processedFiles = new HashSet();
            final HashSet duplicateFiles = new HashSet();
            multiStreamFiles = new HashMap<P4FileSpec, P4ChangePath>();
            nonStreamFiles = new HashMap<P4FileSpec, P4ChangePath>();
            for (Map.Entry<P4FileSpec, P4ChangePath> entry : addedFiles.entrySet()) {
                String fileType = entry.getValue().getFileType();
                if (!fileType.equals("unicode") && !fileType.equals("utf16")) {
                    multiStreamFiles.put(entry.getKey(), entry.getValue());
                    continue;
                }
                nonStreamFiles.put(entry.getKey(), entry.getValue());
            }
            final P4MultiLineCountStream output = new P4MultiLineCountStream(multiStreamFiles, this.getDiffTextCache(), csid, new P4MultiLineCountStream.CountVisitor(){

                @Override
                public void visit(P4FileSpec file, int count) {
                    if (processedFiles.contains(file)) {
                        duplicateFiles.add(file);
                    } else {
                        processedFiles.add(file);
                        try {
                            P4Scanner.this.updateLineCount(file, count, csid, (P4ChangePath)addedFiles.get(file));
                        }
                        catch (DbException e2) {
                            Logs.APP_LOG.warn((Object)("[" + P4Scanner.this.getRepositoryInfo().getRepositoryDescriptor() + "] Unable to update line count for : " + file));
                        }
                    }
                }
            });
            if (!this.p4RepInfo.isMultiPrintEnabled()) break block12;
            try {
                this.getClient().streamMultipleContent(multiStreamFiles.keySet(), new P4Visitor.ProcessOutputVisitor(){

                    @Override
                    public void visit(Watchdog watchdog, InputStream is, String encoding) throws RuntimeWrappedException {
                        try {
                            IOHelper.copyStream(is, (OutputStream)output);
                        }
                        catch (IOException e2) {
                            try {
                                throw new RuntimeWrappedException(e2);
                            }
                            catch (Throwable throwable) {
                                IOHelper.close(is);
                                throw throwable;
                            }
                        }
                        IOHelper.close(is);
                    }
                });
            }
            catch (P4ClientException e2) {
                try {
                    Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Multiple streaming failed"), (Throwable)e2);
                }
                catch (Throwable throwable) {
                    IOHelper.close(output);
                    throw throwable;
                }
                IOHelper.close(output);
            }
            IOHelper.close(output);
            this.getDiffTextCache().finishFileRevision();
            processedFiles.removeAll(duplicateFiles);
            multiStreamFiles.keySet().removeAll(processedFiles);
        }
        if (!(files = !multiStreamFiles.isEmpty() ? new HashMap<P4FileSpec, P4ChangePath>(addedFiles) : new HashMap(nonStreamFiles)).isEmpty()) {
            for (Map.Entry entry : files.entrySet()) {
                final P4FileSpec file = (P4FileSpec)entry.getKey();
                final P4ChangePath changePath = (P4ChangePath)entry.getValue();
                try {
                    this.getClient().streamContent(file, null, new P4Visitor.ProcessOutputVisitor(){

                        @Override
                        public void visit(Watchdog watchdog, InputStream is, String encoding) throws RuntimeWrappedException {
                            String fileType;
                            LineCountingInputStream.CharMode charMode = LineCountingInputStream.CharMode.BYTES;
                            if (!P4Scanner.this.p4RepInfo.isUnicode() && (fileType = changePath.getFileType()).equals("unicode")) {
                                charMode = LineCountingInputStream.CharMode.BOM;
                            }
                            P4Scanner.this.getDiffTextCache().startFileRevision(true, changePath);
                            LineCountingInputStream lcis = new LineCountingInputStream(is, charMode, P4Scanner.this.getDiffTextCache());
                            try {
                                lcis.readFully();
                                if (files.containsKey(file)) {
                                    P4Scanner.this.updateLineCount(file, lcis.getLineCount(), csid, (P4ChangePath)files.get(file));
                                }
                            }
                            catch (Exception e2) {
                                try {
                                    throw new RuntimeWrappedException(e2);
                                }
                                catch (Throwable throwable) {
                                    IOHelper.close(lcis);
                                    throw throwable;
                                }
                            }
                            IOHelper.close(lcis);
                            P4Scanner.this.getDiffTextCache().finishFileRevision();
                        }
                    });
                }
                catch (RuntimeWrappedException e3) {
                    Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Unable to get content for " + file), (Throwable)e3);
                }
                catch (P4ClientException e4) {
                    Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Unable to get content for " + file), (Throwable)e4);
                }
            }
        }
    }

    private void updateLineCount(P4FileSpec p4FileSpec, int lineCount, long csid, P4ChangePath p4ChangePath) throws DbException {
        Path repoPath = this.getRepositoryInfo().getLocalPath(p4FileSpec.getPath(), csid);
        RevInfoKey key = new RevInfoKey(repoPath, Long.toString(csid));
        this.fileRevDao.updateLineCount(key, lineCount, lineCount, 0);
        this.fileRevDao.getCommonRevInfoDAO().updateTmpDiffAddedFile(key, p4ChangePath.getTmpDiffAddedFile());
        if (this.getFeatures().isStoreDiffs()) {
            Hunk hunk = new Hunk(0, 0, 0, lineCount);
            this.fileRevDao.addHunk(key, hunk);
        }
    }

    private Map<String, P4Job> getJobInfo(Long2ObjectMap<P4ChangeList> changeLists) throws P4ClientException {
        HashMap<String, P4Job> jobs = new HashMap<String, P4Job>();
        for (P4ChangeList changeList : changeLists.values()) {
            for (P4Fix p4Fix : changeList.getFixes()) {
                String jobName = p4Fix.getJobName();
                if (jobs.containsKey(jobName)) continue;
                jobs.put(jobName, this.getClient().getJob(jobName));
            }
        }
        return jobs;
    }

    private void processAction(P4ChangeList changeList, P4ChangePath changePath, P4RevInfo revInfo, Map<P4FileSpec, P4ChangePath> addedFiles) throws DbException, P4ClientException, LicensePolicyException {
        if (changePath.getAction() == null) {
            Logs.APP_LOG.error((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] No action on " + changePath + " in change list: " + changeList));
            return;
        }
        try {
            String action = changePath.getAction();
            if (action.equals("add")) {
                if (changePath.getIntegrationAction() != null && changePath.getIntegrationAction().equals("branch")) {
                    this.processBranch(changeList, changePath, revInfo, addedFiles);
                } else {
                    this.processAdd(changeList, changePath, revInfo, addedFiles);
                }
            } else if (action.equals("edit")) {
                this.processEdit(changeList, changePath, revInfo);
            } else if (action.equals("delete")) {
                this.processDelete(changeList, changePath, revInfo);
            } else if (action.equals("branch")) {
                this.processBranch(changeList, changePath, revInfo, addedFiles);
            } else if (action.equals("import")) {
                this.processIntegrate(changeList, changePath, revInfo, addedFiles);
            } else if (action.equals("integrate")) {
                this.processIntegrate(changeList, changePath, revInfo, addedFiles);
            } else if (action.equals("purge")) {
                this.processPurge(changeList, changePath, revInfo, addedFiles);
            } else if (action.equals("move/add")) {
                this.processAdd(changeList, changePath, revInfo, addedFiles);
            } else if (action.equals("move/delete")) {
                this.processDelete(changeList, changePath, revInfo);
            } else {
                Logs.APP_LOG.error((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Unknown action: " + changePath.getAction()));
            }
        }
        catch (DbException e2) {
            Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Error processing path " + changePath + " in change list " + changeList));
            throw e2;
        }
    }

    private void processPurge(P4ChangeList changeList, P4ChangePath changePath, P4RevInfo revInfo, Map<P4FileSpec, P4ChangePath> addedFiles) throws DbException, P4ClientException, LicensePolicyException {
        revInfo.setPurged(true);
        if (((P4Cache)this.getCache()).getLatestFileRevision(revInfo.getPath()) != null) {
            this.processEdit(changeList, changePath, revInfo);
        } else {
            this.processAdd(changeList, changePath, revInfo, addedFiles);
        }
    }

    protected Map<String, P4BranchSpec> getBranchSpecs() {
        return this.getRepoBranchCache().getBranchSpecs();
    }

    private void processAdd(P4ChangeList changeList, P4ChangePath changePath, P4RevInfo revInfo, Map<P4FileSpec, P4ChangePath> addedFiles) throws DbException, P4ClientException, LicensePolicyException {
        Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Processing add in " + changeList.getId() + " for " + changePath));
        revInfo.setAdded(true);
        AncestorLink ancestor = null;
        if (changePath.getSourceFileSpec() != null && changePath.getAction().equals("move/add")) {
            P4FileSpec sourceFileSpec = changePath.getSourceFileSpec();
            Path sourcePath = this.getRepositoryInfo().getLocalPath(sourceFileSpec.getPath(), changeList.getId());
            int previousRevid = this.fileRevDao.getRevIdByFileRev(sourcePath, sourceFileSpec.getFileRev());
            if (previousRevid != -1) {
                revInfo.setMove(true);
                ancestor = new AncestorLink(AncestorLink.Type.MOVE, previousRevid);
            }
        }
        if (!revInfo.isBinary()) {
            addedFiles.put(changePath.getFileSpec(), changePath);
        }
        revInfo.setLineCount(revInfo.getLinesAdded() - revInfo.getLinesRemoved());
        revInfo.setTmpDiffAddedFile(changePath.getTmpDiffAddedFile());
        revInfo.setTmpDiffAddedFile(changePath.getTmpDiffRemovedFile());
        this.insertNewRevision(revInfo, ancestor);
    }

    private void processBranch(P4ChangeList changeList, P4ChangePath changePath, P4RevInfo revInfo, Map<P4FileSpec, P4ChangePath> addedFiles) throws DbException, P4ClientException, LicensePolicyException {
        Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Processing branch in " + changeList.getId() + " for " + changePath));
        if (changePath.getSourceFileSpec() == null) {
            Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] No source path for branch to " + changePath + " in " + changeList.getId()));
            this.processAdd(changeList, changePath, revInfo, addedFiles);
        } else {
            String sourcePath = changePath.getSourceFileSpec().getPath();
            if (!this.getRepositoryInfo().isPathInRepo(sourcePath, changeList.getId())) {
                if (changePath.getFileRev() == 1) {
                    this.processAdd(changeList, changePath, revInfo, addedFiles);
                } else {
                    this.processEdit(changeList, changePath, revInfo);
                }
            } else {
                this.processCopy(changeList, changePath, revInfo, addedFiles);
            }
        }
    }

    private void processCopy(P4ChangeList changeList, P4ChangePath changePath, P4RevInfo revInfo, Map<P4FileSpec, P4ChangePath> addedFiles) throws DbException, P4ClientException, LicensePolicyException {
        int currentLineCount;
        AncestorLink.Type ancestorType;
        Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Processing copy in " + changeList.getId() + " for " + changePath));
        String sourcePath = changePath.getSourceFileSpec().getPath();
        P4ChangePath sourceChangePath = changeList.getChangePath(sourcePath);
        Path sourceRepoPath = this.getRepositoryInfo().getLocalPath(sourcePath, changeList.getId());
        int sourceRevId = this.fileRevDao.getRevIdByFileRev(sourceRepoPath, changePath.getSourceFileSpec().getFileRev());
        if (sourceRevId == -1) {
            Path destPath = this.getRepositoryInfo().getLocalPath(changePath.getPath(), changeList.getId());
            int latestRevId = this.fileRevDao.getLatestPathRevid(destPath);
            if (latestRevId == -1 || this.fileRevDao.isDeleted(latestRevId)) {
                this.processAdd(changeList, changePath, revInfo, addedFiles);
            } else {
                this.processEdit(changeList, changePath, revInfo);
            }
            return;
        }
        String sourceBranch = this.fileRevDao.getBranch(sourceRevId);
        Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] copy branch is " + sourceBranch));
        if (sourceChangePath != null && sourceChangePath.getAction().equals("delete")) {
            revInfo.setMove(true);
            ancestorType = AncestorLink.Type.MOVE;
        } else {
            revInfo.setCopy(true);
            ancestorType = sourceBranch.equals(revInfo.getBranch()) ? AncestorLink.Type.COPY : AncestorLink.Type.BRANCHPOINT;
        }
        Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] ancestorType is " + (Object)((Object)ancestorType)));
        int sourceLineCount = this.fileRevDao.getLineCount(sourceRevId);
        long lastCsid = this.fileRevDao.getLatestPathChange(revInfo.getPath());
        if (lastCsid != -1L) {
            int lastRevid = this.fileRevDao.getRevId(revInfo.getPath(), lastCsid);
            if (this.fileRevDao.isDeleted(lastRevid)) {
                revInfo.setAdded(true);
                currentLineCount = 0;
            } else {
                currentLineCount = this.fileRevDao.getLineCount(lastRevid);
            }
        } else {
            revInfo.setAdded(true);
            currentLineCount = 0;
        }
        Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] last change for path " + lastCsid));
        revInfo.setLineCount(sourceLineCount);
        revInfo.setLinesAdded(sourceLineCount - currentLineCount);
        Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] src line count " + sourceLineCount));
        if (revInfo.isAdded()) {
            revInfo.createAdditionHunk();
        }
        AncestorLink ancestor = new AncestorLink(ancestorType, sourceRevId);
        Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] inserting new revision for " + changePath));
        int newRevid = this.insertNewRevision(revInfo, ancestor);
        Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] inserted new revision for " + changePath + ", rev id = " + newRevid));
    }

    private void processDelete(P4ChangeList changeList, P4ChangePath changePath, P4RevInfo revInfo) throws DbException, LicensePolicyException {
        Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Processing delete in " + changeList.getId() + " for " + changePath));
        int previousRevid = this.fileRevDao.getRevIdByFileRev(revInfo.getPath(), revInfo.getFileRev() - 1);
        revInfo.setLineCount(0);
        revInfo.setDead(true);
        if (changePath.getSourceFileSpec() != null && changePath.getAction().equals("move/delete")) {
            revInfo.setMove(true);
        }
        AncestorLink ancestor = null;
        if (previousRevid == -1) {
            Logs.APP_LOG.warn((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Processing a delete with no previous revision at " + changeList.getId() + " for " + changePath));
        } else {
            ancestor = new AncestorLink(AncestorLink.Type.DIRECT, previousRevid);
            int oldLineCount = this.fileRevDao.getLineCount(previousRevid);
            revInfo.setLinesRemoved(oldLineCount);
            revInfo.createDeletedHunk();
        }
        revInfo.setTmpDiffAddedFile(changePath.getTmpDiffAddedFile());
        revInfo.setTmpDiffAddedFile(changePath.getTmpDiffRemovedFile());
        this.insertNewRevision(revInfo, ancestor);
    }

    private void processIntegrate(P4ChangeList changeList, P4ChangePath changePath, P4RevInfo revInfo, Map<P4FileSpec, P4ChangePath> addedFiles) throws DbException, P4ClientException, LicensePolicyException {
        Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Processing integrate in " + changeList.getId() + " for " + changePath));
        if (changePath.getFileRev() == 1) {
            P4FileSpec sourceFileSpec = changePath.getSourceFileSpec();
            if (sourceFileSpec == null || !this.getRepositoryInfo().isPathInRepo(sourceFileSpec.getPath(), changeList.getId())) {
                this.processAdd(changeList, changePath, revInfo, addedFiles);
            } else {
                this.processCopy(changeList, changePath, revInfo, addedFiles);
            }
        } else {
            String integrationAction = changePath.getIntegrationAction();
            if (integrationAction == null || integrationAction.equals("merge")) {
                this.processEdit(changeList, changePath, revInfo);
            } else if (integrationAction.equals("copy")) {
                String sourcePath = changePath.getSourceFileSpec().getPath();
                if (!this.getRepositoryInfo().isPathInRepo(sourcePath, changeList.getId())) {
                    this.processEdit(changeList, changePath, revInfo);
                } else {
                    this.processCopy(changeList, changePath, revInfo, addedFiles);
                }
            } else if (integrationAction.equals("edit")) {
                this.processEdit(changeList, changePath, revInfo);
            } else if (integrationAction.equals("branch")) {
                this.processBranch(changeList, changePath, revInfo, addedFiles);
            } else if (integrationAction.equals("delete")) {
                this.processDelete(changeList, changePath, revInfo);
            } else {
                Logs.APP_LOG.error((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Unknown integration action: " + integrationAction));
            }
        }
    }

    private void processEdit(P4ChangeList changeList, P4ChangePath changePath, P4RevInfo revInfo) throws DbException, P4ClientException, LicensePolicyException {
        Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Processing edit in " + changeList.getId() + " for " + changePath));
        int previousRevid = this.fileRevDao.getRevIdByFileRev(revInfo.getPath(), revInfo.getFileRev() - 1);
        AncestorLink ancestor = null;
        int oldLineCount = 0;
        if (previousRevid != -1 && !this.fileRevDao.isDeleted(previousRevid)) {
            ancestor = new AncestorLink(AncestorLink.Type.DIRECT, previousRevid);
            oldLineCount = this.fileRevDao.getLineCount(previousRevid);
        }
        revInfo.setLineCount(oldLineCount + revInfo.getLinesAdded() - revInfo.getLinesRemoved());
        revInfo.setTmpDiffAddedFile(changePath.getTmpDiffAddedFile());
        revInfo.setTmpDiffRemovedFile(changePath.getTmpDiffRemovedFile());
        revInfo.setModify(true);
        this.insertNewRevision(revInfo, ancestor);
    }

    private boolean processTags() throws RepositoryClientException, DbException {
        final boolean[] changed = new boolean[]{false};
        P4RepositoryInfo repoInfo = (P4RepositoryInfo)this.getRepositoryInfo();
        if (!repoInfo.isSkipLabels()) {
            this.getStatus().setMessage("Processing labels");
            try {
                final int[] count = new int[1];
                this.getClient().visitLabels(this.getRepositoryInfo().getIncludedPaths(), new P4Visitor.LabelVisitor(){

                    @Override
                    public void visit(P4Label label) {
                        count[0] = count[0] + 1;
                        try {
                            final String tag = label.getName();
                            if (tag.contains("#")) {
                                Logs.APP_LOG.warn((Object)("[" + P4Scanner.this.getRepositoryInfo().getRepositoryDescriptor() + "] Skipping label with # character: " + tag));
                                return;
                            }
                            long accessTime = P4Scanner.this.fileRevDao.getTagUpdateTime(tag);
                            if (accessTime == -1L || label.getAccessTime() > accessTime) {
                                changed[0] = true;
                                P4Scanner.this.fileRevDao.removeTag(tag);
                                P4Scanner.this.getClient().visitLabelFiles(tag, new P4Visitor.FileVisitor(){

                                    @Override
                                    public void visit(P4FileSpec fileSpec) {
                                        Path path = P4Scanner.this.getRepositoryInfo().getLocalPath(fileSpec.getPath(), -1L);
                                        int revid = P4Scanner.this.fileRevDao.getRevIdByFileRev(path, fileSpec.getFileRev());
                                        P4Scanner.this.fileRevDao.addTag(revid, tag);
                                    }
                                });
                                label = P4Scanner.this.getClient().getLabel(label.getName());
                                P4Scanner.this.fileRevDao.setTagUpdateTime(label.getName(), label.getAccessTime());
                            }
                        }
                        catch (Exception e2) {
                            Logs.APP_LOG.warn((Object)"Problem visiting label", (Throwable)e2);
                            throw new RuntimeWrappedException(e2);
                        }
                    }
                });
                this.getStatus().setMessage("Processed " + count[0] + " labels");
            }
            catch (RuntimeWrappedException e2) {
                if (e2.getCause() instanceof RepositoryClientException) {
                    throw (RepositoryClientException)e2.getCause();
                }
                if (e2.getCause() instanceof DbException) {
                    throw (DbException)e2.getCause();
                }
                throw new DbException(e2);
            }
        }
        return changed[0];
    }

    private void createInitialImport(RevListCache<P4ChangeList> revListCache, final long startRevision) throws DbException, LicensePolicyException {
        this.getStatus().setMessage("Importing initial repository state");
        final P4RepositoryInfo repoInfo = (P4RepositoryInfo)this.getRepositoryInfo();
        try {
            TreeSet<Long> revs;
            SortedSet<Long> tail;
            boolean storeDiffs = this.getFeatures().isStoreDiffs();
            Long2ObjectSortedMap<P4ChangeList> changes = this.getClient().getChangeLists(startRevision, 1L, startRevision, true, storeDiffs, this.getDiffTextCache());
            P4ChangeList baseList = (P4ChangeList)changes.get(startRevision);
            if (baseList == null && !(tail = (revs = new TreeSet<Long>((SortedSet<Long>)(changes = this.getClient().getChangeLists(startRevision, 0L, this.getClient().getLatestRevision(), false, storeDiffs, this.getDiffTextCache())).keySet())).tailSet(startRevision)).isEmpty()) {
                long first = tail.first();
                changes = this.getClient().getChangeLists(first, 1L, first, true, storeDiffs, this.getDiffTextCache());
                baseList = (P4ChangeList)changes.get(first);
            }
            if (baseList != null) {
                final P4ChangeList changeList = new P4ChangeList(baseList.getId() - 1L);
                this.getClient().visitRevisionFiles(repoInfo.getBasePath(), changeList.getId(), new P4Visitor.FileVisitor(){

                    @Override
                    public void visit(P4FileSpec fileSpec) throws RuntimeWrappedException {
                        P4ChangePath changePath = new P4ChangePath(fileSpec);
                        if (repoInfo.isPathInRepo(changePath.getPath(), startRevision - 1L)) {
                            changeList.addChangePath(changePath);
                        }
                    }
                });
                changeList.setClient(baseList.getClient());
                changeList.setUser("no_author");
                changeList.setDate(baseList.getDate() - 1L);
                changeList.addComment("Created by FishEye for initial repository import");
                Long2ObjectAVLTreeMap changeLists = new Long2ObjectAVLTreeMap();
                changeLists.put(changeList.getId(), (Object)changeList);
                this.getClient().addChangeFileInfo((Long2ObjectSortedMap<P4ChangeList>)changeLists, true);
                this.processChangeList(changeList, true);
            }
        }
        catch (P4ClientException e2) {
            throw new DbException(e2);
        }
    }

    private SortedIntSet getPhysicalPaths(long startRevision, long endRevision) throws DbException {
        SortedIntSet revids = this.fileRevDao.getRevidsInChangeSetRange(startRevision, endRevision);
        return this.fileRevDao.getPaths(revids);
    }

    private void indexUpdatedContent(SortedIntSet physicalPaths) throws DbException, IOException {
        int pathIndex = 0;
        int count = physicalPaths.cardinality();
        Object2LongOpenHashMap contentBlock = new Object2LongOpenHashMap();
        int contentBlockSize = 0;
        HashMap<P4FileSpec, P4RevInfo> revInfoMap = new HashMap<P4FileSpec, P4RevInfo>();
        int physicalPathId = physicalPaths.nextSetBit(0);
        while (physicalPathId >= 0 && !this.getStatus().isStopRequested()) {
            long csid;
            ++pathIndex;
            Path path = this.fileRevDao.getPath(physicalPathId);
            int revid = this.fileRevDao.getRevId(path, csid = this.fileRevDao.getLatestPathChange(path));
            P4RevInfo revision = this.fileRevDao.load(revid);
            if (revision == null || revision.isBinary() || revision.isDead()) {
                Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] " + "Not indexing contents of HEAD of " + path + " as file is binary or deleted"));
            } else if (revision.getFileType() != 1) {
                Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] " + "Not indexing contents of HEAD of " + path + " as this is not a file"));
            } else if (this.getRepositoryInfo().isOfIndexableSize(path, revision.getFileSize(), revision.getDisplayRevision())) {
                this.getStatus().setMessage("Indexing content: " + path + " (" + pathIndex + " of " + count + ")");
                String serverPath = this.getRepositoryInfo().getServerPath(revision.getPath(), csid);
                P4FileSpec fileSpec = new P4FileSpec(serverPath, revision.getFileRev());
                contentBlock.put((Object)fileSpec, revision.getFileSize());
                revInfoMap.put(fileSpec, revision);
                if (contentBlock.size() >= this.getClient().getMaxPrint() || (contentBlockSize += (int)revision.getFileSize()) >= this.getClient().getMaxPrintBytes()) {
                    this.indexContentBlock((Object2LongMap<P4FileSpec>)contentBlock, revInfoMap);
                    contentBlock.clear();
                    contentBlockSize = 0;
                    revInfoMap.clear();
                    ((P4Cache)this.getCache()).setScanProperty(CommonProperties.CONTENT_LASTPATHID.value, physicalPathId);
                    ((P4Cache)this.getCache()).commit();
                    BitSets.clear(physicalPaths, 0L, physicalPathId);
                }
            }
            physicalPathId = physicalPaths.nextSetBit(physicalPathId + 1);
        }
        this.indexContentBlock((Object2LongMap<P4FileSpec>)contentBlock, revInfoMap);
        ((P4Cache)this.getCache()).setScanProperty(CommonProperties.CONTENT_LASTPATHID.value, -1L);
        ((P4Cache)this.getCache()).commit();
        BitSets.clear(physicalPaths, 0L, physicalPaths.length() + 1);
    }

    private void indexContentBlock(final Object2LongMap<P4FileSpec> contentMap, final Map<P4FileSpec, P4RevInfo> revInfoMap) {
        final HashSet processedFiles = new HashSet();
        final HashSet duplicateFiles = new HashSet();
        try {
            P4Visitor.ProcessOutputVisitor visitor = new P4Visitor.ProcessOutputVisitor(){

                @Override
                public void visit(Watchdog watchdog, InputStream is, String encoding) throws RuntimeWrappedException {
                    try {
                        P4InputDemuxer demuxer = new P4InputDemuxer(watchdog, is, (Object2LongMap<P4FileSpec>)contentMap, new P4InputDemuxer.Callback(){

                            @Override
                            public void processFile(P4FileSpec file, InputStream is) {
                                if (processedFiles.contains(file)) {
                                    duplicateFiles.add(file);
                                } else {
                                    try {
                                        processedFiles.add(file);
                                        BufferedReader in = new BufferedReader(new InputStreamReader(is));
                                        P4RevInfo revInfo = (P4RevInfo)revInfoMap.get(file);
                                        Logs.APP_LOG.debug((Object)("[" + P4Scanner.this.getRepositoryInfo().getRepositoryDescriptor() + "] Indexing streamed content of " + revInfo.getRevInfoKey()));
                                        P4Scanner.this.getRepositoryIndexer().indexContent(revInfo, in);
                                    }
                                    catch (Exception e2) {
                                        Logs.APP_LOG.warn((Object)("[" + P4Scanner.this.getRepositoryInfo().getRepositoryDescriptor() + "] Error indexing " + file), (Throwable)e2);
                                    }
                                }
                            }
                        });
                        demuxer.process();
                    }
                    catch (P4ClientException e2) {
                        throw new RuntimeWrappedException(e2);
                    }
                    catch (IOException e3) {
                        throw new RuntimeWrappedException(e3);
                    }
                }
            };
            if (this.p4RepInfo.isMultiPrintEnabled()) {
                this.getClient().streamMultipleContent((Set<P4FileSpec>)contentMap.keySet(), visitor);
                processedFiles.removeAll(duplicateFiles);
                revInfoMap.keySet().removeAll(processedFiles);
            }
            if (!revInfoMap.isEmpty()) {
                this.indexContentFileByFile(revInfoMap);
            }
        }
        catch (P4ClientException e2) {
            Logs.APP_LOG.warn((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Problem streaming content for indexing"), (Throwable)e2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexContentFileByFile(Map<P4FileSpec, P4RevInfo> revInfoMap) {
        for (Map.Entry<P4FileSpec, P4RevInfo> entry : revInfoMap.entrySet()) {
            File contentFile;
            block9: {
                contentFile = null;
                P4RevInfo revision = entry.getValue();
                try {
                    contentFile = File.createTempFile("fisheye", null, this.getRepositoryInfo().getRepoTempDir());
                    boolean exported = false;
                    try {
                        long csid = Long.parseLong(revision.getRevInfoKey().getRev());
                        String repoPath = this.getRepositoryInfo().getServerPath(revision.getPath(), csid);
                        exported = this.getClient().exportContent(repoPath, contentFile, revision.getP4ChangeSetId());
                    }
                    catch (RepositoryClientException e2) {
                        Logs.APP_LOG.warn((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Error exporting content for indexing"), (Throwable)e2);
                    }
                    if (!exported) {
                        Logs.APP_LOG.warn((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Skipping " + revision.getPath() + " as content is not available"));
                        break block9;
                    }
                    if (!contentFile.exists()) {
                        Logs.APP_LOG.error((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Not indexing contents of " + revision.getPath() + " because content was not exported"));
                        break block9;
                    }
                    Charset encoding = ((P4Cache)this.getCache()).getTextEncoding(revision.getRevInfoKey());
                    Logs.APP_LOG.debug((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Indexing content of " + revision.getRevInfoKey()));
                    this.getRepositoryIndexer().indexContent(revision, contentFile, encoding);
                }
                catch (Throwable e3) {
                    try {
                        Logs.APP_LOG.warn((Object)("[" + this.getRepositoryInfo().getRepositoryDescriptor() + "] Error indexing content for " + revision));
                    }
                    catch (Throwable throwable) {
                        IOHelper.deleteFile(contentFile);
                        throw throwable;
                    }
                    IOHelper.deleteFile(contentFile);
                    continue;
                }
            }
            IOHelper.deleteFile(contentFile);
        }
    }

    @Override
    public void stop() {
        if (this.client != null) {
            this.getClient().cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String updateChangesets(long start, long end) throws DbException, RepositoryClientException, LicensePolicyException {
        String resultMessage = null;
        boolean rollbackRequired = false;
        try {
            LongSet changesets = ((P4Cache)this.getCache()).getChangesets(start, end);
            long first = -1L;
            long last = -1L;
            rollbackRequired = true;
            LongIterator i2 = changesets.iterator();
            while (i2.hasNext()) {
                long csid = i2.nextLong();
                if (first == -1L || first > csid) {
                    first = csid;
                }
                if (last == -1L || last < csid) {
                    last = csid;
                }
                Logs.APP_LOG.debug((Object)("Updating revision:" + csid));
                P4ChangeSetImpl changeSet = ((P4Cache)this.getCache()).getChangeSet(Long.toString(csid));
                this.updateChangeSet((P4Cache)this.getCache(), changeSet);
            }
            if (first != -1L && last != -1L) {
                Logs.APP_LOG.debug((Object)String.format("Reindexing changesets %s - %s", first, last));
                this.indexChangeSets(first, last, true);
            } else {
                Logs.APP_LOG.info((Object)String.format("No changesets found to update between %s and %s", start, end));
            }
            ((P4Cache)this.getCache()).commit();
            rollbackRequired = false;
        }
        finally {
            if (rollbackRequired) {
                resultMessage = "Some updates were rolledback due to error";
                ((P4Cache)this.getCache()).rollback();
            }
        }
        return resultMessage;
    }

    private void updateChangeSet(P4Cache cache, P4ChangeSetImpl changeSet) throws P4ClientException, DbException, LicensePolicyException {
        P4ChangeList changeList = this.getClient().getChangeList(changeSet.getLongId());
        cache.updateChangeSet(changeSet, changeList);
    }

    @Override
    protected boolean updateLocalRepoClone() throws ConfigException {
        return false;
    }

    @Override
    protected void doSlurpTransaction(boolean updateOccurred) throws DbException, ConfigException {
        this.latestRevision = -1L;
        if (!updateOccurred) {
            try {
                this.latestRevision = this.getClient().getLatestRevision();
                if (this.latestRevision > this.csDAO.getLatestChangelistSeen()) {
                    updateOccurred = true;
                }
            }
            catch (P4ClientException e2) {
                Logs.APP_LOG.debug((Object)"Unable to get latest revision, forcing update", (Throwable)e2);
                updateOccurred = true;
            }
        }
        super.doSlurpTransaction(updateOccurred);
        this.csDAO.setLatestChangelistSeen(this.latestRevision);
    }

    @Override
    public long reindexChangesets(Long endChangesetP4Id, EggTimer eggTimer) throws DbException {
        int changesetCount;
        endChangesetP4Id = endChangesetP4Id == null ? this.getPhase1Revision() : endChangesetP4Id.longValue();
        long blockSize = 1000L;
        for (long endBatchP4Id = endChangesetP4Id.longValue(); endBatchP4Id > -1L && endBatchP4Id > 0L; endBatchP4Id -= (long)changesetCount) {
            this.getStatus().throwOnStopRequested();
            LongLinkedOpenHashSet changesets = this.csDAO.getP4ChangeSetIdsWithLimit(endBatchP4Id, blockSize, true);
            changesetCount = changesets.size();
            if (changesetCount > 0) {
                Long startBatchP4Id = changesets.last();
                this.setStatusReindexingChangesets(endBatchP4Id, startBatchP4Id);
                this.indexChangeSets(startBatchP4Id, endBatchP4Id, true, (Collection<Long>)changesets);
                if (eggTimer.isTimeExpired()) {
                    return startBatchP4Id;
                }
            }
            if ((long)changesetCount >= blockSize) continue;
            return -1L;
        }
        return -1L;
    }

    @Override
    protected void resetScmMetaData() throws DbException {
        this.setPhase2Revision(0L);
        ((P4Cache)this.getCache()).setScanProperty(CommonProperties.META_LASTCHANGESETID.value, -1L);
        ((P4Cache)this.getCache()).setScanProperty(CommonProperties.CONTENT_LASTPATHID.value, -1L);
    }

    public long getPhase1Revision() throws DbException {
        return ((P4Cache)this.getCache()).getScanProperty(CommonProperties.PHASE1_SLURP.value, 0L);
    }

    private void setPhase1Revision(long latestPhase1Revision) throws DbException {
        ((P4Cache)this.getCache()).setScanProperty(CommonProperties.PHASE1_SLURP.value, latestPhase1Revision);
    }

    public long getPhase2Revision() throws DbException {
        return ((P4Cache)this.getCache()).getScanProperty(CommonProperties.PHASE2_SLURP.value, 0L);
    }

    private void setPhase2Revision(long latestPhase2Revision) throws DbException {
        ((P4Cache)this.getCache()).setScanProperty(CommonProperties.PHASE2_SLURP.value, latestPhase2Revision);
    }

    @Override
    protected boolean processRevisions() throws RepositoryClientException, DbException, ConfigException {
        long end;
        long start;
        long lastProcessed;
        long startRevision;
        boolean createOnDemand;
        boolean initialSlurp;
        if (this.latestRevision == -1L) {
            this.latestRevision = this.getClient().getLatestRevision();
        }
        P4Cache cache = (P4Cache)this.getCache();
        boolean bl = initialSlurp = this.getPhase1Revision() == 0L;
        if (initialSlurp) {
            long firstRev = 1L;
            if (this.latestRevision != 0L && this.latestRevision < firstRev) {
                this.latestRevision = firstRev;
            }
            createOnDemand = this.determineCreateOnDemand(firstRev);
            if (firstRev < this.getRepositoryInfo().getStartRev()) {
                firstRev = this.getRepositoryInfo().getStartRev();
            }
            startRevision = firstRev;
        } else {
            startRevision = this.getPhase1Revision() + 1L;
            createOnDemand = cache.hasScanProperty(CommonProperties.CREATE_ON_DEMAND.value) ? cache.getScanProperty(CommonProperties.CREATE_ON_DEMAND.value, 0L) == 1L : this.determineCreateOnDemand(1L);
        }
        if (this.getRepositoryInfo().getStartRev() > this.latestRevision) {
            throw new ConfigException("The start-rev value [" + this.getRepositoryInfo().getStartRev() + "] is not in the repository range [" + this.latestRevision + "]");
        }
        if (initialSlurp && createOnDemand && this.getRepositoryInfo().getImportMode() != ImportMode.NO_IMPORT) {
            long start2 = startRevision - 1L;
            if (start2 < 0L) {
                start2 = 1L;
            }
            this.updateRevList(start2, startRevision);
            try {
                this.createInitialImport(this.revListCache, startRevision);
            }
            catch (LicensePolicyException e2) {
                Logs.APP_LOG.error((Object)"Unable to import initial state of repository as it exceeds license limits", (Throwable)e2);
                throw new ConfigException(e2);
            }
        }
        this.updateRevList(startRevision, this.latestRevision);
        this.getStatus().clearEngineError();
        long commitBlockSize = this.getCommitBlockSize();
        boolean updateOccurred = false;
        while (!(this.revListCache.isEmpty() || this.getStatus().isStopRequested() || (lastProcessed = this.slurpRevisionBlock(start = this.revListCache.getStartRevision(), end = this.revListCache.getBlockEnd(commitBlockSize))) == -1L || this.getStatus().isStopRequested())) {
            this.getStatus().setMessage("Committing changes from " + start + " - " + lastProcessed);
            Logs.APP_LOG.debug((Object)("Committing changes up to revision " + lastProcessed));
            this.indexChangeSets(start, lastProcessed, false);
            this.setPhase1Revision(lastProcessed);
            cache.commit();
            updateOccurred = true;
            this.revListCache.removeUpto(lastProcessed + 1L);
            if (!this.revListCache.isEmpty()) continue;
            this.updateRevList(lastProcessed + 1L, this.latestRevision);
        }
        this.getStatus().setMessage("");
        if (!this.getStatus().isStopRequested() && this.processTags()) {
            cache.commit();
            updateOccurred = true;
        }
        if (!this.getStatus().isStopRequested() && updateOccurred) {
            cache.setIndexingPhase(IndexingState.INDEXING_METADATA);
        }
        return updateOccurred;
    }

    private void indexChangeSets(long start, long end, boolean isUpdate) throws DbException {
        LongLinkedOpenHashSet changesets = this.fileRevDao.getChangeSets(start, end);
        this.indexChangeSets(start, end, isUpdate, new ReversedLongSortedSet((LongSortedSet)changesets));
    }

    private void indexChangeSets(long start, long end, boolean isUpdate, Collection<Long> changesets) {
        if (changesets.isEmpty()) {
            return;
        }
        Timer timer = this.startIndexingTimer(start, end);
        ArrayList<String> indexableChangeSets = new ArrayList<String>();
        boolean hasPre24Changesets = isUpdate && this.indexingContext.getCrossRepLuceneIndex().getRescanStatus((RevisionCache)this.getCache()).needsPre24ChangesetHandling();
        this.getChangesetIndexer().indexChangesetsAndAuthors(((P4Cache)this.getCache()).getCrossRepLuceneConnection(), (ChangeSetResolver)this.getCache(), Iterables.transform(changesets, (Function)Functions.toStringFunction()), this.getStatus(), isUpdate, (Collection<String>)indexableChangeSets, hasPre24Changesets);
        this.getBranchCrossRepoIndexer().indexBranchesForChangeSetIds((Iterable<String>)indexableChangeSets, (Iterable<Branch>)((P4Cache)this.getCache()).getBranches(), this.getCache(), this.getStatus());
        if (isUpdate) {
            this.getPathCrossRepoIndexer().indexPathsForChangeSetIds(this.getRepositoryInfo().getRepositoryName(), this.getCache(), (Iterable<String>)indexableChangeSets, this.getPathMatcher(), this.getStatus());
        }
        this.stopIndexingTimer(timer, changesets.size());
    }

    private boolean determineCreateOnDemand(long firstRev) throws DbException {
        boolean createOnDemand = firstRev < this.getRepositoryInfo().getStartRev();
        ((P4Cache)this.getCache()).setScanProperty(CommonProperties.CREATE_ON_DEMAND.value, createOnDemand ? 1L : 0L);
        return createOnDemand;
    }

    @Override
    protected boolean processMetadata() throws DbException {
        long latestRevision;
        long startRevision;
        boolean updateOccurred = false;
        if (!this.getStatus().isStopRequested() && (startRevision = this.getPhase2Revision() + 1L) <= (latestRevision = this.getPhase1Revision())) {
            this.indexMetadata(startRevision, latestRevision);
            if (this.isStopRequested()) {
                ((P4Cache)this.getCache()).rollback();
            } else {
                ((P4Cache)this.getCache()).commit();
                updateOccurred = true;
            }
        }
        if (!this.getStatus().isStopRequested()) {
            ((P4Cache)this.getCache()).setIndexingPhase(IndexingState.INDEXING_CONTENT);
            ((P4Cache)this.getCache()).commit();
        }
        return updateOccurred;
    }

    @Override
    protected boolean processContent() throws DbException, IOException {
        long latestRevision;
        long startRevision;
        boolean updateOccurred = false;
        if (!this.getStatus().isStopRequested() && (startRevision = this.getPhase2Revision() + 1L) <= (latestRevision = this.getPhase1Revision())) {
            this.indexContent(startRevision, latestRevision);
            if (!this.getStatus().isStopRequested()) {
                this.setPhase2Revision(latestRevision);
                ((P4Cache)this.getCache()).commit();
                updateOccurred = true;
            } else {
                ((P4Cache)this.getCache()).rollback();
            }
        }
        if (!this.getStatus().isStopRequested()) {
            ((P4Cache)this.getCache()).setIndexingPhase(IndexingState.PROCESSING_REVISIONS);
            ((P4Cache)this.getCache()).commit();
        }
        return updateOccurred;
    }

    private void updateRevList(long startRevision, long endRevision) throws RepositoryClientException {
        Long2ObjectMap<P4ChangeList> newEntries;
        this.revListCache.removeUpto(startRevision);
        long lastCached = this.revListCache.getEndRevision();
        if (lastCached == endRevision) {
            return;
        }
        long searchStart = lastCached == -1L ? startRevision : lastCached + 1L;
        if (searchStart <= endRevision && (newEntries = this.getRevList(searchStart, endRevision)) != null) {
            this.revListCache.add(newEntries);
        }
    }

    public RepositoryInfo getRepositoryInfo() {
        return this.p4RepInfo;
    }

    public void indexMetadata(long startChangeset, long endChangeset) throws DbException {
        Timer timer = new Timer("Indexing revision metadata from changeset " + startChangeset + ":" + endChangeset);
        this.getStatus().setMessage("Indexing revision metadata from changeset " + startChangeset + " to " + endChangeset);
        long lastChangeset = ((P4Cache)this.getCache()).getScanProperty(CommonProperties.META_LASTCHANGESETID.value, -1L);
        long start = System.currentTimeMillis();
        this.indexRevisions(Math.max(startChangeset, lastChangeset), endChangeset);
        long numChangesets = endChangeset - Math.max(startChangeset, lastChangeset);
        Logs.APP_LOG.debug((Object)("[" + this.getRepoName() + "]   metadata index took: " + (System.currentTimeMillis() - start) / 1000L + "s. " + numChangesets + " changesets"));
        timer.end();
    }

    private void indexRevisions(long startChangeset, long endChangeset) throws DbException {
        int count = 0;
        int totalPending = 0;
        long total = endChangeset - startChangeset + 1L;
        LinkedList<RevidChangeSet> changesets = new LinkedList<RevidChangeSet>();
        int batchSize = 400;
        for (long i2 = startChangeset; i2 <= endChangeset && !this.getStatus().isStopRequested(); ++i2) {
            RevidChangeSet cs = (RevidChangeSet)this.csDAO.load(Long.toString(i2));
            if (cs != null) {
                changesets.add(cs);
                totalPending += cs.getRevisionInfosCount() + 1;
                ++count;
            } else {
                --total;
            }
            if (totalPending < batchSize && i2 != endChangeset) continue;
            this.getStatus().setMessage("Indexing revision metadata item " + count + " of " + total);
            this.indexBatch(changesets);
            changesets.clear();
            totalPending = 0;
            ((P4Cache)this.getCache()).setScanProperty(CommonProperties.META_LASTCHANGESETID.value, i2);
            ((P4Cache)this.getCache()).commit();
        }
        ((P4Cache)this.getCache()).commit();
        Logs.APP_LOG.info((Object)(this.getRepoName() + " finished indexing revisions: " + startChangeset + " - " + endChangeset));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void indexContent(long startRevision, long endRevision) throws DbException, IOException {
        Timer timer = new Timer("Indexing content " + startRevision + ":" + endRevision);
        if (this.getRepositoryInfo().isContentIndexingEnabled()) {
            this.getStatus().setMessage("Indexing content from changeset " + startRevision + " to " + endRevision);
            SortedIntSet physicalPaths = this.getPhysicalPaths(startRevision, endRevision);
            long lastPathId = ((P4Cache)this.getCache()).getScanProperty(CommonProperties.CONTENT_LASTPATHID.value, -1L);
            if (lastPathId != -1L) {
                BitSets.clear(physicalPaths, 0L, lastPathId);
            }
            boolean indexedOk = false;
            try {
                this.deleteContent(physicalPaths);
                this.indexUpdatedContent(physicalPaths);
                if (!this.getStatus().isStopRequested()) {
                    indexedOk = true;
                }
            }
            finally {
                if (!indexedOk) {
                    this.deleteContent(physicalPaths);
                }
            }
        }
        timer.end();
    }

    private void indexBatch(List<RevidChangeSet> changesets) throws DbException {
        try {
            Timer timer = new Timer("Indexing metadata batch sized " + changesets.size());
            this.getPathCrossRepoIndexer().indexPathsForChangeSets(this.getRepositoryInfo().getRepositoryName(), changesets, this.getPathMatcher(), this.getStatus());
            this.getBranchCrossRepoIndexer().indexBranchesForChangeSetIds(Iterables.transform(changesets, ChangeSet.TO_CSID), (Iterable<Branch>)((P4Cache)this.getCache()).getBranches(), this.getCache(), this.getStatus());
            timer.end();
        }
        catch (Exception e2) {
            Logs.APP_LOG.debug((Object)"error in metadata scanning, skipping");
        }
    }

    private void deleteContent(SortedIntSet paths) throws DbException {
        if (this.getRepositoryIndexer().hasContentDocuments()) {
            SegmentedIntSet subset = new SegmentedIntSet();
            int pathId = paths.nextSetBit(0);
            while (pathId >= 0 && !this.getStatus().isStopRequested()) {
                subset.set(pathId);
                if (subset.cardinality() > 1000) {
                    this.deleteContentSubSet(subset);
                    subset = new SegmentedIntSet();
                }
                pathId = paths.nextSetBit(pathId + 1);
            }
            this.deleteContentSubSet(subset);
        }
    }

    private void deleteContentSubSet(SortedIntSet physicalPaths) throws DbException {
        Collection<Path> outdatedRevids = this.getPaths(physicalPaths);
        this.getRepositoryIndexer().deleteContent(outdatedRevids);
    }

    protected long getCommitBlockSize() {
        return this.commitBlockSize;
    }

    public void setCommitBlockSize(long commitBlockSize) {
        this.commitBlockSize = commitBlockSize;
    }

    protected Collection<Path> getPaths(SortedIntSet physicalPaths) throws DbException {
        ArrayList<Path> paths = new ArrayList<Path>();
        int physicalPathId = physicalPaths.nextSetBit(0);
        while (physicalPathId >= 0) {
            paths.add(this.fileRevDao.getPath(physicalPathId));
            physicalPathId = physicalPaths.nextSetBit(physicalPathId + 1);
        }
        return paths;
    }

    @Override
    public synchronized String updateRevisions(String start, String end) throws RepositoryClientException, DbException, LicensePolicyException {
        return this.updateChangesets(Long.parseLong(start), Long.parseLong(end));
    }
}

