/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.atlassian.fisheye.spi.admin.data.ImportMode;
import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.perforce.P4ScmConfig;
import com.cenqua.fisheye.perforce.P4Utils;
import com.cenqua.fisheye.rep.RepositoryInfo;

public class P4RepositoryInfo
extends RepositoryInfo {
    private String basePathSpec;
    private Path basePath;
    private P4ScmConfig p4Config;

    public P4RepositoryInfo(RepositoryConfig cfg) {
        super(cfg);
        this.p4Config = (P4ScmConfig)cfg.getScmConfig();
        this.setBasePath(this.p4Config.getPath());
        this.setStartRev(this.p4Config.getStartRev());
        this.setImportMode(this.p4Config.isInitialImport() ? ImportMode.IMPORT_WITHOUT_TAGS : ImportMode.NO_IMPORT);
        if (this.p4Config.getCommandTimeout() != null) {
            this.setCommandTimeout(this.p4Config.getCommandTimeout().getValueInMillis());
        }
    }

    private void setBasePath(String p4PathSpec) {
        if (p4PathSpec == null || p4PathSpec.trim().length() == 0) {
            this.basePath = null;
        } else {
            this.basePathSpec = p4PathSpec.trim();
            if (this.basePathSpec.endsWith("...")) {
                this.basePathSpec = this.basePathSpec.substring(0, this.basePathSpec.length() - "...".length());
            }
            if (this.basePathSpec.endsWith("/")) {
                this.basePathSpec = this.basePathSpec.substring(0, this.basePathSpec.length() - 1);
            }
            this.basePath = new Path(this.basePathSpec.substring(1));
        }
    }

    public boolean isCaseSensitive() {
        return this.p4Config.isCaseSensitive();
    }

    public int getMaxFilelogs() {
        return this.p4Config.getMaxFilelogs();
    }

    public String getServer() {
        return this.p4Config.getServer();
    }

    public int getPort() {
        return this.p4Config.getPort();
    }

    public String getUsername() {
        return this.p4Config.getNetworkSettings().getUsername();
    }

    public String getPassword() {
        return this.p4Config.getNetworkSettings().getPassword();
    }

    public String getBasePath() {
        return this.basePathSpec;
    }

    public boolean isUnicode() {
        return this.p4Config.isUnicodeServer();
    }

    public boolean isSkipLabels() {
        return this.p4Config.isSkipLabels();
    }

    @Override
    public Path getLocalPath(String p4Path, long rev) {
        return P4Utils.getLocalPath(this.basePath, this.isCaseSensitive(), p4Path);
    }

    @Override
    public String getRepositoryDescriptor() {
        return this.getServer() + ":" + this.getPort() + this.getBasePath();
    }

    @Override
    public String getServerPath(Path localPath, long rev) {
        return P4Utils.getServerPath(this.basePathSpec, localPath);
    }

    public String getEncoding() {
        return this.p4Config.getEncoding();
    }

    public boolean isMultiPrintEnabled() {
        return this.p4Config.isMultiPrintEnabled();
    }

    public void testConnection() throws ConfigException {
        this.p4Config.testConnection(this);
    }
}

