/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.atlassian.fecru.upgrade.UpgradeManager;
import com.cenqua.fisheye.RepositoryConfig;
import com.cenqua.fisheye.config.ConfigException;
import com.cenqua.fisheye.perforce.P4Cache;
import com.cenqua.fisheye.perforce.P4RepositoryInfo;
import com.cenqua.fisheye.perforce.P4Scanner;
import com.cenqua.fisheye.perforce.P4ScmConfig;
import com.cenqua.fisheye.perforce.client.P4ClientFactory;
import com.cenqua.fisheye.perforce.search.P4QueryBuilder;
import com.cenqua.fisheye.rep.BaseRepositoryEngine;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.IndexingContext;
import com.cenqua.fisheye.rep.NetworkRepositorySettings;
import com.cenqua.fisheye.rep.RevInfoKey;
import com.cenqua.fisheye.search.QueryBuilder;
import com.cenqua.fisheye.util.Throttle;

public class P4RepositoryEngine
extends BaseRepositoryEngine<P4Scanner, P4Cache> {
    private final P4ScmConfig p4Config;
    private final P4RepositoryInfo repoInfo;

    public P4RepositoryEngine(RepositoryConfig config, UpgradeManager upgradeManager, IndexingContext indexingContext) {
        super(config, upgradeManager, indexingContext);
        this.p4Config = (P4ScmConfig)config.getScmConfig();
        config.getAllowRules().setCaseSensitive(this.p4Config.isCaseSensitive());
        this.repoInfo = new P4RepositoryInfo(this.getCfg());
    }

    @Override
    protected P4Scanner createScanner() throws DbException {
        P4Scanner scanner = new P4Scanner(this);
        scanner.setCommitBlockSize(this.p4Config.getBlocksize());
        return scanner;
    }

    @Override
    protected P4Cache createCache(long cacheSerial) {
        NetworkRepositorySettings networkSettings = this.p4Config.getNetworkSettings();
        float throttleLimit = networkSettings.getCps();
        Throttle throttle = new Throttle();
        if (throttleLimit > 0.0f) {
            throttle.setOperationsPerSecond(throttleLimit);
        }
        P4ClientFactory clientFactory = new P4ClientFactory(this.repoInfo, throttle, this.getStatus());
        return new P4Cache(cacheSerial, this.getDiskCacheVersion(), this.repoInfo, this.getIndexConnection(), this.getDatabaseHandle(), this.getLicenseEnforcer(), this.getIndexingContext(), clientFactory);
    }

    @Override
    protected void ensureCorrectScmVersion() throws ConfigException {
    }

    @Override
    public void requestFullscan() {
    }

    @Override
    protected long getPollPeriod() {
        return this.p4Config.getNetworkSettings().getPollPeriod();
    }

    @Override
    protected QueryBuilder createQueryBuilder() {
        return new P4QueryBuilder(this);
    }

    @Override
    public String getLink(RevInfoKey revInfoKey) {
        long rev = Long.parseLong(revInfoKey.getRev());
        return "p4 -p " + this.repoInfo.getServer() + ":" + this.repoInfo.getPort() + " filelog " + this.repoInfo.getServerPath(revInfoKey.getPath(), rev) + "@" + rev;
    }

    public P4RepositoryInfo getRepoInfo() {
        return this.repoInfo;
    }

    @Override
    protected long getPausePeriodMillis() {
        return 120000L;
    }
}

