/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.cenqua.fisheye.logging.Logs;
import com.cenqua.fisheye.perforce.P4BranchMapping;
import com.cenqua.fisheye.perforce.P4BranchSpec;
import com.cenqua.fisheye.perforce.P4Scanner;
import com.cenqua.fisheye.perforce.client.P4ChangePath;
import com.cenqua.fisheye.perforce.client.P4ClientException;
import com.cenqua.fisheye.perforce.db.P4RevInfoDAO;
import com.cenqua.fisheye.rep.DbException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class P4RepoBranches {
    private final Map<String, Long> branchTimes = new HashMap<String, Long>();
    private final Map<String, P4BranchSpec> branchSpecs = new HashMap<String, P4BranchSpec>();
    private final Set<String> branchNotInRepo = new HashSet<String>();
    private final P4RevInfoDAO fileRevDao;
    private final P4Scanner scanner;

    public P4RepoBranches(P4RevInfoDAO p4RevInfoDAO, P4Scanner scanner) {
        this.fileRevDao = p4RevInfoDAO;
        this.scanner = scanner;
        ArrayList<P4BranchSpec> allBranchSpecs = new ArrayList<P4BranchSpec>();
        p4RevInfoDAO.loadBranches(this.branchTimes, allBranchSpecs);
        for (P4BranchSpec branchSpec : allBranchSpecs) {
            this.recordBranchInCache(branchSpec);
        }
    }

    protected Map<String, P4BranchSpec> getBranchSpecs() {
        return this.branchSpecs;
    }

    public void updateBranchMappings() throws P4ClientException, DbException {
        Map<String, Long> updatedTimes = this.scanner.getClient().getBranchUpdateTimes();
        for (Map.Entry<String, Long> entry : updatedTimes.entrySet()) {
            String branchName = entry.getKey();
            Long newTime = entry.getValue();
            if (newTime != null) {
                boolean branchSpecNotLoaded;
                Long oldTime = this.branchTimes.get(branchName);
                boolean bl = branchSpecNotLoaded = !this.branchSpecs.containsKey(branchName) && !this.branchNotInRepo.contains(branchName);
                if (oldTime == null || newTime > oldTime || branchSpecNotLoaded) {
                    if (branchSpecNotLoaded) {
                        Logs.APP_LOG.info((Object)("Retrieving missing branch spec for branch '" + branchName + "' in repo '" + this.scanner.getRepositoryInfo().getRepositoryName() + "'"));
                    }
                    Logs.APP_LOG.debug((Object)("Adding/Updating branch: " + branchName + ", old update time is " + oldTime + ", and update new time is " + newTime));
                    this.branchTimes.put(branchName, newTime);
                    this.loadBranchInfo(branchName, newTime);
                }
            }
            if (!this.scanner.getStatus().isStopRequested()) continue;
            return;
        }
    }

    private void loadBranchInfo(String branchName, long branchTime) throws P4ClientException, DbException {
        P4BranchSpec branchSpec = this.scanner.getClient().getBranchSpec(branchName);
        if (branchSpec != null) {
            this.fileRevDao.storeBranch(branchSpec, branchTime);
            this.recordBranchInCache(branchSpec);
        }
    }

    private void recordBranchInCache(P4BranchSpec branchSpec) {
        String branchName = branchSpec.getName();
        this.branchNotInRepo.add(branchName);
        for (P4BranchMapping mapping : branchSpec.getMappings()) {
            if (!this.scanner.getRepositoryInfo().isPathInRepo(mapping.getTo(), -1L) || !this.scanner.getRepositoryInfo().isPathInRepo(mapping.getFrom(), -1L)) continue;
            this.branchSpecs.put(branchName, branchSpec);
            this.branchNotInRepo.remove(branchName);
            break;
        }
    }

    public String getChangePathBranch(P4ChangePath changePath) {
        for (Map.Entry<String, P4BranchSpec> entry : this.branchSpecs.entrySet()) {
            String name = entry.getKey();
            P4BranchSpec branchSpec = entry.getValue();
            for (P4BranchMapping mapping : branchSpec.getMappings()) {
                if (!mapping.matches(changePath)) continue;
                return name;
            }
        }
        return "head";
    }
}

