/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.cenqua.fisheye.perforce.client.P4ChangePath;
import com.cenqua.fisheye.perforce.client.P4FileSpec;
import com.cenqua.fisheye.rep.DiffTextCache;
import com.cenqua.fisheye.util.LineCounter;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParsePosition;
import java.util.Map;

public class P4MultiLineCountStream
extends OutputStream {
    private static final int MAX_LINE = 8192;
    private StringBuilder currentLine = new StringBuilder();
    private P4FileSpec currentSpec;
    private long currentCount;
    private LineCounter counter = new LineCounter();
    private Map<P4FileSpec, P4ChangePath> files;
    private CountVisitor visitor;
    private DiffTextCache diffTextCache;
    long csid;

    public P4MultiLineCountStream(Map<P4FileSpec, P4ChangePath> files, DiffTextCache diffTextCache, long csid, CountVisitor visitor) {
        this.files = files;
        this.visitor = visitor;
        this.diffTextCache = diffTextCache;
        this.csid = csid;
    }

    @Override
    public void write(int b2) throws IOException {
        boolean eol = this.counter.process(b2);
        if (!eol) {
            if (b2 != 10) {
                if (this.currentLine.length() < 8192) {
                    this.currentLine.append((char)b2);
                } else {
                    this.currentLine.delete(0, this.currentLine.length() - 4096);
                }
            }
        } else {
            if (this.counter.getCharCount() > this.currentCount) {
                P4FileSpec newSpec;
                ParsePosition start = new ParsePosition(0);
                ParsePosition end = new ParsePosition(this.currentLine.length());
                while ((newSpec = P4FileSpec.match(this.currentLine, start, end)) != null) {
                    String followingString = this.currentLine.substring(end.getIndex());
                    if (this.files.containsKey(newSpec) && followingString.startsWith(" - ")) {
                        int offset = start.getIndex() == 0 ? -1 : 0;
                        this.sendCount(offset);
                        this.counter.resetCount();
                        this.currentSpec = newSpec;
                        this.diffTextCache.finishFileRevision();
                        this.diffTextCache.startFileRevision(true, this.files.get(newSpec));
                        this.currentCount = this.files.get(this.currentSpec).getFileSize();
                        break;
                    }
                    this.diffTextCache.finishFileRevision();
                    start.setIndex(start.getIndex() + 1);
                }
            }
            this.diffTextCache.addByte((byte)b2);
            this.currentLine.setLength(0);
        }
    }

    private void sendCount(int offset) {
        if (this.currentSpec != null) {
            this.visitor.visit(this.currentSpec, this.counter.getLineCount() + offset);
        }
    }

    @Override
    public void close() throws IOException {
        this.flush();
        this.sendCount(0);
    }

    public static interface CountVisitor {
        public void visit(P4FileSpec var1, int var2);
    }
}

