/*
 * Decompiled with CFR 0.152.
 */
package com.cenqua.fisheye.perforce;

import com.cenqua.fisheye.Path;
import com.cenqua.fisheye.rep.DbException;
import com.cenqua.fisheye.rep.FileRevision;
import com.cenqua.fisheye.rep.IndexableFileRevision;
import com.cenqua.fisheye.rep.SortedMapFileHistory;
import com.google.common.collect.TreeMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.SortedMap;

public class P4FileHistory
extends SortedMapFileHistory {
    public P4FileHistory(Path path, TreeMultimap<Long, FileRevision> revisions) {
        super(path, revisions);
    }

    @Override
    public String resolveRevisionFromString(Path lpath, String s2) throws DbException {
        try {
            Long rev = Long.valueOf(s2);
            if (this.getRevisionMap().containsKey((Object)rev)) {
                return s2;
            }
            SortedMap headMap = this.getRevisionMap().asMap().headMap(rev);
            ArrayList<Long> keys = new ArrayList<Long>(headMap.keySet());
            for (int i2 = keys.size() - 1; i2 >= 0; --i2) {
                Long key = (Long)keys.get(i2);
                for (FileRevision revision : (Collection)headMap.get(key)) {
                    if (!revision.getPath().equals(lpath)) continue;
                    return key.toString();
                }
            }
        }
        catch (NumberFormatException rev) {
            // empty catch block
        }
        IndexableFileRevision br = null;
        for (FileRevision info : this.getRevisions()) {
            if (info.getTags().contains(s2)) {
                return info.getRevision();
            }
            if (!info.getBranch().equals(s2)) continue;
            if (br == null) {
                br = info;
                continue;
            }
            if (info.getDate() <= br.getDate()) continue;
            br = info;
        }
        if (br != null) {
            return br.getRevision();
        }
        if ("HEAD".equals(s2)) {
            return this.getHead();
        }
        return null;
    }

    @Override
    public String getMainBranch() {
        return "head";
    }
}

